/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.inventory.item;

import java.util.Locale;
import org.checkerframework.checker.nullness.qual.Nullable;

public enum Enchantment {
    PROTECTION,
    FIRE_PROTECTION,
    FEATHER_FALLING,
    BLAST_PROTECTION,
    PROJECTILE_PROTECTION,
    THORNS,
    RESPIRATION,
    DEPTH_STRIDER,
    AQUA_AFFINITY,
    SHARPNESS,
    SMITE,
    BANE_OF_ARTHROPODS,
    KNOCKBACK,
    FIRE_ASPECT,
    LOOTING,
    EFFICIENCY,
    SILK_TOUCH,
    UNBREAKING,
    FORTUNE,
    POWER,
    PUNCH,
    FLAME,
    INFINITY,
    LUCK_OF_THE_SEA,
    LURE,
    FROST_WALKER,
    MENDING,
    BINDING_CURSE,
    VANISHING_CURSE,
    IMPALING,
    RIPTIDE,
    LOYALTY,
    CHANNELING,
    MULTISHOT,
    PIERCING,
    QUICK_CHARGE,
    SOUL_SPEED,
    SWIFT_SNEAK;

    private static final Enchantment[] VALUES;
    private final String javaIdentifier = "minecraft:" + this.name().toLowerCase(Locale.ENGLISH);

    public static @Nullable Enchantment getByJavaIdentifier(String javaIdentifier) {
        for (Enchantment enchantment : VALUES) {
            if (!enchantment.javaIdentifier.equals(javaIdentifier) && !enchantment.name().toLowerCase(Locale.ENGLISH).equalsIgnoreCase(javaIdentifier)) continue;
            return enchantment;
        }
        return null;
    }

    public static @Nullable Enchantment getByBedrockId(int bedrockId) {
        if (bedrockId >= 0 && bedrockId < VALUES.length) {
            return VALUES[bedrockId];
        }
        return null;
    }

    public String getJavaIdentifier() {
        return this.javaIdentifier;
    }

    static {
        VALUES = Enchantment.values();
    }

    public static enum JavaEnchantment {
        PROTECTION,
        FIRE_PROTECTION,
        FEATHER_FALLING,
        BLAST_PROTECTION,
        PROJECTILE_PROTECTION,
        RESPIRATION,
        AQUA_AFFINITY,
        THORNS,
        DEPTH_STRIDER,
        FROST_WALKER,
        BINDING_CURSE,
        SOUL_SPEED,
        SWIFT_SNEAK,
        SHARPNESS,
        SMITE,
        BANE_OF_ARTHROPODS,
        KNOCKBACK,
        FIRE_ASPECT,
        LOOTING,
        SWEEPING_EDGE,
        EFFICIENCY,
        SILK_TOUCH,
        UNBREAKING,
        FORTUNE,
        POWER,
        PUNCH,
        FLAME,
        INFINITY,
        LUCK_OF_THE_SEA,
        LURE,
        LOYALTY,
        IMPALING,
        RIPTIDE,
        CHANNELING,
        MULTISHOT,
        QUICK_CHARGE,
        PIERCING,
        DENSITY,
        BREACH,
        WIND_BURST,
        MENDING,
        VANISHING_CURSE;

        private static final JavaEnchantment[] VALUES;
        public static final String[] ALL_JAVA_IDENTIFIERS;

        public static JavaEnchantment of(int index) {
            return VALUES[index];
        }

        public static @Nullable JavaEnchantment getByJavaIdentifier(String javaIdentifier) {
            if (!((String)javaIdentifier).startsWith("minecraft:")) {
                javaIdentifier = "minecraft:" + (String)javaIdentifier;
            }
            for (int i = 0; i < ALL_JAVA_IDENTIFIERS.length; ++i) {
                if (!ALL_JAVA_IDENTIFIERS[i].equalsIgnoreCase((String)javaIdentifier)) continue;
                return VALUES[i];
            }
            return null;
        }

        static {
            VALUES = JavaEnchantment.values();
            ALL_JAVA_IDENTIFIERS = new String[VALUES.length];
            for (int i = 0; i < ALL_JAVA_IDENTIFIERS.length; ++i) {
                JavaEnchantment.ALL_JAVA_IDENTIFIERS[i] = "minecraft:" + VALUES[i].name().toLowerCase(Locale.ENGLISH);
            }
        }
    }
}

