/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.type;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.registry.type.ItemMappings;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.item.BedrockItemBuilder;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentType;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponents;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.LodestoneTracker;

public class CompassItem
extends Item {
    public CompassItem(String javaIdentifier, Item.Builder builder) {
        super(javaIdentifier, builder);
    }

    @Override
    public ItemData.Builder translateToBedrock(int count, DataComponents components, ItemMapping mapping, ItemMappings mappings) {
        if (this.isLodestoneCompass(components)) {
            return super.translateToBedrock(count, components, mappings.getLodestoneCompass(), mappings);
        }
        return super.translateToBedrock(count, components, mapping, mappings);
    }

    @Override
    public ItemMapping toBedrockDefinition(DataComponents components, ItemMappings mappings) {
        if (this.isLodestoneCompass(components)) {
            return mappings.getLodestoneCompass();
        }
        return super.toBedrockDefinition(components, mappings);
    }

    @Override
    public void translateComponentsToBedrock(@NonNull GeyserSession session, @NonNull DataComponents components, @NonNull BedrockItemBuilder builder) {
        super.translateComponentsToBedrock(session, components, builder);
        LodestoneTracker tracker = components.get(DataComponentType.LODESTONE_TRACKER);
        if (tracker != null) {
            int trackId = session.getLodestoneCache().store(tracker);
            builder.putInt("trackingHandle", trackId);
        }
    }

    private boolean isLodestoneCompass(@Nullable DataComponents components) {
        if (components != null) {
            return components.getDataComponents().containsKey(DataComponentType.LODESTONE_TRACKER);
        }
        return false;
    }

    @Override
    public @NonNull GeyserItemStack translateToJava(@NonNull ItemData itemData, @NonNull ItemMapping mapping, @NonNull ItemMappings mappings) {
        if (mapping.getBedrockIdentifier().equals("minecraft:lodestone_compass")) {
            mapping = mappings.getStoredItems().compass();
        }
        return super.translateToJava(itemData, mapping, mappings);
    }
}

