/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.level.block;

import java.util.BitSet;
import java.util.Locale;
import org.geysermc.geyser.level.block.DoubleChestValue;
import org.geysermc.geyser.level.physics.Direction;
import org.geysermc.geyser.level.physics.PistonBehavior;
import org.geysermc.geyser.platform.spigot.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.ints.Int2BooleanMap;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.ints.Int2BooleanOpenHashMap;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.ints.Int2ByteMap;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.ints.Int2ByteOpenHashMap;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.ints.Int2IntMap;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.ints.IntSet;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.objects.Object2IntMap;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.registry.type.BlockMapping;
import org.geysermc.geyser.translator.level.block.entity.PistonBlockEntityTranslator;
import org.geysermc.geyser.util.collection.FixedInt2ByteMap;
import org.geysermc.geyser.util.collection.FixedInt2IntMap;
import org.geysermc.geyser.util.collection.LecternHasBookMap;

public final class BlockStateValues {
    private static final IntSet ALL_CAULDRONS = new IntOpenHashSet();
    private static final Int2IntMap BANNER_COLORS = new FixedInt2IntMap();
    private static final Int2ByteMap BED_COLORS = new FixedInt2ByteMap();
    private static final Int2IntMap BRUSH_PROGRESS = new Int2IntOpenHashMap();
    private static final Int2ByteMap COMMAND_BLOCK_VALUES = new Int2ByteOpenHashMap();
    private static final Int2ObjectMap<DoubleChestValue> DOUBLE_CHEST_VALUES = new Int2ObjectOpenHashMap<DoubleChestValue>();
    private static final Int2ObjectMap<String> FLOWER_POT_VALUES = new Int2ObjectOpenHashMap<String>();
    private static final IntSet HORIZONTAL_FACING_JIGSAWS = new IntOpenHashSet();
    private static final LecternHasBookMap LECTERN_BOOK_STATES = new LecternHasBookMap();
    private static final IntSet NON_WATER_CAULDRONS = new IntOpenHashSet();
    private static final Int2IntMap NOTEBLOCK_PITCHES = new FixedInt2IntMap();
    private static final Int2BooleanMap PISTON_VALUES = new Int2BooleanOpenHashMap();
    private static final IntSet STICKY_PISTONS = new IntOpenHashSet();
    private static final Object2IntMap<Direction> PISTON_HEADS = new Object2IntOpenHashMap<Direction>();
    private static final Int2ObjectMap<Direction> PISTON_ORIENTATION = new Int2ObjectOpenHashMap<Direction>();
    private static final IntSet ALL_PISTON_HEADS = new IntOpenHashSet();
    private static final IntSet MOVING_PISTONS = new IntOpenHashSet();
    private static final Int2ByteMap SKULL_VARIANTS = new FixedInt2ByteMap();
    private static final IntSet SKULL_POWERED = new IntOpenHashSet();
    private static final Int2ByteMap SKULL_ROTATIONS = new Int2ByteOpenHashMap();
    private static final Int2IntMap SKULL_WALL_DIRECTIONS = new Int2IntOpenHashMap();
    private static final Int2ByteMap SHULKERBOX_DIRECTIONS = new FixedInt2ByteMap();
    private static final Int2IntMap WATER_LEVEL = new Int2IntOpenHashMap();
    private static final IntSet UPPER_DOORS = new IntOpenHashSet();
    public static final int JAVA_AIR_ID = 0;
    public static int JAVA_COBWEB_ID;
    public static int JAVA_FURNACE_ID;
    public static int JAVA_FURNACE_LIT_ID;
    public static int JAVA_HONEY_BLOCK_ID;
    public static int JAVA_SLIME_BLOCK_ID;
    public static int JAVA_SPAWNER_ID;
    public static int JAVA_WATER_ID;
    public static final int NUM_WATER_LEVELS = 9;

    public static void storeBlockStateValues(String javaId, int javaBlockState, JsonNode blockData) {
        JsonNode shulkerDirection;
        JsonNode skullRotation;
        JsonNode brushedProgress;
        JsonNode bannerColor = blockData.get("banner_color");
        if (bannerColor != null) {
            BANNER_COLORS.put(javaBlockState, (byte)bannerColor.intValue());
            return;
        }
        JsonNode bedColor = blockData.get("bed_color");
        if (bedColor != null) {
            BED_COLORS.put(javaBlockState, (byte)bedColor.intValue());
            return;
        }
        JsonNode bedrockStates = blockData.get("bedrock_states");
        if (bedrockStates != null && (brushedProgress = bedrockStates.get("brushed_progress")) != null) {
            BRUSH_PROGRESS.put(javaBlockState, brushedProgress.intValue());
            return;
        }
        if (javaId.contains("command_block")) {
            COMMAND_BLOCK_VALUES.put(javaBlockState, javaId.contains("conditional=true") ? (byte)1 : 0);
            return;
        }
        if (blockData.get("double_chest_position") != null) {
            boolean isX = blockData.get("x") != null;
            boolean isDirectionPositive = blockData.get("x") != null && blockData.get("x").asBoolean() || blockData.get("z") != null && blockData.get("z").asBoolean();
            boolean isLeft = blockData.get("double_chest_position").asText().contains("left");
            DOUBLE_CHEST_VALUES.put(javaBlockState, new DoubleChestValue(isX, isDirectionPositive, isLeft));
            return;
        }
        if (javaId.startsWith("minecraft:potted_") || javaId.equals("minecraft:flower_pot")) {
            String name = javaId.replace("potted_", "");
            if (name.contains("azalea")) {
                name = name.replace("_bush", "");
            }
            FLOWER_POT_VALUES.put(javaBlockState, name);
            return;
        }
        if (javaId.startsWith("minecraft:lectern")) {
            LECTERN_BOOK_STATES.put(javaBlockState, javaId.contains("has_book=true"));
            return;
        }
        JsonNode notePitch = blockData.get("note_pitch");
        if (notePitch != null) {
            NOTEBLOCK_PITCHES.put(javaBlockState, blockData.get("note_pitch").intValue());
            return;
        }
        if (javaId.contains("piston[")) {
            if (javaId.startsWith("minecraft:moving_piston")) {
                MOVING_PISTONS.add(javaBlockState);
            } else {
                PISTON_VALUES.put(javaBlockState, javaId.contains("extended=true"));
            }
            if (javaId.contains("sticky")) {
                STICKY_PISTONS.add(javaBlockState);
            }
            PISTON_ORIENTATION.put(javaBlockState, BlockStateValues.getBlockDirection(javaId));
            return;
        }
        if (javaId.startsWith("minecraft:piston_head")) {
            ALL_PISTON_HEADS.add(javaBlockState);
            if (javaId.contains("short=false")) {
                PISTON_HEADS.put(BlockStateValues.getBlockDirection(javaId), javaBlockState);
            }
            return;
        }
        JsonNode skullVariation = blockData.get("variation");
        if (skullVariation != null) {
            SKULL_VARIANTS.put(javaBlockState, (byte)skullVariation.intValue());
        }
        if ((skullRotation = blockData.get("skull_rotation")) != null) {
            SKULL_ROTATIONS.put(javaBlockState, (byte)skullRotation.intValue());
        }
        if ((javaId.startsWith("minecraft:dragon_head[") || javaId.startsWith("minecraft:piglin_head[") || javaId.startsWith("minecraft:dragon_wall_head[") || javaId.startsWith("minecraft:piglin_wall_head[")) && javaId.contains("powered=true")) {
            SKULL_POWERED.add(javaBlockState);
        }
        if (javaId.contains("wall_skull") || javaId.contains("wall_head")) {
            String direction;
            int rotation = switch (direction = javaId.substring(javaId.lastIndexOf("facing=") + 7, javaId.lastIndexOf("powered=") - 1)) {
                case "north" -> 180;
                case "west" -> 90;
                case "east" -> 270;
                default -> 0;
            };
            SKULL_WALL_DIRECTIONS.put(javaBlockState, rotation);
        }
        if ((shulkerDirection = blockData.get("shulker_direction")) != null) {
            SHULKERBOX_DIRECTIONS.put(javaBlockState, (byte)shulkerDirection.intValue());
            return;
        }
        if (javaId.startsWith("minecraft:water") && !javaId.contains("cauldron")) {
            String strLevel = javaId.substring(javaId.lastIndexOf("level=") + 6, javaId.length() - 1);
            int level = Integer.parseInt(strLevel);
            WATER_LEVEL.put(javaBlockState, level);
            return;
        }
        if (javaId.startsWith("minecraft:jigsaw[orientation=")) {
            String blockStateData = javaId.substring(javaId.indexOf("orientation=") + "orientation=".length(), javaId.lastIndexOf(95));
            Direction direction = Direction.valueOf(blockStateData.toUpperCase(Locale.ROOT));
            if (direction.isHorizontal()) {
                HORIZONTAL_FACING_JIGSAWS.add(javaBlockState);
            }
            return;
        }
        if (javaId.contains("cauldron")) {
            ALL_CAULDRONS.add(javaBlockState);
        }
        if (javaId.contains("_cauldron") && !javaId.contains("water_")) {
            NON_WATER_CAULDRONS.add(javaBlockState);
        }
        if (javaId.contains("_door[") && javaId.contains("half=upper")) {
            UPPER_DOORS.add(javaBlockState);
        }
    }

    public static int getBannerColor(int state) {
        return BANNER_COLORS.getOrDefault(state, -1);
    }

    public static byte getBedColor(int state) {
        return BED_COLORS.getOrDefault(state, (byte)-1);
    }

    public static int getBrushProgress(int state) {
        return BRUSH_PROGRESS.getOrDefault(state, 0);
    }

    public static boolean isNonWaterCauldron(int state) {
        return NON_WATER_CAULDRONS.contains(state);
    }

    public static boolean isCauldron(int state) {
        return ALL_CAULDRONS.contains(state);
    }

    public static Int2ByteMap getCommandBlockValues() {
        return COMMAND_BLOCK_VALUES;
    }

    public static Int2ObjectMap<DoubleChestValue> getDoubleChestValues() {
        return DOUBLE_CHEST_VALUES;
    }

    public static Int2ObjectMap<String> getFlowerPotValues() {
        return FLOWER_POT_VALUES;
    }

    public static IntSet getHorizontalFacingJigsaws() {
        return HORIZONTAL_FACING_JIGSAWS;
    }

    public static LecternHasBookMap getLecternBookStates() {
        return LECTERN_BOOK_STATES;
    }

    public static int getNoteblockPitch(int state) {
        return NOTEBLOCK_PITCHES.getOrDefault(state, -1);
    }

    public static Int2BooleanMap getPistonValues() {
        return PISTON_VALUES;
    }

    public static boolean isStickyPiston(int blockState) {
        return STICKY_PISTONS.contains(blockState);
    }

    public static boolean isPistonHead(int state) {
        return ALL_PISTON_HEADS.contains(state);
    }

    public static int getPistonHead(Direction direction) {
        return PISTON_HEADS.getOrDefault((Object)direction, 0);
    }

    public static boolean isMovingPiston(int state) {
        return MOVING_PISTONS.contains(state);
    }

    public static Direction getPistonOrientation(int state) {
        return (Direction)((Object)PISTON_ORIENTATION.get(state));
    }

    public static boolean isBlockSticky(int state) {
        return state == JAVA_SLIME_BLOCK_ID || state == JAVA_HONEY_BLOCK_ID;
    }

    public static boolean isBlockAttached(int stateA, int stateB) {
        boolean aSticky = BlockStateValues.isBlockSticky(stateA);
        boolean bSticky = BlockStateValues.isBlockSticky(stateB);
        if (aSticky && bSticky) {
            return stateA == stateB;
        }
        return aSticky || bSticky;
    }

    public static boolean canPistonDestroyBlock(int state) {
        return BlockRegistries.JAVA_BLOCKS.getOrDefault(state, BlockMapping.DEFAULT).getPistonBehavior() == PistonBehavior.DESTROY;
    }

    public static boolean canPistonMoveBlock(int javaId, boolean isPushing) {
        if (javaId == 0) {
            return true;
        }
        if (PistonBlockEntityTranslator.isBlock(javaId)) {
            return !PISTON_VALUES.get(javaId);
        }
        BlockMapping block = BlockRegistries.JAVA_BLOCKS.getOrDefault(javaId, BlockMapping.DEFAULT);
        if ((double)block.getHardness() == -1.0) {
            return false;
        }
        return switch (block.getPistonBehavior()) {
            case PistonBehavior.BLOCK, PistonBehavior.DESTROY -> false;
            case PistonBehavior.PUSH_ONLY -> isPushing;
            default -> !block.isBlockEntity();
        };
    }

    public static byte getSkullVariant(int state) {
        return SKULL_VARIANTS.getOrDefault(state, (byte)-1);
    }

    public static byte getSkullRotation(int state) {
        return SKULL_ROTATIONS.getOrDefault(state, (byte)-1);
    }

    public static boolean isSkullPowered(int state) {
        return SKULL_POWERED.contains(state);
    }

    public static Int2IntMap getSkullWallDirections() {
        return SKULL_WALL_DIRECTIONS;
    }

    public static byte getShulkerBoxDirection(int state) {
        return SHULKERBOX_DIRECTIONS.getOrDefault(state, (byte)-1);
    }

    public static int getWaterLevel(int state) {
        return WATER_LEVEL.getOrDefault(state, -1);
    }

    public static boolean isUpperDoor(int state) {
        return UPPER_DOORS.contains(state);
    }

    public static double getWaterHeight(int state) {
        int waterLevel = BlockStateValues.getWaterLevel(state);
        if (((BitSet)BlockRegistries.WATERLOGGED.get()).get(state)) {
            waterLevel = 0;
        }
        if (waterLevel >= 0) {
            double waterHeight = 1.0 - (double)(waterLevel + 1) / 9.0;
            if (waterLevel >= 8) {
                waterHeight = 1.0;
            }
            return waterHeight;
        }
        return -1.0;
    }

    public static float getSlipperiness(int state) {
        String blockIdentifier;
        return switch (blockIdentifier = BlockRegistries.JAVA_BLOCKS.getOrDefault(state, BlockMapping.DEFAULT).getJavaIdentifier()) {
            case "minecraft:slime_block" -> 0.8f;
            case "minecraft:ice", "minecraft:packed_ice" -> 0.98f;
            case "minecraft:blue_ice" -> 0.989f;
            default -> 0.6f;
        };
    }

    private static Direction getBlockDirection(String javaId) {
        if (javaId.contains("down")) {
            return Direction.DOWN;
        }
        if (javaId.contains("up")) {
            return Direction.UP;
        }
        if (javaId.contains("south")) {
            return Direction.SOUTH;
        }
        if (javaId.contains("west")) {
            return Direction.WEST;
        }
        if (javaId.contains("north")) {
            return Direction.NORTH;
        }
        if (javaId.contains("east")) {
            return Direction.EAST;
        }
        throw new IllegalStateException();
    }

    private BlockStateValues() {
    }
}

