/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.spigot;

import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.data.MappingData;
import com.viaversion.viaversion.api.protocol.ProtocolPathEntry;
import com.viaversion.viaversion.api.protocol.version.ProtocolVersion;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.SocketAddress;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.PluginCommand;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.GeyserBootstrap;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.adapters.paper.PaperAdapters;
import org.geysermc.geyser.adapters.spigot.SpigotAdapters;
import org.geysermc.geyser.api.extension.Extension;
import org.geysermc.geyser.api.util.PlatformType;
import org.geysermc.geyser.command.GeyserCommandManager;
import org.geysermc.geyser.configuration.GeyserConfiguration;
import org.geysermc.geyser.dump.BootstrapDumpInfo;
import org.geysermc.geyser.level.WorldManager;
import org.geysermc.geyser.network.GameProtocol;
import org.geysermc.geyser.ping.GeyserLegacyPingPassthrough;
import org.geysermc.geyser.ping.IGeyserPingPassthrough;
import org.geysermc.geyser.platform.spigot.GeyserPaperLogger;
import org.geysermc.geyser.platform.spigot.GeyserPaperPingPassthrough;
import org.geysermc.geyser.platform.spigot.GeyserSpigotConfiguration;
import org.geysermc.geyser.platform.spigot.GeyserSpigotDumpInfo;
import org.geysermc.geyser.platform.spigot.GeyserSpigotInjector;
import org.geysermc.geyser.platform.spigot.GeyserSpigotLogger;
import org.geysermc.geyser.platform.spigot.GeyserSpigotPingPassthrough;
import org.geysermc.geyser.platform.spigot.GeyserSpigotUpdateListener;
import org.geysermc.geyser.platform.spigot.GeyserSpigotVersionChecker;
import org.geysermc.geyser.platform.spigot.PaperAdventure;
import org.geysermc.geyser.platform.spigot.ReflectedNames;
import org.geysermc.geyser.platform.spigot.command.GeyserBrigadierSupport;
import org.geysermc.geyser.platform.spigot.command.GeyserSpigotCommandExecutor;
import org.geysermc.geyser.platform.spigot.command.GeyserSpigotCommandManager;
import org.geysermc.geyser.platform.spigot.shaded.me.lucko.commodore.CommodoreProvider;
import org.geysermc.geyser.platform.spigot.world.GeyserPistonListener;
import org.geysermc.geyser.platform.spigot.world.GeyserSpigotBlockPlaceListener;
import org.geysermc.geyser.platform.spigot.world.manager.GeyserSpigotLegacyNativeWorldManager;
import org.geysermc.geyser.platform.spigot.world.manager.GeyserSpigotNativeWorldManager;
import org.geysermc.geyser.platform.spigot.world.manager.GeyserSpigotWorldManager;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.util.FileUtils;

public class GeyserSpigotPlugin
extends JavaPlugin
implements GeyserBootstrap {
    private GeyserSpigotCommandManager geyserCommandManager;
    private GeyserSpigotConfiguration geyserConfig;
    private GeyserSpigotInjector geyserInjector;
    private GeyserSpigotLogger geyserLogger;
    private IGeyserPingPassthrough geyserSpigotPingPassthrough;
    private GeyserSpigotWorldManager geyserWorldManager;
    private GeyserImpl geyser;
    private String minecraftVersion;

    public void onLoad() {
        this.onGeyserInitialize();
    }

    @Override
    public void onGeyserInitialize() {
        block7: {
            GeyserLocale.init(this);
            try {
                ByteBuf.class.getMethod("writeShortLE", Integer.TYPE);
                Class.forName("org.bukkit.event.server.ServerLoadEvent");
                BlockData.class.getMethod("getAsString", new Class[0]);
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                this.getLogger().severe("*********************************************");
                this.getLogger().severe("");
                this.getLogger().severe(GeyserLocale.getLocaleStringLog("geyser.bootstrap.unsupported_server.header"));
                this.getLogger().severe(GeyserLocale.getLocaleStringLog("geyser.bootstrap.unsupported_server.message", "1.13.2"));
                this.getLogger().severe("");
                this.getLogger().severe("*********************************************");
                Bukkit.getPluginManager().disablePlugin((Plugin)this);
                return;
            }
            try {
                Class.forName("net.md_5.bungee.chat.ComponentSerializer");
            }
            catch (ClassNotFoundException e) {
                if (PaperAdventure.canSendMessageUsingComponent()) break block7;
                this.getLogger().severe("*********************************************");
                this.getLogger().severe("");
                this.getLogger().severe(GeyserLocale.getLocaleStringLog("geyser.bootstrap.unsupported_server_type.header", this.getServer().getName()));
                this.getLogger().severe(GeyserLocale.getLocaleStringLog("geyser.bootstrap.unsupported_server_type.message", "Paper"));
                this.getLogger().severe("");
                this.getLogger().severe("*********************************************");
                Bukkit.getPluginManager().disablePlugin((Plugin)this);
                return;
            }
        }
        try {
            Class.forName("io.netty.util.internal.ObjectPool$ObjectCreator");
        }
        catch (ClassNotFoundException e) {
            this.getLogger().severe("*********************************************");
            this.getLogger().severe("");
            this.getLogger().severe("This version of Spigot is using an outdated version of netty. Please use Paper instead!");
            this.getLogger().severe("");
            this.getLogger().severe("*********************************************");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        if (!this.loadConfig()) {
            return;
        }
        this.geyserLogger = GeyserPaperLogger.supported() ? new GeyserPaperLogger((Plugin)this, this.getLogger(), this.geyserConfig.isDebugMode()) : new GeyserSpigotLogger(this.getLogger(), this.geyserConfig.isDebugMode());
        GeyserConfiguration.checkGeyserConfiguration(this.geyserConfig, this.geyserLogger);
        this.minecraftVersion = Bukkit.getServer().getVersion().split("\\(MC: ")[1].split("\\)")[0];
        this.geyser = GeyserImpl.load(PlatformType.SPIGOT, this);
    }

    public void onEnable() {
        this.geyserCommandManager = new GeyserSpigotCommandManager(this.geyser);
        this.geyserCommandManager.init();
        CommandMap commandMap = GeyserSpigotCommandManager.getCommandMap();
        for (Extension extension : this.geyserCommandManager.extensionCommands().keySet()) {
            try {
                Constructor constructor = PluginCommand.class.getDeclaredConstructor(String.class, Plugin.class);
                constructor.setAccessible(true);
                PluginCommand pluginCommand = (PluginCommand)constructor.newInstance(extension.description().id(), this);
                pluginCommand.setDescription("The main command for the " + extension.name() + " Geyser extension!");
                commandMap.register(extension.description().id(), "geyserext", (Command)pluginCommand);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                this.geyserLogger.error("Failed to construct PluginCommand for extension " + extension.name(), ex);
            }
        }
        Bukkit.getPluginManager().registerEvents(new Listener(){

            @EventHandler
            public void onServerLoaded(ServerLoadEvent event) {
                if (event.getType() == ServerLoadEvent.LoadType.RELOAD) {
                    GeyserSpigotPlugin.this.geyser.setShuttingDown(false);
                }
                GeyserSpigotPlugin.this.onGeyserEnable();
            }
        }, (Plugin)this);
    }

    @Override
    public void onGeyserEnable() {
        block16: {
            if (GeyserImpl.getInstance().isReloading()) {
                if (!this.loadConfig()) {
                    return;
                }
                this.geyserLogger.setDebug(this.geyserConfig.isDebugMode());
                GeyserConfiguration.checkGeyserConfiguration(this.geyserConfig, this.geyserLogger);
            }
            GeyserImpl.start();
            this.geyserSpigotPingPassthrough = this.geyserConfig.isLegacyPingPassthrough() ? GeyserLegacyPingPassthrough.init(this.geyser) : (ReflectedNames.checkPaperPingEvent() ? new GeyserPaperPingPassthrough(this.geyserLogger) : (ReflectedNames.newSpigotPingConstructorExists() ? new GeyserSpigotPingPassthrough(this.geyserLogger) : GeyserLegacyPingPassthrough.init(this.geyser)));
            this.geyserLogger.debug("Spigot ping passthrough type: " + (this.geyserSpigotPingPassthrough == null ? null : this.geyserSpigotPingPassthrough.getClass()));
            if (GeyserImpl.getInstance().isReloading()) {
                return;
            }
            boolean isViaVersion = Bukkit.getPluginManager().getPlugin("ViaVersion") != null;
            GeyserSpigotVersionChecker.checkForSupportedProtocol(this.geyserLogger, isViaVersion);
            this.geyserInjector = new GeyserSpigotInjector(isViaVersion);
            this.geyserInjector.initializeLocalChannel(this);
            if (Boolean.parseBoolean(System.getProperty("Geyser.UseDirectAdapters", "true"))) {
                try {
                    boolean isPaper = false;
                    try {
                        String name = Bukkit.getServer().getClass().getPackage().getName();
                        String string = name.substring(name.lastIndexOf(46) + 1);
                        SpigotAdapters.registerWorldAdapter(string);
                        this.geyserLogger.debug("Using spigot NMS adapter for nms version: " + string);
                    }
                    catch (Exception e) {
                        int n = Bukkit.getUnsafe().getProtocolVersion();
                        PaperAdapters.registerClosestWorldAdapter(n);
                        isPaper = true;
                        this.geyserLogger.debug("Using paper world adapter for protocol version: " + n);
                    }
                    this.geyserWorldManager = isViaVersion && this.isViaVersionNeeded() ? new GeyserSpigotLegacyNativeWorldManager(this, isPaper) : new GeyserSpigotNativeWorldManager((Plugin)this, isPaper);
                    this.geyserLogger.debug("Using world manager of type: " + this.geyserWorldManager.getClass().getSimpleName());
                }
                catch (Exception e) {
                    if (this.geyserConfig.isDebugMode()) {
                        this.geyserLogger.debug("Error while attempting to find NMS adapter. Most likely, this can be safely ignored. :)");
                        e.printStackTrace();
                    }
                    break block16;
                }
            }
            this.geyserLogger.debug("Not using NMS adapter as it is disabled via system property.");
        }
        if (this.geyserWorldManager == null) {
            this.geyserWorldManager = new GeyserSpigotWorldManager((Plugin)this);
            this.geyserLogger.debug("Using default world manager.");
        }
        PluginCommand geyserCommand = this.getCommand("geyser");
        Objects.requireNonNull(geyserCommand, "base command cannot be null");
        geyserCommand.setExecutor((CommandExecutor)new GeyserSpigotCommandExecutor(this.geyser, this.geyserCommandManager.getCommands()));
        for (Map.Entry<Extension, Map<String, org.geysermc.geyser.api.command.Command>> entry : this.geyserCommandManager.extensionCommands().entrySet()) {
            PluginCommand command;
            Map<String, org.geysermc.geyser.api.command.Command> commands = entry.getValue();
            if (commands.isEmpty() || (command = this.getCommand(entry.getKey().description().id())) == null) continue;
            command.setExecutor((CommandExecutor)new GeyserSpigotCommandExecutor(this.geyser, commands));
        }
        for (Map.Entry<Object, Object> entry : this.geyserCommandManager.commands().entrySet()) {
            org.geysermc.geyser.api.command.Command command = (org.geysermc.geyser.api.command.Command)entry.getValue();
            if (command.aliases().contains(entry.getKey())) continue;
            Bukkit.getPluginManager().addPermission(new Permission(command.permission(), GeyserLocale.getLocaleStringLog(command.description()), command.isSuggestedOpOnly() ? PermissionDefault.OP : PermissionDefault.TRUE));
        }
        for (Map.Entry<Object, Object> entry : this.geyserCommandManager.extensionCommands().entrySet()) {
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                org.geysermc.geyser.api.command.Command command = (org.geysermc.geyser.api.command.Command)entry2.getValue();
                if (command.aliases().contains(entry2.getKey()) || command.permission().isBlank()) continue;
                if (Bukkit.getPluginManager().getPermission(command.permission()) != null) {
                    GeyserImpl.getInstance().getLogger().debug("Skipping permission " + command.permission() + " as it is already registered");
                    continue;
                }
                Bukkit.getPluginManager().addPermission(new Permission(command.permission(), GeyserLocale.getLocaleStringLog(command.description()), command.isSuggestedOpOnly() ? PermissionDefault.OP : PermissionDefault.TRUE));
            }
        }
        Bukkit.getPluginManager().addPermission(new Permission("geyser.update", "Whether update notifications can be seen", PermissionDefault.OP));
        GeyserSpigotBlockPlaceListener blockPlaceListener = new GeyserSpigotBlockPlaceListener(this.geyser, this.geyserWorldManager);
        Bukkit.getServer().getPluginManager().registerEvents((Listener)blockPlaceListener, (Plugin)this);
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new GeyserPistonListener(this.geyser, this.geyserWorldManager), (Plugin)this);
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new GeyserSpigotUpdateListener(), (Plugin)this);
        boolean bl = CommodoreProvider.isSupported();
        this.geyserLogger.debug("Brigadier supported? " + bl);
        if (bl) {
            GeyserBrigadierSupport.loadBrigadier(this, geyserCommand);
        }
    }

    @Override
    public void onGeyserDisable() {
        if (this.geyser != null) {
            this.geyser.disable();
        }
    }

    @Override
    public void onGeyserShutdown() {
        if (this.geyser != null) {
            this.geyser.shutdown();
        }
        if (this.geyserInjector != null) {
            this.geyserInjector.shutdown();
        }
    }

    public void onDisable() {
        this.onGeyserShutdown();
    }

    @Override
    public GeyserSpigotConfiguration getGeyserConfig() {
        return this.geyserConfig;
    }

    @Override
    public GeyserSpigotLogger getGeyserLogger() {
        return this.geyserLogger;
    }

    @Override
    public GeyserCommandManager getGeyserCommandManager() {
        return this.geyserCommandManager;
    }

    @Override
    public IGeyserPingPassthrough getGeyserPingPassthrough() {
        return this.geyserSpigotPingPassthrough;
    }

    @Override
    public WorldManager getWorldManager() {
        return this.geyserWorldManager;
    }

    @Override
    public Path getConfigFolder() {
        return this.getDataFolder().toPath();
    }

    @Override
    public BootstrapDumpInfo getDumpInfo() {
        return new GeyserSpigotDumpInfo();
    }

    @Override
    public String getMinecraftServerVersion() {
        return this.minecraftVersion;
    }

    @Override
    public SocketAddress getSocketAddress() {
        return this.geyserInjector.getServerSocketAddress();
    }

    public ProtocolVersion getServerProtocolVersion() {
        return ProtocolVersion.getClosest((String)this.minecraftVersion);
    }

    private boolean isViaVersionNeeded() {
        ProtocolVersion serverVersion = this.getServerProtocolVersion();
        List protocolList = Via.getManager().getProtocolManager().getProtocolPath(GameProtocol.getJavaProtocolVersion(), serverVersion.getVersion());
        if (protocolList == null) {
            return false;
        }
        for (int i = protocolList.size() - 1; i >= 0; --i) {
            MappingData mappingData = ((ProtocolPathEntry)protocolList.get(i)).protocol().getMappingData();
            if (mappingData == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public @NonNull String getServerBindAddress() {
        return Bukkit.getIp();
    }

    @Override
    public int getServerPort() {
        return Bukkit.getPort();
    }

    @Override
    public boolean testFloodgatePluginPresent() {
        if (Bukkit.getPluginManager().getPlugin("floodgate") != null) {
            this.geyserConfig.loadFloodgate(this);
            return true;
        }
        return false;
    }

    private boolean loadConfig() {
        try {
            if (!this.getDataFolder().exists()) {
                this.getDataFolder().mkdir();
            }
            File configFile = FileUtils.fileOrCopiedFromResource(new File(this.getDataFolder(), "config.yml"), "config.yml", x -> x.replaceAll("generateduuid", UUID.randomUUID().toString()), this);
            this.geyserConfig = FileUtils.loadConfig(configFile, GeyserSpigotConfiguration.class);
        }
        catch (IOException ex) {
            this.getLogger().log(Level.SEVERE, GeyserLocale.getLocaleStringLog("geyser.config.failed"), ex);
            ex.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return false;
        }
        return true;
    }
}

