/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.type;

import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.protocol.bedrock.data.definitions.BlockDefinition;
import org.cloudburstmc.protocol.bedrock.data.definitions.ItemDefinition;
import org.geysermc.geyser.api.item.custom.CustomItemOptions;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.Pair;

public final class ItemMapping {
    public static final ItemMapping AIR = new ItemMapping("minecraft:air", ItemDefinition.AIR, 0, null, null, null, null, Collections.emptyList(), Items.AIR);
    private final String bedrockIdentifier;
    private final ItemDefinition bedrockDefinition;
    private final int bedrockData;
    private final BlockDefinition bedrockBlockDefinition;
    private final String toolType;
    private final String toolTier;
    private final String translationString;
    private final @NonNull List<Pair<CustomItemOptions, ItemDefinition>> customItemOptions;
    private final @NonNull Item javaItem;

    public boolean isBlock() {
        return this.bedrockBlockDefinition != null;
    }

    public boolean hasTranslation() {
        return this.translationString != null;
    }

    public boolean isTool() {
        return this.toolType != null;
    }

    ItemMapping(String bedrockIdentifier, ItemDefinition bedrockDefinition, int bedrockData, BlockDefinition bedrockBlockDefinition, String toolType, String toolTier, String translationString, @NonNull List<Pair<CustomItemOptions, ItemDefinition>> customItemOptions, @NonNull Item javaItem) {
        if (customItemOptions == null) {
            throw new NullPointerException("customItemOptions is marked non-null but is null");
        }
        if (javaItem == null) {
            throw new NullPointerException("javaItem is marked non-null but is null");
        }
        this.bedrockIdentifier = bedrockIdentifier;
        this.bedrockDefinition = bedrockDefinition;
        this.bedrockData = bedrockData;
        this.bedrockBlockDefinition = bedrockBlockDefinition;
        this.toolType = toolType;
        this.toolTier = toolTier;
        this.translationString = translationString;
        this.customItemOptions = customItemOptions;
        this.javaItem = javaItem;
    }

    public static ItemMappingBuilder builder() {
        return new ItemMappingBuilder();
    }

    public String getBedrockIdentifier() {
        return this.bedrockIdentifier;
    }

    public ItemDefinition getBedrockDefinition() {
        return this.bedrockDefinition;
    }

    public int getBedrockData() {
        return this.bedrockData;
    }

    public BlockDefinition getBedrockBlockDefinition() {
        return this.bedrockBlockDefinition;
    }

    public String getToolType() {
        return this.toolType;
    }

    public String getToolTier() {
        return this.toolTier;
    }

    public String getTranslationString() {
        return this.translationString;
    }

    public @NonNull List<Pair<CustomItemOptions, ItemDefinition>> getCustomItemOptions() {
        return this.customItemOptions;
    }

    public @NonNull Item getJavaItem() {
        return this.javaItem;
    }

    public String toString() {
        return "ItemMapping(bedrockIdentifier=" + this.getBedrockIdentifier() + ", bedrockDefinition=" + this.getBedrockDefinition() + ", bedrockData=" + this.getBedrockData() + ", bedrockBlockDefinition=" + this.getBedrockBlockDefinition() + ", toolType=" + this.getToolType() + ", toolTier=" + this.getToolTier() + ", translationString=" + this.getTranslationString() + ", customItemOptions=" + this.getCustomItemOptions() + ", javaItem=" + this.getJavaItem() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ItemMapping)) {
            return false;
        }
        ItemMapping other = (ItemMapping)o;
        if (this.getBedrockData() != other.getBedrockData()) {
            return false;
        }
        String this$bedrockIdentifier = this.getBedrockIdentifier();
        String other$bedrockIdentifier = other.getBedrockIdentifier();
        if (this$bedrockIdentifier == null ? other$bedrockIdentifier != null : !this$bedrockIdentifier.equals(other$bedrockIdentifier)) {
            return false;
        }
        ItemDefinition this$bedrockDefinition = this.getBedrockDefinition();
        ItemDefinition other$bedrockDefinition = other.getBedrockDefinition();
        if (this$bedrockDefinition == null ? other$bedrockDefinition != null : !this$bedrockDefinition.equals(other$bedrockDefinition)) {
            return false;
        }
        BlockDefinition this$bedrockBlockDefinition = this.getBedrockBlockDefinition();
        BlockDefinition other$bedrockBlockDefinition = other.getBedrockBlockDefinition();
        if (this$bedrockBlockDefinition == null ? other$bedrockBlockDefinition != null : !this$bedrockBlockDefinition.equals(other$bedrockBlockDefinition)) {
            return false;
        }
        String this$toolType = this.getToolType();
        String other$toolType = other.getToolType();
        if (this$toolType == null ? other$toolType != null : !this$toolType.equals(other$toolType)) {
            return false;
        }
        String this$toolTier = this.getToolTier();
        String other$toolTier = other.getToolTier();
        if (this$toolTier == null ? other$toolTier != null : !this$toolTier.equals(other$toolTier)) {
            return false;
        }
        String this$translationString = this.getTranslationString();
        String other$translationString = other.getTranslationString();
        if (this$translationString == null ? other$translationString != null : !this$translationString.equals(other$translationString)) {
            return false;
        }
        List<Pair<CustomItemOptions, ItemDefinition>> this$customItemOptions = this.getCustomItemOptions();
        List<Pair<CustomItemOptions, ItemDefinition>> other$customItemOptions = other.getCustomItemOptions();
        if (this$customItemOptions == null ? other$customItemOptions != null : !((Object)this$customItemOptions).equals(other$customItemOptions)) {
            return false;
        }
        Item this$javaItem = this.getJavaItem();
        Item other$javaItem = other.getJavaItem();
        return !(this$javaItem == null ? other$javaItem != null : !this$javaItem.equals(other$javaItem));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getBedrockData();
        String $bedrockIdentifier = this.getBedrockIdentifier();
        result = result * 59 + ($bedrockIdentifier == null ? 43 : $bedrockIdentifier.hashCode());
        ItemDefinition $bedrockDefinition = this.getBedrockDefinition();
        result = result * 59 + ($bedrockDefinition == null ? 43 : $bedrockDefinition.hashCode());
        BlockDefinition $bedrockBlockDefinition = this.getBedrockBlockDefinition();
        result = result * 59 + ($bedrockBlockDefinition == null ? 43 : $bedrockBlockDefinition.hashCode());
        String $toolType = this.getToolType();
        result = result * 59 + ($toolType == null ? 43 : $toolType.hashCode());
        String $toolTier = this.getToolTier();
        result = result * 59 + ($toolTier == null ? 43 : $toolTier.hashCode());
        String $translationString = this.getTranslationString();
        result = result * 59 + ($translationString == null ? 43 : $translationString.hashCode());
        List<Pair<CustomItemOptions, ItemDefinition>> $customItemOptions = this.getCustomItemOptions();
        result = result * 59 + ($customItemOptions == null ? 43 : ((Object)$customItemOptions).hashCode());
        Item $javaItem = this.getJavaItem();
        result = result * 59 + ($javaItem == null ? 43 : $javaItem.hashCode());
        return result;
    }

    public static class ItemMappingBuilder {
        private String bedrockIdentifier;
        private ItemDefinition bedrockDefinition;
        private int bedrockData;
        private BlockDefinition bedrockBlockDefinition;
        private String toolType;
        private String toolTier;
        private String translationString;
        private List<Pair<CustomItemOptions, ItemDefinition>> customItemOptions;
        private Item javaItem;

        ItemMappingBuilder() {
        }

        public ItemMappingBuilder bedrockIdentifier(String bedrockIdentifier) {
            this.bedrockIdentifier = bedrockIdentifier;
            return this;
        }

        public ItemMappingBuilder bedrockDefinition(ItemDefinition bedrockDefinition) {
            this.bedrockDefinition = bedrockDefinition;
            return this;
        }

        public ItemMappingBuilder bedrockData(int bedrockData) {
            this.bedrockData = bedrockData;
            return this;
        }

        public ItemMappingBuilder bedrockBlockDefinition(BlockDefinition bedrockBlockDefinition) {
            this.bedrockBlockDefinition = bedrockBlockDefinition;
            return this;
        }

        public ItemMappingBuilder toolType(String toolType) {
            this.toolType = toolType;
            return this;
        }

        public ItemMappingBuilder toolTier(String toolTier) {
            this.toolTier = toolTier;
            return this;
        }

        public ItemMappingBuilder translationString(String translationString) {
            this.translationString = translationString;
            return this;
        }

        public ItemMappingBuilder customItemOptions(@NonNull List<Pair<CustomItemOptions, ItemDefinition>> customItemOptions) {
            if (customItemOptions == null) {
                throw new NullPointerException("customItemOptions is marked non-null but is null");
            }
            this.customItemOptions = customItemOptions;
            return this;
        }

        public ItemMappingBuilder javaItem(@NonNull Item javaItem) {
            if (javaItem == null) {
                throw new NullPointerException("javaItem is marked non-null but is null");
            }
            this.javaItem = javaItem;
            return this;
        }

        public ItemMapping build() {
            return new ItemMapping(this.bedrockIdentifier, this.bedrockDefinition, this.bedrockData, this.bedrockBlockDefinition, this.toolType, this.toolTier, this.translationString, this.customItemOptions, this.javaItem);
        }

        public String toString() {
            return "ItemMapping.ItemMappingBuilder(bedrockIdentifier=" + this.bedrockIdentifier + ", bedrockDefinition=" + this.bedrockDefinition + ", bedrockData=" + this.bedrockData + ", bedrockBlockDefinition=" + this.bedrockBlockDefinition + ", toolType=" + this.toolType + ", toolTier=" + this.toolTier + ", translationString=" + this.translationString + ", customItemOptions=" + this.customItemOptions + ", javaItem=" + this.javaItem + ")";
        }
    }
}

