/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.text;

import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtType;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.format.NamedTextColor;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.format.Style;
import org.geysermc.mcprotocollib.protocol.data.game.RegistryEntry;

public final class TextDecoration {
    private final String translationKey;
    private final Style style;
    private final Set<Parameter> parameters;

    public TextDecoration(NbtMap tag) {
        this.translationKey = tag.getString("translation_key");
        NbtMap styleTag = tag.getCompound("style");
        Style.Builder builder = Style.style();
        if (!styleTag.isEmpty()) {
            boolean italic;
            String color = styleTag.getString("color", null);
            if (color != null) {
                builder.color(NamedTextColor.NAMES.value(color));
            }
            if (italic = styleTag.getBoolean("italic")) {
                builder.decorate(org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.format.TextDecoration.ITALIC);
            }
        }
        this.style = builder.build();
        this.parameters = EnumSet.noneOf(Parameter.class);
        List<String> parameters = tag.getList("parameters", NbtType.STRING);
        for (String parameter : parameters) {
            this.parameters.add(Parameter.valueOf(parameter.toUpperCase(Locale.ROOT)));
        }
    }

    public String translationKey() {
        return this.translationKey;
    }

    public Style style() {
        return this.style;
    }

    public Set<Parameter> parameters() {
        return this.parameters;
    }

    public String toString() {
        return "TextDecoration{translationKey='" + this.translationKey + "', style=" + this.style + ", parameters=" + this.parameters + "}";
    }

    public static TextDecoration readChatType(RegistryEntry entry) {
        NbtMap tag = entry.getData();
        NbtMap chat = tag.getCompound("chat", null);
        TextDecoration textDecoration = null;
        if (chat != null) {
            textDecoration = new TextDecoration(chat);
        }
        return textDecoration;
    }

    public static enum Parameter {
        CONTENT,
        SENDER,
        TARGET;

    }
}

