/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.bedrock;

import org.cloudburstmc.protocol.bedrock.packet.LecternUpdatePacket;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.inventory.LecternContainer;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.LecternInventoryTranslator;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.InventoryUtils;
import org.geysermc.mcprotocollib.protocol.data.game.entity.object.Direction;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.Hand;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.inventory.ServerboundContainerButtonClickPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.inventory.ServerboundContainerClosePacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundUseItemOnPacket;

@Translator(packet=LecternUpdatePacket.class)
public class BedrockLecternUpdateTranslator
extends PacketTranslator<LecternUpdatePacket> {
    @Override
    public void translate(GeyserSession session, LecternUpdatePacket packet) {
        if (packet.isDroppingBook()) {
            session.setDroppingLecternBook(true);
            ServerboundUseItemOnPacket blockPacket = new ServerboundUseItemOnPacket(packet.getBlockPosition(), Direction.DOWN, Hand.MAIN_HAND, 0.0f, 0.0f, 0.0f, false, session.getWorldCache().nextPredictionSequence());
            session.sendDownstreamGamePacket(blockPacket);
        } else {
            Inventory inventory = session.getOpenInventory();
            if (!(inventory instanceof LecternContainer)) {
                session.getGeyser().getLogger().debug("Expected lectern but it wasn't open!");
                return;
            }
            LecternContainer lecternContainer = (LecternContainer)inventory;
            if (lecternContainer.getCurrentBedrockPage() == packet.getPage()) {
                ServerboundContainerClosePacket closeWindowPacket = new ServerboundContainerClosePacket(lecternContainer.getJavaId());
                session.sendDownstreamGamePacket(closeWindowPacket);
                InventoryUtils.closeInventory(session, lecternContainer.getJavaId(), false);
            } else {
                int newJavaPage = packet.getPage() * 2;
                int currentJavaPage = lecternContainer.getCurrentBedrockPage() * 2;
                if (!lecternContainer.isUsingRealBlock()) {
                    LecternInventoryTranslator translator = (LecternInventoryTranslator)session.getInventoryTranslator();
                    Inventory inventory2 = session.getOpenInventory();
                    translator.updateProperty(session, inventory2, 0, newJavaPage);
                    return;
                }
                if (newJavaPage > currentJavaPage) {
                    for (int i = currentJavaPage; i < newJavaPage; ++i) {
                        ServerboundContainerButtonClickPacket clickButtonPacket = new ServerboundContainerButtonClickPacket(session.getOpenInventory().getJavaId(), 2);
                        session.sendDownstreamGamePacket(clickButtonPacket);
                    }
                } else {
                    for (int i = currentJavaPage; i > newJavaPage; --i) {
                        ServerboundContainerButtonClickPacket clickButtonPacket = new ServerboundContainerButtonClickPacket(session.getOpenInventory().getJavaId(), 1);
                        session.sendDownstreamGamePacket(clickButtonPacket);
                    }
                }
            }
        }
    }
}

