/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.bedrock.entity.player;

import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.protocol.bedrock.data.LevelEvent;
import org.cloudburstmc.protocol.bedrock.data.PlayerActionType;
import org.cloudburstmc.protocol.bedrock.data.definitions.ItemDefinition;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityEventType;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.cloudburstmc.protocol.bedrock.packet.AnimatePacket;
import org.cloudburstmc.protocol.bedrock.packet.EntityEventPacket;
import org.cloudburstmc.protocol.bedrock.packet.LevelEventPacket;
import org.cloudburstmc.protocol.bedrock.packet.PlayStatusPacket;
import org.cloudburstmc.protocol.bedrock.packet.PlayerActionPacket;
import org.cloudburstmc.protocol.bedrock.packet.UpdateAttributesPacket;
import org.geysermc.geyser.api.block.custom.CustomBlockState;
import org.geysermc.geyser.entity.type.ItemFrameEntity;
import org.geysermc.geyser.entity.type.player.SessionPlayerEntity;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.level.block.BlockStateValues;
import org.geysermc.geyser.network.GameProtocol;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.registry.type.BlockMapping;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.SkullCache;
import org.geysermc.geyser.translator.item.CustomItemTranslator;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.BlockUtils;
import org.geysermc.geyser.util.CooldownUtils;
import org.geysermc.mcprotocollib.protocol.data.game.entity.object.Direction;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.GameMode;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.Hand;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.InteractAction;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.PlayerAction;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.PlayerState;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundInteractPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundPlayerAbilitiesPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundPlayerActionPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundPlayerCommandPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundSwingPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundUseItemOnPacket;

@Translator(packet=PlayerActionPacket.class)
public class BedrockActionTranslator
extends PacketTranslator<PlayerActionPacket> {
    @Override
    public void translate(GeyserSession session, PlayerActionPacket packet) {
        SessionPlayerEntity entity = session.getPlayerEntity();
        if (packet.getAction() != PlayerActionType.RESPAWN) {
            session.getBookEditCache().checkForSend();
        }
        Vector3i vector = packet.getBlockPosition();
        switch (packet.getAction()) {
            case RESPAWN: {
                EntityEventPacket eventPacket = new EntityEventPacket();
                eventPacket.setRuntimeEntityId(entity.getGeyserId());
                eventPacket.setType(EntityEventType.RESPAWN);
                eventPacket.setData(0);
                session.sendUpstreamPacket(eventPacket);
                UpdateAttributesPacket attributesPacket = new UpdateAttributesPacket();
                attributesPacket.setRuntimeEntityId(entity.getGeyserId());
                attributesPacket.getAttributes().addAll(entity.getAttributes().values());
                session.sendUpstreamPacket(attributesPacket);
                entity.updateBoundingBox();
                session.getEntityCache().updateBossBars();
                break;
            }
            case START_SWIMMING: {
                if (entity.getFlag(EntityFlag.SWIMMING)) break;
                ServerboundPlayerCommandPacket startSwimPacket = new ServerboundPlayerCommandPacket(entity.getEntityId(), PlayerState.START_SPRINTING);
                session.sendDownstreamGamePacket(startSwimPacket);
                session.setSwimming(true);
                break;
            }
            case STOP_SWIMMING: {
                if (session.getCollisionManager().mustPlayerCrawlHere()) break;
                ServerboundPlayerCommandPacket stopSwimPacket = new ServerboundPlayerCommandPacket(entity.getEntityId(), PlayerState.STOP_SPRINTING);
                session.sendDownstreamGamePacket(stopSwimPacket);
                session.setSwimming(false);
                break;
            }
            case START_GLIDE: {
                ServerboundPlayerAbilitiesPacket playerAbilitiesPacket = new ServerboundPlayerAbilitiesPacket(false);
                session.sendDownstreamGamePacket(playerAbilitiesPacket);
            }
            case STOP_GLIDE: {
                ServerboundPlayerCommandPacket glidePacket = new ServerboundPlayerCommandPacket(entity.getEntityId(), PlayerState.START_ELYTRA_FLYING);
                session.sendDownstreamGamePacket(glidePacket);
                break;
            }
            case START_SNEAK: {
                ServerboundPlayerCommandPacket startSneakPacket = new ServerboundPlayerCommandPacket(entity.getEntityId(), PlayerState.START_SNEAKING);
                session.sendDownstreamGamePacket(startSneakPacket);
                session.startSneaking();
                break;
            }
            case STOP_SNEAK: {
                ServerboundPlayerCommandPacket stopSneakPacket = new ServerboundPlayerCommandPacket(entity.getEntityId(), PlayerState.STOP_SNEAKING);
                session.sendDownstreamGamePacket(stopSneakPacket);
                session.stopSneaking();
                break;
            }
            case START_SPRINT: {
                if (entity.getFlag(EntityFlag.SWIMMING)) break;
                ServerboundPlayerCommandPacket startSprintPacket = new ServerboundPlayerCommandPacket(entity.getEntityId(), PlayerState.START_SPRINTING);
                session.sendDownstreamGamePacket(startSprintPacket);
                session.setSprinting(true);
                break;
            }
            case STOP_SPRINT: {
                if (!entity.getFlag(EntityFlag.SWIMMING)) {
                    ServerboundPlayerCommandPacket stopSprintPacket = new ServerboundPlayerCommandPacket(entity.getEntityId(), PlayerState.STOP_SPRINTING);
                    session.sendDownstreamGamePacket(stopSprintPacket);
                }
                session.setSprinting(false);
                break;
            }
            case DROP_ITEM: {
                ServerboundPlayerActionPacket dropItemPacket = new ServerboundPlayerActionPacket(PlayerAction.DROP_ITEM, vector, Direction.VALUES[packet.getFace()], 0);
                session.sendDownstreamGamePacket(dropItemPacket);
                break;
            }
            case STOP_SLEEP: {
                ServerboundPlayerCommandPacket stopSleepingPacket = new ServerboundPlayerCommandPacket(entity.getEntityId(), PlayerState.LEAVE_BED);
                session.sendDownstreamGamePacket(stopSleepingPacket);
                break;
            }
            case START_BREAK: {
                ServerboundPlayerActionPacket startBreakingPacket;
                if (session.getGameMode() == GameMode.CREATIVE) break;
                int blockState = session.getGeyser().getWorldManager().getBlockAt(session, vector);
                LevelEventPacket startBreak = new LevelEventPacket();
                startBreak.setType(LevelEvent.BLOCK_START_BREAK);
                startBreak.setPosition(vector.toFloat());
                double breakTime = BlockUtils.getSessionBreakTime(session, BlockRegistries.JAVA_BLOCKS.getOrDefault(blockState, BlockMapping.DEFAULT)) * 20.0;
                GeyserItemStack item = session.getPlayerInventory().getItemInHand();
                ItemMapping mapping = item.getMapping(session);
                ItemDefinition customItem = mapping.isTool() ? CustomItemTranslator.getCustomItem(item.getComponents(), mapping) : null;
                CustomBlockState blockStateOverride = (CustomBlockState)BlockRegistries.CUSTOM_BLOCK_STATE_OVERRIDES.get(blockState);
                SkullCache.Skull skull = session.getSkullCache().getSkulls().get(vector);
                session.setBlockBreakStartTime(0L);
                if (blockStateOverride != null || customItem != null || skull != null && skull.getBlockDefinition() != null) {
                    session.setBlockBreakStartTime(System.currentTimeMillis());
                }
                startBreak.setData((int)(65535.0 / breakTime));
                session.setBreakingBlock(blockState);
                session.sendUpstreamPacket(startBreak);
                Vector3i fireBlockPos = BlockUtils.getBlockPosition(vector, packet.getFace());
                int blockUp = session.getGeyser().getWorldManager().getBlockAt(session, fireBlockPos);
                String identifier = BlockRegistries.JAVA_BLOCKS.getOrDefault(blockUp, BlockMapping.DEFAULT).getJavaIdentifier();
                if (identifier.startsWith("minecraft:fire") || identifier.startsWith("minecraft:soul_fire")) {
                    startBreakingPacket = new ServerboundPlayerActionPacket(PlayerAction.START_DIGGING, fireBlockPos, Direction.VALUES[packet.getFace()], session.getWorldCache().nextPredictionSequence());
                    session.sendDownstreamGamePacket(startBreakingPacket);
                }
                startBreakingPacket = new ServerboundPlayerActionPacket(PlayerAction.START_DIGGING, vector, Direction.VALUES[packet.getFace()], session.getWorldCache().nextPredictionSequence());
                session.sendDownstreamGamePacket(startBreakingPacket);
                break;
            }
            case CONTINUE_BREAK: {
                if (session.getGameMode() == GameMode.CREATIVE) break;
                int breakingBlock = session.getBreakingBlock();
                if (breakingBlock == -1) {
                    breakingBlock = 0;
                }
                Vector3f vectorFloat = vector.toFloat();
                LevelEventPacket continueBreakPacket = new LevelEventPacket();
                continueBreakPacket.setType(LevelEvent.PARTICLE_CRACK_BLOCK);
                continueBreakPacket.setData(session.getBlockMappings().getBedrockBlockId(breakingBlock) | packet.getFace() << 24);
                continueBreakPacket.setPosition(vectorFloat);
                session.sendUpstreamPacket(continueBreakPacket);
                LevelEventPacket updateBreak = new LevelEventPacket();
                updateBreak.setType(LevelEvent.BLOCK_UPDATE_BREAK);
                updateBreak.setPosition(vectorFloat);
                double breakTime = BlockUtils.getSessionBreakTime(session, BlockRegistries.JAVA_BLOCKS.getOrDefault(breakingBlock, BlockMapping.DEFAULT)) * 20.0;
                long blockBreakStartTime = session.getBlockBreakStartTime();
                if (blockBreakStartTime != 0L) {
                    double d;
                    long timeSinceStart = System.currentTimeMillis() - blockBreakStartTime;
                    breakTime += 2.0;
                    if ((double)timeSinceStart >= d * 50.0) {
                        LevelEventPacket effectPacket = new LevelEventPacket();
                        effectPacket.setPosition(vectorFloat);
                        effectPacket.setType(LevelEvent.PARTICLE_DESTROY_BLOCK);
                        effectPacket.setData(session.getBlockMappings().getBedrockBlockId(breakingBlock));
                        session.sendUpstreamPacket(effectPacket);
                        ServerboundPlayerActionPacket finishBreakingPacket = new ServerboundPlayerActionPacket(PlayerAction.FINISH_DIGGING, vector, Direction.VALUES[packet.getFace()], session.getWorldCache().nextPredictionSequence());
                        session.sendDownstreamGamePacket(finishBreakingPacket);
                        session.setBlockBreakStartTime(0L);
                        break;
                    }
                }
                updateBreak.setData((int)(65535.0 / breakTime));
                session.sendUpstreamPacket(updateBreak);
                break;
            }
            case ABORT_BREAK: {
                ItemFrameEntity itemFrameEntity;
                if (session.getGameMode() != GameMode.CREATIVE && (itemFrameEntity = ItemFrameEntity.getItemFrameEntity(session, vector)) != null) {
                    ServerboundInteractPacket interactPacket = new ServerboundInteractPacket(itemFrameEntity.getEntityId(), InteractAction.ATTACK, Hand.MAIN_HAND, session.isSneaking());
                    session.sendDownstreamGamePacket(interactPacket);
                    break;
                }
                ServerboundPlayerActionPacket abortBreakingPacket = new ServerboundPlayerActionPacket(PlayerAction.CANCEL_DIGGING, vector, Direction.DOWN, 0);
                session.sendDownstreamGamePacket(abortBreakingPacket);
                LevelEventPacket stopBreak = new LevelEventPacket();
                stopBreak.setType(LevelEvent.BLOCK_STOP_BREAK);
                stopBreak.setPosition(vector.toFloat());
                stopBreak.setData(0);
                session.setBreakingBlock(-1);
                session.sendUpstreamPacket(stopBreak);
                break;
            }
            case STOP_BREAK: {
                break;
            }
            case DIMENSION_CHANGE_SUCCESS: {
                PlayStatusPacket spawnPacket = new PlayStatusPacket();
                spawnPacket.setStatus(PlayStatusPacket.Status.PLAYER_SPAWN);
                session.sendUpstreamPacket(spawnPacket);
                UpdateAttributesPacket attributesPacket = new UpdateAttributesPacket();
                attributesPacket.setRuntimeEntityId(entity.getGeyserId());
                attributesPacket.getAttributes().addAll(entity.getAttributes().values());
                session.sendUpstreamPacket(attributesPacket);
                break;
            }
            case JUMP: {
                entity.setOnGround(false);
                break;
            }
            case MISSED_SWING: {
                CooldownUtils.sendCooldown(session);
                if (session.getArmAnimationTicks() != -1) break;
                session.sendDownstreamGamePacket(new ServerboundSwingPacket(Hand.MAIN_HAND));
                session.activateArmAnimationTicking();
                AnimatePacket animatePacket = new AnimatePacket();
                animatePacket.setRuntimeEntityId(session.getPlayerEntity().getGeyserId());
                animatePacket.setAction(AnimatePacket.Action.SWING_ARM);
                session.sendUpstreamPacket(animatePacket);
                break;
            }
            case START_FLYING: {
                if (session.isCanFly()) {
                    if (session.getGameMode() == GameMode.SPECTATOR) {
                        session.sendAdventureSettings();
                        break;
                    }
                    if (session.getPlayerEntity().getFlag(EntityFlag.SWIMMING) && session.getCollisionManager().isPlayerInWater()) {
                        session.sendAdventureSettings();
                        break;
                    }
                    session.setFlying(true);
                    session.sendDownstreamGamePacket(new ServerboundPlayerAbilitiesPacket(true));
                    break;
                }
                session.sendAdventureSettings();
                PlayerActionPacket stopFlyingPacket = new PlayerActionPacket();
                stopFlyingPacket.setRuntimeEntityId(session.getPlayerEntity().getGeyserId());
                stopFlyingPacket.setAction(PlayerActionType.STOP_FLYING);
                stopFlyingPacket.setBlockPosition(Vector3i.ZERO);
                stopFlyingPacket.setResultPosition(Vector3i.ZERO);
                stopFlyingPacket.setFace(0);
                session.sendUpstreamPacket(stopFlyingPacket);
                break;
            }
            case STOP_FLYING: {
                session.setFlying(false);
                session.sendDownstreamGamePacket(new ServerboundPlayerAbilitiesPacket(false));
                break;
            }
            case DIMENSION_CHANGE_REQUEST_OR_CREATIVE_DESTROY_BLOCK: {
                ItemFrameEntity itemFrame;
                if (GameProtocol.isPre1_20_70(session)) break;
                int interactedBlock = session.getGeyser().getWorldManager().getBlockAt(session, vector);
                if (BlockStateValues.getLecternBookStates().getOrDefault(interactedBlock, false)) {
                    session.setDroppingLecternBook(true);
                    ServerboundUseItemOnPacket blockPacket = new ServerboundUseItemOnPacket(vector, Direction.DOWN, Hand.MAIN_HAND, 0.0f, 0.0f, 0.0f, false, session.getWorldCache().nextPredictionSequence());
                    session.sendDownstreamGamePacket(blockPacket);
                    break;
                }
                if (!session.getItemFrameCache().containsKey(vector) || (itemFrame = ItemFrameEntity.getItemFrameEntity(session, packet.getBlockPosition())) == null) break;
                ServerboundInteractPacket interactPacket = new ServerboundInteractPacket(itemFrame.getEntityId(), InteractAction.ATTACK, Hand.MAIN_HAND, session.isSneaking());
                session.sendDownstreamGamePacket(interactPacket);
                break;
            }
        }
    }
}

