/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import java.util.BitSet;
import org.cloudburstmc.math.GenericMath;
import org.cloudburstmc.math.vector.Vector2i;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.protocol.bedrock.data.definitions.BlockDefinition;
import org.cloudburstmc.protocol.bedrock.packet.LevelChunkPacket;
import org.cloudburstmc.protocol.bedrock.packet.NetworkChunkPublisherUpdatePacket;
import org.cloudburstmc.protocol.bedrock.packet.UpdateBlockPacket;
import org.geysermc.geyser.entity.type.ItemFrameEntity;
import org.geysermc.geyser.level.BedrockDimension;
import org.geysermc.geyser.level.JavaDimension;
import org.geysermc.geyser.level.block.BlockStateValues;
import org.geysermc.geyser.level.chunk.BlockStorage;
import org.geysermc.geyser.level.chunk.GeyserChunkSection;
import org.geysermc.geyser.level.chunk.bitarray.SingletonBitArray;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.ints.IntLists;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.SkullCache;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.translator.level.block.entity.BedrockOnlyBlockEntity;
import org.geysermc.geyser.util.BlockEntityUtils;
import org.geysermc.geyser.util.DimensionUtils;
import org.geysermc.geyser.util.MathUtils;

public final class ChunkUtils {
    public static final byte[] EMPTY_BIOME_DATA;
    public static final BlockStorage[] EMPTY_BLOCK_STORAGE;
    public static final int EMPTY_CHUNK_SECTION_SIZE;

    public static int indexYZXtoXZY(int yzx) {
        return yzx >> 8 | yzx & 0xF0 | (yzx & 0xF) << 8;
    }

    public static void updateChunkPosition(GeyserSession session, Vector3i position) {
        Vector2i chunkPos = session.getLastChunkPosition();
        Vector2i newChunkPos = Vector2i.from(position.getX() >> 4, position.getZ() >> 4);
        if (chunkPos == null || !chunkPos.equals(newChunkPos)) {
            NetworkChunkPublisherUpdatePacket chunkPublisherUpdatePacket = new NetworkChunkPublisherUpdatePacket();
            chunkPublisherUpdatePacket.setPosition(position);
            chunkPublisherUpdatePacket.setRadius(GenericMath.ceil((double)(session.getServerRenderDistance() + 1) * MathUtils.SQRT_OF_TWO) << 4);
            session.sendUpstreamPacket(chunkPublisherUpdatePacket);
            session.setLastChunkPosition(newChunkPos);
        }
    }

    public static void updateBlock(GeyserSession session, int blockState, Vector3i position) {
        ChunkUtils.updateBlockClientSide(session, blockState, position);
        session.getChunkCache().updateBlock(position.getX(), position.getY(), position.getZ(), blockState);
    }

    public static void updateBlockClientSide(GeyserSession session, int blockState, Vector3i position) {
        SkullCache.Skull skull;
        ItemFrameEntity itemFrameEntity = ItemFrameEntity.getItemFrameEntity(session, position);
        if (itemFrameEntity != null && blockState == 0) {
            itemFrameEntity.updateBlock(true);
            return;
        }
        BlockDefinition definition = session.getBlockMappings().getBedrockBlock(blockState);
        byte skullVariant = BlockStateValues.getSkullVariant(blockState);
        if (skullVariant == -1) {
            session.getSkullCache().removeSkull(position);
        } else if (skullVariant == 3 && (skull = session.getSkullCache().updateSkull(position, blockState)) != null && skull.getBlockDefinition() != null) {
            definition = skull.getBlockDefinition();
        }
        if (!BlockStateValues.isMovingPiston(blockState)) {
            UpdateBlockPacket updateBlockPacket = new UpdateBlockPacket();
            updateBlockPacket.setDataLayer(0);
            updateBlockPacket.setBlockPosition(position);
            updateBlockPacket.setDefinition(definition);
            updateBlockPacket.getFlags().add(UpdateBlockPacket.Flag.NEIGHBORS);
            updateBlockPacket.getFlags().add(UpdateBlockPacket.Flag.NETWORK);
            session.sendUpstreamPacket(updateBlockPacket);
            UpdateBlockPacket waterPacket = new UpdateBlockPacket();
            waterPacket.setDataLayer(1);
            waterPacket.setBlockPosition(position);
            if (((BitSet)BlockRegistries.WATERLOGGED.get()).get(blockState)) {
                waterPacket.setDefinition(session.getBlockMappings().getBedrockWater());
            } else {
                waterPacket.setDefinition(session.getBlockMappings().getBedrockAir());
            }
            session.sendUpstreamPacket(waterPacket);
        }
        if (!session.getBlockMappings().getExtendedCollisionBoxes().isEmpty()) {
            int aboveBlock = session.getGeyser().getWorldManager().getBlockAt(session, position.getX(), position.getY() + 1, position.getZ());
            BlockDefinition aboveBedrockExtendedCollisionDefinition = (BlockDefinition)session.getBlockMappings().getExtendedCollisionBoxes().get(blockState);
            int belowBlock = session.getGeyser().getWorldManager().getBlockAt(session, position.getX(), position.getY() - 1, position.getZ());
            BlockDefinition belowBedrockExtendedCollisionDefinition = (BlockDefinition)session.getBlockMappings().getExtendedCollisionBoxes().get(belowBlock);
            if (belowBedrockExtendedCollisionDefinition != null && blockState == 0) {
                updateBlockPacket = new UpdateBlockPacket();
                updateBlockPacket.setDataLayer(0);
                updateBlockPacket.setBlockPosition(position);
                updateBlockPacket.setDefinition(belowBedrockExtendedCollisionDefinition);
                updateBlockPacket.getFlags().add(UpdateBlockPacket.Flag.NETWORK);
                session.sendUpstreamPacket(updateBlockPacket);
            } else if (aboveBedrockExtendedCollisionDefinition != null && aboveBlock == 0) {
                updateBlockPacket = new UpdateBlockPacket();
                updateBlockPacket.setDataLayer(0);
                updateBlockPacket.setBlockPosition(position.add(0, 1, 0));
                updateBlockPacket.setDefinition(aboveBedrockExtendedCollisionDefinition);
                updateBlockPacket.getFlags().add(UpdateBlockPacket.Flag.NETWORK);
                session.sendUpstreamPacket(updateBlockPacket);
            } else if (aboveBlock == 0) {
                updateBlockPacket = new UpdateBlockPacket();
                updateBlockPacket.setDataLayer(0);
                updateBlockPacket.setBlockPosition(position.add(0, 1, 0));
                updateBlockPacket.setDefinition(session.getBlockMappings().getBedrockAir());
                updateBlockPacket.getFlags().add(UpdateBlockPacket.Flag.NETWORK);
                session.sendUpstreamPacket(updateBlockPacket);
            }
        }
        BlockStateValues.getLecternBookStates().handleBlockChange(session, blockState, position);
        for (BedrockOnlyBlockEntity bedrockOnlyBlockEntity : BlockEntityUtils.BEDROCK_ONLY_BLOCK_ENTITIES) {
            if (!bedrockOnlyBlockEntity.isBlock(blockState)) continue;
            bedrockOnlyBlockEntity.updateBlock(session, blockState, position);
            break;
        }
        if (BlockStateValues.isUpperDoor(blockState)) {
            Vector3i belowDoorPosition = position.sub(0, 1, 0);
            int belowDoorBlockState = session.getGeyser().getWorldManager().getBlockAt(session, belowDoorPosition.getX(), belowDoorPosition.getY(), belowDoorPosition.getZ());
            ChunkUtils.updateBlock(session, belowDoorBlockState, belowDoorPosition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendEmptyChunk(GeyserSession session, int chunkX, int chunkZ, boolean forceUpdate) {
        BedrockDimension bedrockDimension = session.getChunkCache().getBedrockDimension();
        int bedrockSubChunkCount = bedrockDimension.height() >> 4;
        ByteBuf byteBuf = ByteBufAllocator.DEFAULT.buffer(EMPTY_BIOME_DATA.length * bedrockSubChunkCount + 1);
        try {
            byteBuf.writeBytes(EMPTY_BIOME_DATA);
            for (int i = 1; i < bedrockSubChunkCount; ++i) {
                byteBuf.writeByte(255);
            }
            byteBuf.writeByte(0);
            byte[] payload = new byte[byteBuf.readableBytes()];
            byteBuf.readBytes(payload);
            LevelChunkPacket data = new LevelChunkPacket();
            data.setDimension(DimensionUtils.javaToBedrock(session.getChunkCache().getBedrockDimension()));
            data.setChunkX(chunkX);
            data.setChunkZ(chunkZ);
            data.setSubChunksLength(0);
            data.setData(Unpooled.wrappedBuffer((byte[])payload));
            data.setCachingEnabled(false);
            session.sendUpstreamPacket(data);
        }
        finally {
            byteBuf.release();
        }
        if (forceUpdate) {
            Vector3i pos = Vector3i.from(chunkX << 4, 80, chunkZ << 4);
            UpdateBlockPacket blockPacket = new UpdateBlockPacket();
            blockPacket.setBlockPosition(pos);
            blockPacket.setDataLayer(0);
            blockPacket.setDefinition(session.getBlockMappings().getBedrockBlock(1));
            session.sendUpstreamPacket(blockPacket);
        }
    }

    public static void sendEmptyChunks(GeyserSession session, Vector3i position, int radius, boolean forceUpdate) {
        int chunkX = position.getX() >> 4;
        int chunkZ = position.getZ() >> 4;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                ChunkUtils.sendEmptyChunk(session, chunkX + x, chunkZ + z, forceUpdate);
            }
        }
    }

    public static void loadDimension(GeyserSession session) {
        JavaDimension dimension = session.getRegistryCache().dimensions().byId(session.getDimension());
        session.setDimensionType(dimension);
        int minY = dimension.minY();
        int maxY = dimension.maxY();
        if (minY % 16 != 0) {
            throw new RuntimeException("Minimum Y must be a multiple of 16!");
        }
        if (maxY % 16 != 0) {
            throw new RuntimeException("Maximum Y must be a multiple of 16!");
        }
        BedrockDimension bedrockDimension = session.getChunkCache().getBedrockDimension();
        if (minY < bedrockDimension.minY() || bedrockDimension.doUpperHeightWarn() && maxY > bedrockDimension.height()) {
            session.getGeyser().getLogger().warning(GeyserLocale.getLocaleStringLog("geyser.network.translator.chunk.out_of_bounds", String.valueOf(bedrockDimension.minY()), String.valueOf(bedrockDimension.height()), session.getDimension()));
        }
        session.getChunkCache().setMinY(minY);
        session.getChunkCache().setHeightY(maxY);
        session.getWorldBorder().setWorldCoordinateScale(dimension.worldCoordinateScale());
    }

    private ChunkUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        EMPTY_BLOCK_STORAGE = new BlockStorage[0];
        ByteBuf byteBuf = Unpooled.buffer();
        try {
            new GeyserChunkSection(EMPTY_BLOCK_STORAGE, 0).writeToNetwork(byteBuf);
            byte[] emptyChunkData = new byte[byteBuf.readableBytes()];
            byteBuf.readBytes(emptyChunkData);
            EMPTY_CHUNK_SECTION_SIZE = emptyChunkData.length;
            emptyChunkData = null;
        }
        finally {
            byteBuf.release();
        }
        byteBuf = Unpooled.buffer();
        try {
            BlockStorage blockStorage = new BlockStorage(SingletonBitArray.INSTANCE, IntLists.singleton(0));
            blockStorage.writeToNetwork(byteBuf);
            EMPTY_BIOME_DATA = new byte[byteBuf.readableBytes()];
            byteBuf.readBytes(EMPTY_BIOME_DATA);
        }
        finally {
            byteBuf.release();
        }
    }
}

