/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.network;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.geysermc.mcprotocollib.network.Flag;
import org.geysermc.mcprotocollib.network.Server;
import org.geysermc.mcprotocollib.network.Session;
import org.geysermc.mcprotocollib.network.event.server.ServerBoundEvent;
import org.geysermc.mcprotocollib.network.event.server.ServerClosedEvent;
import org.geysermc.mcprotocollib.network.event.server.ServerClosingEvent;
import org.geysermc.mcprotocollib.network.event.server.ServerEvent;
import org.geysermc.mcprotocollib.network.event.server.ServerListener;
import org.geysermc.mcprotocollib.network.event.server.SessionAddedEvent;
import org.geysermc.mcprotocollib.network.event.server.SessionRemovedEvent;
import org.geysermc.mcprotocollib.network.packet.PacketProtocol;

public abstract class AbstractServer
implements Server {
    private final String host;
    private final int port;
    private final Supplier<? extends PacketProtocol> protocolSupplier;
    private final List<Session> sessions = new ArrayList<Session>();
    private final Map<String, Object> flags = new HashMap<String, Object>();
    private final List<ServerListener> listeners = new ArrayList<ServerListener>();

    public AbstractServer(String host, int port, Supplier<? extends PacketProtocol> protocolSupplier) {
        this.host = host;
        this.port = port;
        this.protocolSupplier = protocolSupplier;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public Supplier<? extends PacketProtocol> getPacketProtocol() {
        return this.protocolSupplier;
    }

    protected PacketProtocol createPacketProtocol() {
        return this.protocolSupplier.get();
    }

    @Override
    public Map<String, Object> getGlobalFlags() {
        return Collections.unmodifiableMap(this.flags);
    }

    @Override
    public boolean hasGlobalFlag(Flag<?> flag) {
        return this.flags.containsKey(flag.key());
    }

    @Override
    public <T> T getGlobalFlag(Flag<T> flag) {
        return this.getGlobalFlag(flag, null);
    }

    @Override
    public <T> T getGlobalFlag(Flag<T> flag, T def) {
        Object value = this.flags.get(flag.key());
        if (value == null) {
            return def;
        }
        try {
            return flag.cast(value);
        }
        catch (ClassCastException e) {
            throw new IllegalStateException("Tried to get flag \"" + flag.key() + "\" as the wrong type. Actual type: " + value.getClass().getName());
        }
    }

    @Override
    public <T> void setGlobalFlag(Flag<T> flag, T value) {
        this.flags.put(flag.key(), value);
    }

    @Override
    public List<ServerListener> getListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    @Override
    public void addListener(ServerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(ServerListener listener) {
        this.listeners.remove(listener);
    }

    protected void callEvent(ServerEvent event) {
        for (ServerListener listener : this.listeners) {
            event.call(listener);
        }
    }

    @Override
    public List<Session> getSessions() {
        return new ArrayList<Session>(this.sessions);
    }

    public void addSession(Session session) {
        this.sessions.add(session);
        this.callEvent(new SessionAddedEvent(this, session));
    }

    public void removeSession(Session session) {
        this.sessions.remove(session);
        if (session.isConnected()) {
            session.disconnect("Connection closed.");
        }
        this.callEvent(new SessionRemovedEvent(this, session));
    }

    @Override
    public AbstractServer bind() {
        return this.bind(true);
    }

    @Override
    public AbstractServer bind(boolean wait) {
        return this.bind(wait, null);
    }

    @Override
    public AbstractServer bind(boolean wait, Runnable callback) {
        this.bindImpl(wait, () -> {
            this.callEvent(new ServerBoundEvent(this));
            if (callback != null) {
                callback.run();
            }
        });
        return this;
    }

    protected abstract void bindImpl(boolean var1, Runnable var2);

    @Override
    public void close() {
        this.close(true);
    }

    @Override
    public void close(boolean wait) {
        this.close(wait, null);
    }

    @Override
    public void close(boolean wait, Runnable callback) {
        this.callEvent(new ServerClosingEvent(this));
        for (Session session : this.getSessions()) {
            if (!session.isConnected()) continue;
            session.disconnect("Server closed.");
        }
        this.closeImpl(wait, () -> {
            this.callEvent(new ServerClosedEvent(this));
            if (callback != null) {
                callback.run();
            }
        });
    }

    protected abstract void closeImpl(boolean var1, Runnable var2);
}

