/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.data.game.chunk.palette;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.data.game.chunk.palette.Palette;

public class ListPalette
implements Palette {
    private final int capacity;
    private final int[] data;
    private int nextId = 0;

    public ListPalette(int bitsPerEntry) {
        this.capacity = 1 << bitsPerEntry;
        this.data = new int[this.capacity];
    }

    public ListPalette(int bitsPerEntry, ByteBuf in, MinecraftCodecHelper helper) {
        this(bitsPerEntry);
        int paletteLength = helper.readVarInt(in);
        for (int i = 0; i < paletteLength; ++i) {
            this.data[i] = helper.readVarInt(in);
        }
        this.nextId = paletteLength;
    }

    @Override
    public int size() {
        return this.nextId;
    }

    @Override
    public int stateToId(int state) {
        int id = -1;
        for (int i = 0; i < this.nextId; ++i) {
            if (this.data[i] != state) continue;
            id = i;
            break;
        }
        if (id == -1 && this.size() < this.capacity) {
            id = this.nextId++;
            this.data[id] = state;
        }
        return id;
    }

    @Override
    public int idToState(int id) {
        if (id >= 0 && id < this.size()) {
            return this.data[id];
        }
        return 0;
    }

    @Override
    public ListPalette copy() {
        return new ListPalette(this.capacity, Arrays.copyOf(this.data, this.data.length), this.nextId);
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int[] getData() {
        return this.data;
    }

    public int getNextId() {
        return this.nextId;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListPalette)) {
            return false;
        }
        ListPalette other = (ListPalette)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCapacity() != other.getCapacity()) {
            return false;
        }
        if (this.getNextId() != other.getNextId()) {
            return false;
        }
        return Arrays.equals(this.getData(), other.getData());
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ListPalette;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCapacity();
        result = result * 59 + this.getNextId();
        result = result * 59 + Arrays.hashCode(this.getData());
        return result;
    }

    private ListPalette(int capacity, int[] data, int nextId) {
        this.capacity = capacity;
        this.data = data;
        this.nextId = nextId;
    }
}

