/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.inventory;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ClientboundHorseScreenOpenPacket
implements MinecraftPacket {
    private final int containerId;
    private final int numberOfSlots;
    private final int entityId;

    public ClientboundHorseScreenOpenPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.containerId = in.readByte();
        this.numberOfSlots = helper.readVarInt(in);
        this.entityId = in.readInt();
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        out.writeByte(this.containerId);
        helper.writeVarInt(out, this.numberOfSlots);
        out.writeInt(this.entityId);
    }

    public int getContainerId() {
        return this.containerId;
    }

    public int getNumberOfSlots() {
        return this.numberOfSlots;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundHorseScreenOpenPacket)) {
            return false;
        }
        ClientboundHorseScreenOpenPacket other = (ClientboundHorseScreenOpenPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getContainerId() != other.getContainerId()) {
            return false;
        }
        if (this.getNumberOfSlots() != other.getNumberOfSlots()) {
            return false;
        }
        return this.getEntityId() == other.getEntityId();
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundHorseScreenOpenPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getContainerId();
        result = result * 59 + this.getNumberOfSlots();
        result = result * 59 + this.getEntityId();
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundHorseScreenOpenPacket(containerId=" + this.getContainerId() + ", numberOfSlots=" + this.getNumberOfSlots() + ", entityId=" + this.getEntityId() + ")";
    }

    public @NonNull ClientboundHorseScreenOpenPacket withContainerId(int containerId) {
        return this.containerId == containerId ? this : new ClientboundHorseScreenOpenPacket(containerId, this.numberOfSlots, this.entityId);
    }

    public @NonNull ClientboundHorseScreenOpenPacket withNumberOfSlots(int numberOfSlots) {
        return this.numberOfSlots == numberOfSlots ? this : new ClientboundHorseScreenOpenPacket(this.containerId, numberOfSlots, this.entityId);
    }

    public @NonNull ClientboundHorseScreenOpenPacket withEntityId(int entityId) {
        return this.entityId == entityId ? this : new ClientboundHorseScreenOpenPacket(this.containerId, this.numberOfSlots, entityId);
    }

    public ClientboundHorseScreenOpenPacket(int containerId, int numberOfSlots, int entityId) {
        this.containerId = containerId;
        this.numberOfSlots = numberOfSlots;
        this.entityId = entityId;
    }
}

