/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ServerboundPlayerAbilitiesPacket
implements MinecraftPacket {
    private static final int FLAG_FLYING = 2;
    private final boolean flying;

    public ServerboundPlayerAbilitiesPacket(ByteBuf in, MinecraftCodecHelper helper) {
        byte flags = in.readByte();
        this.flying = (flags & 2) > 0;
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        int flags = 0;
        if (this.flying) {
            flags |= 2;
        }
        out.writeByte(flags);
    }

    public boolean isFlying() {
        return this.flying;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundPlayerAbilitiesPacket)) {
            return false;
        }
        ServerboundPlayerAbilitiesPacket other = (ServerboundPlayerAbilitiesPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.isFlying() == other.isFlying();
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ServerboundPlayerAbilitiesPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isFlying() ? 79 : 97);
        return result;
    }

    public @NonNull String toString() {
        return "ServerboundPlayerAbilitiesPacket(flying=" + this.isFlying() + ")";
    }

    public @NonNull ServerboundPlayerAbilitiesPacket withFlying(boolean flying) {
        return this.flying == flying ? this : new ServerboundPlayerAbilitiesPacket(flying);
    }

    public ServerboundPlayerAbilitiesPacket(boolean flying) {
        this.flying = flying;
    }
}

