/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.login.clientbound;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ClientboundLoginCompressionPacket
implements MinecraftPacket {
    private final int threshold;

    public ClientboundLoginCompressionPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.threshold = helper.readVarInt(in);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeVarInt(out, this.threshold);
    }

    @Override
    public boolean isPriority() {
        return true;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundLoginCompressionPacket)) {
            return false;
        }
        ClientboundLoginCompressionPacket other = (ClientboundLoginCompressionPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getThreshold() == other.getThreshold();
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundLoginCompressionPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getThreshold();
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundLoginCompressionPacket(threshold=" + this.getThreshold() + ")";
    }

    public @NonNull ClientboundLoginCompressionPacket withThreshold(int threshold) {
        return this.threshold == threshold ? this : new ClientboundLoginCompressionPacket(threshold);
    }

    public ClientboundLoginCompressionPacket(int threshold) {
        this.threshold = threshold;
    }
}

