/*
 * Decompiled with CFR 0.152.
 */
package com.pa_project.lib.json;

import com.pa_project.lib.json.JSONAware;
import com.pa_project.lib.json.JSONObject;
import com.pa_project.lib.json.JSONStreamAware;
import com.pa_project.lib.json.JSONStringUtil;
import com.pa_project.lib.json.JSONValue;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class JSONArray
extends ArrayList
implements JSONAware,
JSONStreamAware,
List {
    public int getInt(int n2) {
        return this.getObject(n2) != null && JSONArray.isInteger(this.getObject(n2).toString()) ? Integer.parseInt(this.getObject(n2).toString()) : 0;
    }

    public boolean getBoolean(int n2) {
        return this.getObject(n2) != null ? Boolean.valueOf(this.getObject(n2).toString()) : false;
    }

    public Object getObject(int n2) {
        try {
            return this.get(n2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public String getString(int n2) {
        return this.getObject(n2) != null ? this.getObject(n2).toString() : null;
    }

    public Integer getInteger(int n2) {
        return this.getObject(n2) != null && JSONArray.isInteger(this.getObject(n2).toString()) ? Integer.valueOf(Integer.parseInt(this.getObject(n2).toString())) : null;
    }

    public Double getDouble(int n2) {
        return this.getObject(n2) != null && JSONArray.isDouble(this.getObject(n2).toString()) ? Double.valueOf(this.getObject(n2).toString()) : null;
    }

    public Long getLong(int n2) {
        return this.getObject(n2) != null && JSONArray.isLong(this.getObject(n2).toString()) ? Long.valueOf(this.getObject(n2).toString()) : null;
    }

    public Short getShort(int n2) {
        return this.getObject(n2) != null && JSONArray.isShort(this.getObject(n2).toString()) ? Short.valueOf(this.getObject(n2).toString()) : null;
    }

    public Float getFloat(int n2) {
        return this.getObject(n2) != null && JSONArray.isFloat(this.getObject(n2).toString()) ? Float.valueOf(this.getObject(n2).toString()) : null;
    }

    public Byte getByte(int n2) {
        return this.getObject(n2) != null && JSONArray.isByte(this.getObject(n2).toString()) ? Byte.valueOf(this.getObject(n2).toString()) : null;
    }

    public Set getSet(int n2) {
        HashSet hashSet = new HashSet();
        this.getRawSet(n2).stream().forEach((? super T object) -> hashSet.add(object));
        return hashSet;
    }

    public Set getRawSet(int n2) {
        return this.getObject(n2) != null && this.getObject(n2) instanceof Set ? (Set)this.getObject(n2) : new HashSet();
    }

    public List getList(int n2) {
        ArrayList arrayList = new ArrayList();
        this.getRawList(n2).stream().forEach((? super T object) -> arrayList.add(object));
        return arrayList;
    }

    public List getRawList(int n2) {
        return this.getObject(n2) != null && this.getObject(n2) instanceof List ? (List)this.getObject(n2) : new ArrayList();
    }

    public JSONObject getJSONObject(int n2) {
        return this.getObject(n2) != null && this.getObject(n2) instanceof JSONObject ? (JSONObject)this.getObject(n2) : null;
    }

    public JSONArray getJSONArray(int n2) {
        return this.getObject(n2) != null && this.getObject(n2) instanceof JSONArray ? (JSONArray)this.getObject(n2) : null;
    }

    @Override
    public void writeJSONString(Writer writer) {
        JSONArray.writeJSONString(this, writer);
    }

    @Override
    public String toJSONString() {
        return JSONStringUtil.toJSONString(this);
    }

    @Override
    public String toJSONString(int n2) {
        return JSONStringUtil.toJSONString(this, n2);
    }

    @Override
    public String toString() {
        return this.toJSONString();
    }

    public static void writeJSONString(List list, Writer writer) {
        if (list == null) {
            writer.write("null");
            return;
        }
        boolean bl = true;
        Iterator iterator = list.iterator();
        writer.write(91);
        while (iterator.hasNext()) {
            if (bl) {
                bl = false;
            } else {
                writer.write(44);
            }
            Object e2 = iterator.next();
            if (e2 == null) {
                writer.write("null");
                continue;
            }
            JSONValue.valueWriteJSONString(e2, writer);
        }
        writer.write(93);
    }

    private static boolean isInteger(String string) {
        try {
            Integer.valueOf(string);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static boolean isDouble(String string) {
        try {
            Double.valueOf(string);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static boolean isLong(String string) {
        try {
            Long.valueOf(string);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static boolean isShort(String string) {
        try {
            Short.valueOf(string);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static boolean isFloat(String string) {
        try {
            Float.valueOf(string);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static boolean isByte(String string) {
        try {
            Byte.valueOf(string);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }
}

