/*
 * Decompiled with CFR 0.152.
 */
package com.pa_project.lib.json;

import com.pa_project.lib.json.JSONAware;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JSONStringUtil {
    public static void escape(String string, StringBuffer stringBuffer) {
        block10: for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '\"': {
                    stringBuffer.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block10;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    continue block10;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    continue block10;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block10;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block10;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block10;
                }
                case '/': {
                    stringBuffer.append("\\/");
                    continue block10;
                }
                default: {
                    if (c2 >= '\u0000' && c2 <= '\u001f' || c2 >= '\u007f' && c2 <= '\u009f' || c2 >= '\u2000' && c2 <= '\u20ff') {
                        String string2 = Integer.toHexString(c2);
                        stringBuffer.append("\\u");
                        for (int i3 = 0; i3 < 4 - string2.length(); ++i3) {
                            stringBuffer.append('0');
                        }
                        stringBuffer.append(string2.toUpperCase());
                        continue block10;
                    }
                    stringBuffer.append(c2);
                }
            }
        }
    }

    public static String escape(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        JSONStringUtil.escape(string, stringBuffer);
        return stringBuffer.toString();
    }

    public static String toString(String string, Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        JSONStringUtil.toJSONString(string, object, stringBuffer);
        return stringBuffer.toString();
    }

    public static String toJSONString(Map map) {
        if (map == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        Iterator iterator = map.entrySet().iterator();
        stringBuffer.append('{');
        while (iterator.hasNext()) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(',');
            }
            Map.Entry entry = iterator.next();
            JSONStringUtil.toJSONString(String.valueOf(entry.getKey()), entry.getValue(), stringBuffer);
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public static String toJSONString(List list) {
        if (list == null) {
            return "null";
        }
        boolean bl = true;
        StringBuilder stringBuilder = new StringBuilder();
        Iterator iterator = list.iterator();
        stringBuilder.append('[');
        while (iterator.hasNext()) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(',');
            }
            Object e2 = iterator.next();
            if (e2 == null) {
                stringBuilder.append("null");
                continue;
            }
            stringBuilder.append(JSONStringUtil.valueToJSONString(e2));
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static String toJSONString(String string, Object object, StringBuffer stringBuffer) {
        stringBuffer.append('\"');
        if (string == null) {
            stringBuffer.append("null");
        } else {
            JSONStringUtil.escape(string, stringBuffer);
        }
        stringBuffer.append('\"').append(':');
        stringBuffer.append(JSONStringUtil.valueToJSONString(object));
        return stringBuffer.toString();
    }

    public static String toJSONString(Map map, int n2) {
        if (map == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        Iterator iterator = map.entrySet().iterator();
        stringBuffer.append('{');
        n2 += 4;
        while (iterator.hasNext()) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(',');
            }
            stringBuffer.append("\n");
            Map.Entry entry = iterator.next();
            JSONStringUtil.toJSONString(String.valueOf(entry.getKey()), entry.getValue(), stringBuffer, n2);
        }
        stringBuffer.append("\n");
        stringBuffer.append(JSONStringUtil.blanks(n2 -= 4)).append('}');
        return stringBuffer.toString();
    }

    public static String toJSONString(List list, int n2) {
        if (list == null) {
            return "null";
        }
        boolean bl = true;
        StringBuilder stringBuilder = new StringBuilder();
        Iterator iterator = list.iterator();
        stringBuilder.append('[');
        stringBuilder.append("\n").append(JSONStringUtil.blanks(n2 += 4));
        while (iterator.hasNext()) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(',');
            }
            Object e2 = iterator.next();
            if (e2 == null) {
                stringBuilder.append("null");
                continue;
            }
            stringBuilder.append(JSONStringUtil.valueToJSONString(e2, n2));
        }
        stringBuilder.append("\n").append(JSONStringUtil.blanks(n2 -= 4)).append(']');
        return stringBuilder.toString();
    }

    public static String toJSONString(String string, Object object, StringBuffer stringBuffer, int n2) {
        stringBuffer.append(JSONStringUtil.blanks(n2)).append('\"');
        if (string == null) {
            stringBuffer.append("null");
        } else {
            JSONStringUtil.escape(string, stringBuffer);
        }
        stringBuffer.append('\"').append(':');
        stringBuffer.append(JSONStringUtil.valueToJSONString(object, n2));
        return stringBuffer.toString();
    }

    public static String valueToJSONString(Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof String) {
            return "\"" + JSONStringUtil.escape((String)object) + "\"";
        }
        if (object instanceof Double) {
            if (((Double)object).isInfinite() || ((Double)object).isNaN()) {
                return "null";
            }
            return object.toString();
        }
        if (object instanceof Float) {
            if (((Float)object).isInfinite() || ((Float)object).isNaN()) {
                return "null";
            }
            return object.toString();
        }
        if (object instanceof Number) {
            return object.toString();
        }
        if (object instanceof Boolean) {
            return object.toString();
        }
        if (object instanceof JSONAware) {
            return ((JSONAware)object).toJSONString();
        }
        if (object instanceof Map) {
            return JSONStringUtil.toJSONString((Map)object);
        }
        if (object instanceof List) {
            return JSONStringUtil.toJSONString((List)object);
        }
        return object.toString();
    }

    public static String valueToJSONString(Object object, int n2) {
        if (object == null) {
            return "null";
        }
        if (object instanceof String) {
            return "\"" + JSONStringUtil.escape((String)object) + "\"";
        }
        if (object instanceof Double) {
            if (((Double)object).isInfinite() || ((Double)object).isNaN()) {
                return "null";
            }
            return object.toString();
        }
        if (object instanceof Float) {
            if (((Float)object).isInfinite() || ((Float)object).isNaN()) {
                return "null";
            }
            return object.toString();
        }
        if (object instanceof Number) {
            return object.toString();
        }
        if (object instanceof Boolean) {
            return object.toString();
        }
        if (object instanceof JSONAware) {
            return ((JSONAware)object).toJSONString(n2);
        }
        if (object instanceof Map) {
            return JSONStringUtil.toJSONString((Map)object, n2);
        }
        if (object instanceof List) {
            return JSONStringUtil.toJSONString((List)object);
        }
        return object.toString();
    }

    private static String blanks(int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }
}

