/*
 * Decompiled with CFR 0.152.
 */
package com.pa_project.lib.json;

import com.pa_project.lib.json.JSONArray;
import com.pa_project.lib.json.JSONAware;
import com.pa_project.lib.json.JSONObject;
import com.pa_project.lib.json.JSONStreamAware;
import com.pa_project.lib.json.JSONStringUtil;
import com.pa_project.lib.json.parser.JSONParseException;
import com.pa_project.lib.json.parser.JSONParser;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.List;
import java.util.Map;

public class JSONValue {
    public static void valueWriteJSONString(Object object, Writer writer) {
        if (object == null) {
            writer.write("null");
            return;
        }
        if (object instanceof String) {
            writer.write(34);
            writer.write(JSONStringUtil.escape((String)object));
            writer.write(34);
            return;
        }
        if (object instanceof Double) {
            if (((Double)object).isInfinite() || ((Double)object).isNaN()) {
                writer.write("null");
            } else {
                writer.write(object.toString());
            }
            return;
        }
        if (object instanceof Float) {
            if (((Float)object).isInfinite() || ((Float)object).isNaN()) {
                writer.write("null");
            } else {
                writer.write(object.toString());
            }
            return;
        }
        if (object instanceof Number) {
            writer.write(object.toString());
            return;
        }
        if (object instanceof Boolean) {
            writer.write(object.toString());
            return;
        }
        if (object instanceof JSONStreamAware) {
            ((JSONStreamAware)object).writeJSONString(writer);
            return;
        }
        if (object instanceof JSONAware) {
            writer.write(((JSONAware)object).toJSONString());
            return;
        }
        if (object instanceof Map) {
            JSONObject.writeJSONString((Map)object, writer);
            return;
        }
        if (object instanceof List) {
            JSONArray.writeJSONString((List)object, writer);
            return;
        }
        writer.write(object.toString());
    }

    public static Object parse(Reader reader) {
        try {
            JSONParser jSONParser = new JSONParser();
            return jSONParser.c(reader);
        }
        catch (JSONParseException | IOException exception) {
            return null;
        }
    }

    public static Object parse(String string) {
        StringReader stringReader = new StringReader(string);
        return JSONValue.parse(stringReader);
    }

    public static Object parseWithException(Reader reader) {
        JSONParser jSONParser = new JSONParser();
        return jSONParser.c(reader);
    }

    public static Object parseWithException(String string) {
        JSONParser jSONParser = new JSONParser();
        return jSONParser.b(string);
    }
}

