/*
 * Decompiled with CFR 0.152.
 */
package studio.trc.bukkit.globalmarketplus.api.event;

import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import studio.trc.bukkit.globalmarketplus.merchandise.Merchandise;

public class TransactionEvent
extends Event
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private final int amount;
    private final boolean isRetail;
    private final Player trader;
    private final Merchandise merchandise;
    private boolean cancelled = false;

    public TransactionEvent(Merchandise merchandise, Player player, boolean bl, int n2) {
        this.merchandise = merchandise;
        this.trader = player;
        this.isRetail = bl;
        this.amount = n2;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public double getPrice() {
        if (this.isRetail) {
            return (double)this.amount * this.merchandise.getRetailPrice();
        }
        return this.merchandise.getPrice();
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public int getAmount() {
        return this.amount;
    }

    public boolean isRetail() {
        return this.isRetail;
    }

    public Player getTrader() {
        return this.trader;
    }

    public Merchandise getMerchandise() {
        return this.merchandise;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean bl) {
        this.cancelled = bl;
    }
}

