/*
 * Decompiled with CFR 0.152.
 */
package studio.trc.bukkit.globalmarketplus.merchandise;

import com.pa_project.lib.json.JSONObject;
import java.io.Serializable;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import studio.trc.bukkit.globalmarketplus.api.Merchant;
import studio.trc.bukkit.globalmarketplus.b.b;
import studio.trc.bukkit.globalmarketplus.f.a;
import studio.trc.bukkit.globalmarketplus.m.g;
import studio.trc.bukkit.globalmarketplus.m.h;
import studio.trc.bukkit.globalmarketplus.merchandise.MerchandiseOption;
import studio.trc.bukkit.globalmarketplus.merchandise.MerchandiseSort;
import studio.trc.bukkit.globalmarketplus.merchandise.MerchandiseType;
import studio.trc.bukkit.globalmarketplus.merchandise.Transaction;
import studio.trc.bukkit.globalmarketplus.merchandise.auction.Auction;
import studio.trc.bukkit.globalmarketplus.n.d;

public class Merchandise
extends h
implements Serializable,
Cloneable {
    private final long merchandiseUID;
    private final long uploadTime;
    private final UUID ownerUUID;
    private final String ownerName;
    private final ItemStack item;
    private final MerchandiseType merchandiseType;
    private final MerchandiseOption merchandiseOption;
    private double price = -1.0;
    private double retailPrice = -1.0;
    private double taxed = 0.0;
    private long expireTime = -1L;
    private a currency = a.DEFAULT;

    public Merchandise(long l2, UUID uUID, String string, ItemStack itemStack, MerchandiseType merchandiseType, MerchandiseOption merchandiseOption, long l3, long l4, double d2) {
        this.merchandiseUID = l2;
        this.item = itemStack;
        this.price = d2;
        this.ownerUUID = uUID;
        this.ownerName = string;
        this.uploadTime = l3;
        this.expireTime = l4;
        this.merchandiseType = merchandiseType;
        this.merchandiseOption = merchandiseOption;
    }

    public void openTransactionGUI(Player player) {
        if (player == null || this.isExpired()) {
            return;
        }
        if (this.price != -1.0) {
            studio.trc.bukkit.globalmarketplus.e.l.a.a(this.merchandiseUID, player).a(false);
        } else {
            studio.trc.bukkit.globalmarketplus.e.l.a.a(this.merchandiseUID, player, 1).a(false);
        }
    }

    public int compareTo(Merchandise merchandise, MerchandiseSort merchandiseSort) {
        switch (merchandiseSort.getName()) {
            case "ACCORDING_TO_UPLOAD_TIME": {
                return this.uploadTime > merchandise.getUploadTime() ? 1 : -1;
            }
            case "ACCORDING_TO_EXPIRE_TIME": {
                return this.expireTime > merchandise.getExpireTime() ? 1 : -1;
            }
            case "ACCORDING_TO_ITEM_AMOUNT": {
                return this.item.getAmount() > merchandise.getItem().getAmount() ? 1 : -1;
            }
            case "ACCORDING_TO_PRICE": {
                return this.price > merchandise.getPrice() ? 1 : -1;
            }
            case "RANDOM": {
                Random random = new Random();
                return random.nextInt(10) > random.nextInt(10) ? 1 : -1;
            }
        }
        return -1;
    }

    public boolean isExpired() {
        return this.merchandiseOption.isNeverExpire() ? false : System.currentTimeMillis() >= this.expireTime;
    }

    public boolean isAllowWholesale() {
        return this.price > 0.0;
    }

    public boolean isAllowRetail() {
        return this.retailPrice > 0.0;
    }

    public void setPrice(double d2) {
        this.price = d2;
    }

    public void setRetailPrice(double d2) {
        this.retailPrice = d2;
    }

    public Player getPlayer() {
        return Bukkit.getPlayer((UUID)this.ownerUUID);
    }

    public Merchant getMerchant() {
        return Merchant.getMerchant(this.ownerUUID);
    }

    public Transaction getTransaction(Player player) {
        return new Transaction(this, player);
    }

    public Transaction getTransaction(Player player, int n2) {
        return new Transaction(this, player, n2);
    }

    public JSONObject serialize() {
        return Merchandise.serialize(this);
    }

    @Override
    public int compareTo(h h2) {
        if (h2 instanceof Merchandise) {
            return this.compareTo((Merchandise)h2, MerchandiseSort.getDefaultSort());
        }
        return -1;
    }

    @Override
    public int compareTo(h h2, g g2) {
        if (g2 instanceof MerchandiseSort) {
            return this.compareTo((Merchandise)h2, (MerchandiseSort)g2);
        }
        return -1;
    }

    public String toString() {
        return this.serialize().toJSONString();
    }

    public static JSONObject serialize(Merchandise merchandise) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("UID", merchandise.merchandiseUID);
        jSONObject.put("OwnerUUID", merchandise.ownerUUID.toString());
        jSONObject.put("OwnerName", merchandise.ownerName);
        jSONObject.put("UploadTime", merchandise.uploadTime);
        jSONObject.put("ExpireTime", merchandise.expireTime);
        jSONObject.put("Price", merchandise.price);
        jSONObject.put("Item", d.b(merchandise.item));
        jSONObject.put("MerchandiseType", merchandise.merchandiseType.name());
        jSONObject.put("MerchandiseOption", merchandise.merchandiseOption.serialize());
        if (merchandise.retailPrice > 0.0) {
            jSONObject.put("RetailPrice", merchandise.retailPrice);
        }
        if (merchandise.taxed > 0.0) {
            jSONObject.put("Taxed", merchandise.taxed);
        }
        if (!merchandise.currency.equals((Object)a.DEFAULT)) {
            jSONObject.put("Currency", merchandise.currency.name());
        }
        if (merchandise instanceof Auction && merchandise.merchandiseType.equals((Object)MerchandiseType.BIDDING)) {
            Auction auction = (Auction)merchandise;
            jSONObject.put("Taxed", auction.getTaxed());
            if (auction.getBiddingPrice() != auction.getPrice()) {
                jSONObject.put("BiddingPrice", auction.getBiddingPrice());
            }
            if (auction.getTopBidder() != null) {
                jSONObject.put("TopBidder", auction.getTopBidder().toString());
            }
            if (auction.getTopBidderName() != null) {
                jSONObject.put("TopBidderName", auction.getTopBidderName());
            }
            if (!auction.getParticipants().isEmpty()) {
                jSONObject.put("Participants", auction.getParticipants().stream().map(uUID -> uUID.toString()).collect(Collectors.toList()));
            }
        }
        return jSONObject;
    }

    public static Merchandise deserialize(JSONObject jSONObject) {
        try {
            MerchandiseType merchandiseType = MerchandiseType.valueOf(jSONObject.getString("MerchandiseType"));
            ItemStack itemStack = d.l(jSONObject.getString("Item"));
            if (itemStack == null) {
                return null;
            }
            if (merchandiseType.equals((Object)MerchandiseType.BIDDING)) {
                Auction auction = new Auction(jSONObject.getLong("UID"), UUID.fromString(jSONObject.getString("OwnerUUID")), jSONObject.getString("OwnerName"), itemStack, MerchandiseType.valueOf(jSONObject.getString("MerchandiseType")), MerchandiseOption.deserialize(jSONObject.getJSONObject("MerchandiseOption")), jSONObject.getLong("UploadTime"), jSONObject.getLong("ExpireTime"), jSONObject.getDouble("Price"), jSONObject.getDouble("Taxed"));
                if (jSONObject.containsKey("Currency")) {
                    auction.setCurrency(a.valueOf(jSONObject.getString("Currency")));
                }
                if (jSONObject.containsKey("TopBidder")) {
                    auction.setTopBidder(UUID.fromString(jSONObject.getString("TopBidder")));
                }
                if (jSONObject.containsKey("TopBidderName")) {
                    auction.setTopBidderName(jSONObject.getString("TopBidderName"));
                }
                if (jSONObject.containsKey("BiddingPrice")) {
                    auction.setBiddingPrice(jSONObject.getDouble("BiddingPrice"));
                }
                if (jSONObject.containsKey("LastBiddingTime")) {
                    auction.setLastBiddingTime(jSONObject.getLong("LastBiddingTime"));
                }
                if (jSONObject.containsKey("Participants")) {
                    auction.getParticipants().addAll(jSONObject.getStringList("Participants").stream().filter(string -> d.d(string)).map(string -> UUID.fromString(string)).collect(Collectors.toList()));
                }
                return auction;
            }
            Merchandise merchandise = new Merchandise(jSONObject.getLong("UID"), UUID.fromString(jSONObject.getString("OwnerUUID")), jSONObject.getString("OwnerName"), itemStack, MerchandiseType.valueOf(jSONObject.getString("MerchandiseType")), MerchandiseOption.deserialize(jSONObject.getJSONObject("MerchandiseOption")), jSONObject.getLong("UploadTime"), jSONObject.getLong("ExpireTime"), jSONObject.getDouble("Price"));
            if (jSONObject.containsKey("Taxed")) {
                merchandise.setTaxed(jSONObject.getDouble("Taxed"));
            }
            if (jSONObject.containsKey("RetailPrice")) {
                merchandise.setRetailPrice(jSONObject.getDouble("RetailPrice"));
            }
            if (jSONObject.containsKey("Currency")) {
                merchandise.setCurrency(a.valueOf(jSONObject.getString("Currency")));
            }
            return merchandise;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static boolean comparisonMeta() {
        return b.GLOBAL_MARKET.getProtectedConfig().g("Transaction.Purchasing.Comparison-Products");
    }

    public long getMerchandiseUID() {
        return this.merchandiseUID;
    }

    public long getUploadTime() {
        return this.uploadTime;
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public MerchandiseType getMerchandiseType() {
        return this.merchandiseType;
    }

    public MerchandiseOption getMerchandiseOption() {
        return this.merchandiseOption;
    }

    public double getPrice() {
        return this.price;
    }

    public double getRetailPrice() {
        return this.retailPrice;
    }

    public double getTaxed() {
        return this.taxed;
    }

    public void setTaxed(double d2) {
        this.taxed = d2;
    }

    public long getExpireTime() {
        return this.expireTime;
    }

    public void setExpireTime(long l2) {
        this.expireTime = l2;
    }

    public a getCurrency() {
        return this.currency;
    }

    public void setCurrency(a a2) {
        this.currency = a2;
    }
}

