/*
 * Decompiled with CFR 0.152.
 */
package studio.trc.bukkit.globalmarketplus.merchandise;

import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import studio.trc.bukkit.globalmarketplus.api.GlobalMarket;
import studio.trc.bukkit.globalmarketplus.api.Mailbox;
import studio.trc.bukkit.globalmarketplus.api.Merchant;
import studio.trc.bukkit.globalmarketplus.api.a;
import studio.trc.bukkit.globalmarketplus.b.b;
import studio.trc.bukkit.globalmarketplus.j.b.g;
import studio.trc.bukkit.globalmarketplus.mailbox.ItemMail;
import studio.trc.bukkit.globalmarketplus.mailbox.ItemMailType;
import studio.trc.bukkit.globalmarketplus.merchandise.Merchandise;
import studio.trc.bukkit.globalmarketplus.merchandise.MerchandiseType;
import studio.trc.bukkit.globalmarketplus.merchandise.TransactionAction;
import studio.trc.bukkit.globalmarketplus.merchandise.TransactionResult;
import studio.trc.bukkit.globalmarketplus.merchandise.TransactionResultType;
import studio.trc.bukkit.globalmarketplus.merchant.MerchantGroup;
import studio.trc.bukkit.globalmarketplus.n.c;
import studio.trc.bukkit.globalmarketplus.n.d;

public class Transaction {
    private final Merchandise merchandise;
    private final Player trader;
    private final boolean isRetail;
    private final int amount;

    public Transaction(Merchandise merchandise, Player player) {
        this.merchandise = merchandise;
        this.trader = player;
        this.amount = 0;
        this.isRetail = false;
    }

    public Transaction(Merchandise merchandise, Player player, int n2) {
        this.merchandise = merchandise;
        this.trader = player;
        ItemStack itemStack = merchandise.getItem();
        this.amount = n2 > itemStack.getAmount() ? itemStack.getAmount() : (n2 < 0 ? 1 : n2);
        this.isRetail = n2 != 0;
    }

    public TransactionResult confirm() {
        TransactionResult transactionResult = new TransactionResult(this);
        if (this.trader == null) {
            transactionResult.setResultType(TransactionResultType.FAILED);
            return transactionResult;
        }
        if (this.merchandise == null) {
            transactionResult.setResultType(TransactionResultType.NOT_EXIST);
            return transactionResult;
        }
        if (this.merchandise.getMerchandiseType().equals((Object)MerchandiseType.BIDDING)) {
            transactionResult.setResultType(TransactionResultType.UNSUPPORT);
            return transactionResult;
        }
        if (this.merchandise.isExpired()) {
            transactionResult.setResultType(TransactionResultType.EXPIRED);
            return transactionResult;
        }
        studio.trc.bukkit.globalmarketplus.f.a a2 = studio.trc.bukkit.globalmarketplus.f.a.useMultipleCurrency() ? this.merchandise.getCurrency() : studio.trc.bukkit.globalmarketplus.f.a.getSystemCurrency();
        Merchant merchant = Merchant.getMerchant(this.trader);
        Merchant merchant2 = Merchant.getMerchant(this.merchandise.getOwnerUUID());
        d.a(merchant2, true);
        d.a(merchant, true);
        ItemStack itemStack = this.merchandise.getItem();
        double d2 = this.merchandise.getPrice();
        double d3 = this.merchandise.getRetailPrice();
        if (this.canAfford(a2, merchant)) {
            switch (this.merchandise.getMerchandiseType()) {
                case SELLING: {
                    double d4;
                    GlobalMarket globalMarket = GlobalMarket.getGlobalMarket();
                    if (this.isRetail) {
                        boolean bl;
                        ItemStack itemStack2 = new ItemStack(itemStack);
                        itemStack2.setAmount(this.amount);
                        if (!this.merchandise.getMerchandiseOption().isUnlimited()) {
                            if (itemStack.getAmount() > this.amount) {
                                itemStack.setAmount(itemStack.getAmount() - this.amount);
                                bl = globalMarket.saveMerchandise(this.merchandise.getMerchandiseUID(), UUID.randomUUID().toString());
                            } else {
                                if (!globalMarket.removeMerchandise(this.merchandise.getMerchandiseUID())) {
                                    globalMarket.reloadMarket();
                                    transactionResult.setResultType(TransactionResultType.NOT_EXIST);
                                    return transactionResult;
                                }
                                bl = true;
                            }
                        } else {
                            bl = true;
                        }
                        if (bl) {
                            double d5;
                            if (!d.c()) {
                                double d6 = this.merchandise.getPrice() * this.merchandise.getMerchant().getGroup().getTaxRate_Selling();
                                double d7 = this.merchandise.getRetailPrice() != -1.0 ? this.merchandise.getRetailPrice() * (double)this.merchandise.getItem().getAmount() * this.merchandise.getMerchant().getGroup().getTaxRate_Selling() : 0.0;
                                double d8 = d6 >= d7 ? d6 - this.merchandise.getTaxed() : d3 - this.merchandise.getTaxed();
                                this.merchandise.setTaxed(this.merchandise.getTaxed() + d8);
                                d5 = d8;
                                d.a(merchant2, a2, (double)this.amount * d3 - d8);
                            } else {
                                d5 = 0.0;
                                d.a(merchant2, a2, (double)this.amount * d3);
                            }
                            transactionResult.getRunTasks().add(() -> d.a(this.trader.getName(), merchant2.getPlayerUUID(), itemStack, (double)this.amount * d3 - d5, this.amount));
                            merchant.setBalance(a2, merchant.getBalance(a2) - (double)this.amount * d3);
                            MerchantGroup merchantGroup = merchant.getGroup();
                            if (b.GLOBAL_MARKET.getProtectedConfig().g("Transaction.Selling.Send-To-Mailbox")) {
                                Mailbox mailbox = merchant.getMailbox();
                                d.a(mailbox, true);
                                ItemMail itemMail = mailbox.addMail(this.trader.getUniqueId(), this.trader.getName(), ItemMailType.FROM_TRANSACTION, System.currentTimeMillis(), merchantGroup.getExpirationTimeOfSelling(), itemStack2, this.merchandise.getOwnerUUID(), this.merchandise.getOwnerName());
                                transactionResult.getRunTasks().add(() -> {
                                    d.a(this.trader, itemMail);
                                    Mailbox.record(itemMail, null);
                                });
                                transactionResult.setMail(itemMail);
                            } else if (this.trader.getInventory().firstEmpty() != -1 && this.amount <= 64) {
                                this.trader.getInventory().addItem(new ItemStack[]{itemStack2});
                            } else {
                                Mailbox mailbox = merchant.getMailbox();
                                d.a(mailbox, true);
                                ItemMail itemMail = mailbox.addMail(this.trader.getUniqueId(), this.trader.getName(), ItemMailType.FROM_TRANSACTION, System.currentTimeMillis(), merchantGroup.getExpirationTimeOfSelling(), itemStack2, this.merchandise.getOwnerUUID(), this.merchandise.getOwnerName());
                                transactionResult.setMail(itemMail);
                                transactionResult.getRunTasks().add(() -> {
                                    d.a(this.trader, itemMail);
                                    Mailbox.record(itemMail, null);
                                });
                            }
                            transactionResult.setResultType(TransactionResultType.SUCCESSFUL);
                            transactionResult.setAmount(this.amount);
                            transactionResult.setRetail(true);
                            transactionResult.setItem(itemStack2);
                            transactionResult.setMerchandiseType(MerchandiseType.SELLING);
                            transactionResult.setAction(TransactionAction.RETAIL);
                            transactionResult.setPrice((double)this.amount * d3);
                            transactionResult.setTrader(merchant);
                            transactionResult.setMerchant(merchant2);
                            this.record(transactionResult);
                        } else {
                            transactionResult.setResultType(TransactionResultType.FAILED);
                            transactionResult.setAmount(this.amount);
                            transactionResult.setRetail(true);
                            transactionResult.setItem(itemStack2);
                            transactionResult.setMerchandiseType(MerchandiseType.SELLING);
                            transactionResult.setAction(TransactionAction.RETAIL);
                            transactionResult.setPrice((double)this.amount * d3);
                            transactionResult.setTrader(merchant);
                            transactionResult.setMerchant(merchant2);
                            globalMarket.reloadMarket();
                        }
                        return transactionResult;
                    }
                    if (!this.merchandise.getMerchandiseOption().isUnlimited() && !globalMarket.removeMerchandise(this.merchandise.getMerchandiseUID())) {
                        globalMarket.reloadMarket();
                        transactionResult.setResultType(TransactionResultType.NOT_EXIST);
                        return transactionResult;
                    }
                    if (!d.c()) {
                        d4 = this.merchandise.getPrice() * this.merchandise.getMerchant().getGroup().getTaxRate_Selling();
                        d.a(merchant2, a2, d2 - d4);
                    } else {
                        d4 = 0.0;
                        d.a(merchant2, a2, d2);
                    }
                    transactionResult.getRunTasks().add(() -> d.a(this.trader.getName(), merchant2.getPlayerUUID(), itemStack, d2 - d4));
                    merchant.setBalance(a2, merchant.getBalance(a2) - d2);
                    MerchantGroup merchantGroup = merchant.getGroup();
                    if (b.GLOBAL_MARKET.getProtectedConfig().g("Transaction.Selling.Send-To-Mailbox")) {
                        Mailbox mailbox = merchant.getMailbox();
                        d.a(mailbox, true);
                        ItemMail itemMail = mailbox.addMail(this.trader.getUniqueId(), this.trader.getName(), ItemMailType.FROM_TRANSACTION, System.currentTimeMillis(), merchantGroup.getExpirationTimeOfSelling(), itemStack, this.merchandise.getOwnerUUID(), this.merchandise.getOwnerName());
                        transactionResult.getRunTasks().add(() -> {
                            d.a(this.trader, itemMail);
                            Mailbox.record(itemMail, null);
                        });
                        transactionResult.setMail(itemMail);
                    } else if (this.trader.getInventory().firstEmpty() != -1) {
                        this.trader.getInventory().addItem(new ItemStack[]{new ItemStack(itemStack)});
                    } else {
                        Mailbox mailbox = merchant.getMailbox();
                        d.a(mailbox, true);
                        ItemMail itemMail = mailbox.addMail(this.trader.getUniqueId(), this.trader.getName(), ItemMailType.FROM_TRANSACTION, System.currentTimeMillis(), merchantGroup.getExpirationTimeOfSelling(), itemStack, this.merchandise.getOwnerUUID(), this.merchandise.getOwnerName());
                        transactionResult.setMail(itemMail);
                        transactionResult.getRunTasks().add(() -> {
                            d.a(this.trader, itemMail);
                            Mailbox.record(itemMail, null);
                        });
                    }
                    transactionResult.setResultType(TransactionResultType.SUCCESSFUL);
                    transactionResult.setAmount(itemStack.getAmount());
                    transactionResult.setRetail(false);
                    transactionResult.setItem(itemStack);
                    transactionResult.setMerchandiseType(MerchandiseType.SELLING);
                    transactionResult.setAction(TransactionAction.ORIGINAL);
                    transactionResult.setPrice(d2);
                    transactionResult.setTrader(merchant);
                    transactionResult.setMerchant(merchant2);
                    this.record(transactionResult);
                    return transactionResult;
                }
                case PURCHASING: {
                    GlobalMarket globalMarket = GlobalMarket.getGlobalMarket();
                    if (this.isRetail) {
                        boolean bl;
                        ItemStack itemStack3 = new ItemStack(itemStack);
                        itemStack3.setAmount(this.amount);
                        if (!this.merchandise.getMerchandiseOption().isUnlimited()) {
                            double d9 = this.merchandise.getPrice();
                            if (itemStack.getAmount() > this.amount) {
                                itemStack.setAmount(itemStack.getAmount() - this.amount);
                                bl = globalMarket.saveMerchandise(this.merchandise.getMerchandiseUID(), UUID.randomUUID().toString());
                                if (this.merchandise.getPrice() != -1.0) {
                                    this.merchandise.setPrice(-1.0);
                                    if (globalMarket.saveMerchandise(this.merchandise.getMerchandiseUID(), UUID.randomUUID().toString())) {
                                        merchant2.setBalance(a2, merchant2.getBalance(a2) + d9);
                                        if (d9 != 0.0) {
                                            transactionResult.getRunTasks().add(() -> d.b(merchant2.getPlayerUUID(), itemStack, d9));
                                        }
                                    }
                                }
                            } else {
                                if (!globalMarket.removeMerchandise(this.merchandise.getMerchandiseUID())) {
                                    globalMarket.reloadMarket();
                                    transactionResult.setResultType(TransactionResultType.NOT_EXIST);
                                    return transactionResult;
                                }
                                bl = true;
                                if (d9 != 0.0 && d9 != -1.0) {
                                    merchant2.setBalance(a2, merchant2.getBalance(a2) + d9);
                                    transactionResult.getRunTasks().add(() -> d.b(merchant2.getPlayerUUID(), itemStack, d9));
                                }
                            }
                        } else {
                            bl = true;
                        }
                        if (bl) {
                            transactionResult.getRunTasks().add(() -> d.b(merchant.getPlayer(), itemStack.getType(), itemStack.getData().getData(), itemStack.getItemMeta(), Merchandise.comparisonMeta(), this.amount));
                            merchant.setBalance(a2, merchant.getBalance(a2) + (double)this.amount * d3);
                            Mailbox mailbox = merchant2.getMailbox();
                            MerchantGroup merchantGroup = merchant2.getGroup();
                            d.a(mailbox, true);
                            ItemMail itemMail = mailbox.addMail(merchant2.getPlayerUUID(), merchant2.getPlayerName(), ItemMailType.FROM_TRANSACTION, System.currentTimeMillis(), merchantGroup.getExpirationTimeOfPurchasing(), itemStack3, this.trader.getUniqueId(), this.trader.getName());
                            transactionResult.getRunTasks().add(() -> {
                                d.a(this.trader.getName(), merchant2.getPlayerUUID(), itemMail, (double)this.amount * d3, this.amount);
                                Mailbox.record(itemMail, null);
                            });
                            transactionResult.setMail(itemMail);
                            transactionResult.setResultType(TransactionResultType.SUCCESSFUL);
                            transactionResult.setAmount(this.amount);
                            transactionResult.setRetail(true);
                            transactionResult.setItem(itemStack3);
                            transactionResult.setMerchandiseType(MerchandiseType.PURCHASING);
                            transactionResult.setAction(TransactionAction.RETAIL);
                            transactionResult.setPrice((double)this.amount * d3);
                            transactionResult.setTrader(merchant);
                            transactionResult.setMerchant(merchant2);
                            this.record(transactionResult);
                        } else {
                            transactionResult.setResultType(TransactionResultType.FAILED);
                            transactionResult.setAmount(this.amount);
                            transactionResult.setRetail(true);
                            transactionResult.setItem(itemStack3);
                            transactionResult.setMerchandiseType(MerchandiseType.PURCHASING);
                            transactionResult.setAction(TransactionAction.RETAIL);
                            transactionResult.setPrice((double)this.amount * d3);
                            transactionResult.setTrader(merchant);
                            transactionResult.setMerchant(merchant2);
                            globalMarket.reloadMarket();
                        }
                        return transactionResult;
                    }
                    if (!this.merchandise.getMerchandiseOption().isUnlimited()) {
                        double d10;
                        double d11 = d10 = this.merchandise.getRetailPrice() != -1.0 ? this.merchandise.getRetailPrice() * (double)itemStack.getAmount() : 0.0;
                        if (!globalMarket.removeMerchandise(this.merchandise.getMerchandiseUID())) {
                            globalMarket.reloadMarket();
                            transactionResult.setResultType(TransactionResultType.NOT_EXIST);
                            return transactionResult;
                        }
                        if (d10 != 0.0) {
                            merchant2.setBalance(a2, merchant2.getBalance(a2) + d10);
                            transactionResult.getRunTasks().add(() -> d.a(merchant2.getPlayerUUID(), itemStack, d10));
                        }
                    }
                    transactionResult.getRunTasks().add(() -> d.b(merchant.getPlayer(), itemStack, Merchandise.comparisonMeta()));
                    merchant.setBalance(a2, merchant.getBalance(a2) + d2);
                    Mailbox mailbox = merchant2.getMailbox();
                    d.a(mailbox, true);
                    MerchantGroup merchantGroup = merchant2.getGroup();
                    ItemMail itemMail = mailbox.addMail(merchant2.getPlayerUUID(), merchant2.getPlayerName(), ItemMailType.FROM_TRANSACTION, System.currentTimeMillis(), merchantGroup.getExpirationTimeOfPurchasing(), itemStack, this.trader.getUniqueId(), this.trader.getName());
                    transactionResult.getRunTasks().add(() -> {
                        d.a(this.trader.getName(), merchant2.getPlayerUUID(), itemMail, d2);
                        Mailbox.record(itemMail, null);
                    });
                    transactionResult.setMail(itemMail);
                    transactionResult.setResultType(TransactionResultType.SUCCESSFUL);
                    transactionResult.setAmount(itemStack.getAmount());
                    transactionResult.setRetail(false);
                    transactionResult.setItem(itemStack);
                    transactionResult.setMerchandiseType(MerchandiseType.PURCHASING);
                    transactionResult.setAction(TransactionAction.ORIGINAL);
                    transactionResult.setPrice(d2);
                    transactionResult.setTrader(merchant);
                    transactionResult.setMerchant(merchant2);
                    this.record(transactionResult);
                    return transactionResult;
                }
            }
        } else {
            switch (this.merchandise.getMerchandiseType()) {
                case PURCHASING: {
                    transactionResult.setResultType(TransactionResultType.CANT_AFFORD_BY_ITEM);
                    return transactionResult;
                }
                case SELLING: {
                    transactionResult.setResultType(TransactionResultType.CANT_AFFORD_BY_MONEY);
                    return transactionResult;
                }
            }
        }
        transactionResult.setResultType(TransactionResultType.NOT_EXIST);
        return transactionResult;
    }

    public boolean canAfford(studio.trc.bukkit.globalmarketplus.f.a a2) {
        return this.canAfford(a2, Merchant.getMerchant(this.trader));
    }

    public boolean canAfford(studio.trc.bukkit.globalmarketplus.f.a a2, Merchant merchant) {
        ItemStack itemStack = this.merchandise.getItem();
        if (this.trader != null) {
            switch (this.merchandise.getMerchandiseType()) {
                case SELLING: {
                    if (this.isRetail) {
                        return merchant.getBalance(a2) >= this.merchandise.getRetailPrice() * (double)this.amount;
                    }
                    return merchant.getBalance(a2) >= this.merchandise.getPrice();
                }
                case PURCHASING: {
                    if (this.isRetail) {
                        ItemStack itemStack2 = new ItemStack(this.merchandise.getItem());
                        itemStack2.setAmount(this.amount);
                        return d.a(this.trader, itemStack2, Merchandise.comparisonMeta());
                    }
                    return d.a(this.trader, itemStack, Merchandise.comparisonMeta());
                }
            }
        }
        return false;
    }

    public void record(TransactionResult transactionResult) {
        g g2;
        a a2;
        if (transactionResult != null && a.c() && a.a(studio.trc.bukkit.globalmarketplus.j.c.TRANSACTION_RECORD) && !(a2 = a.b()).a(g2 = new g(System.currentTimeMillis(), transactionResult.getTrader().getPlayerUUID(), transactionResult.getTrader().getPlayerName(), transactionResult.getPrice(), this.merchandise, transactionResult.getAction()))) {
            Map map = studio.trc.bukkit.globalmarketplus.g.c.e();
            map.put("{record}", g2.k().toJSONString());
            c.a("CreateRecordFailed", map);
        }
    }

    public Merchandise getMerchandise() {
        return this.merchandise;
    }

    public Player getTrader() {
        return this.trader;
    }

    public boolean isRetail() {
        return this.isRetail;
    }

    public int getAmount() {
        return this.amount;
    }
}

