/*
 * Decompiled with CFR 0.152.
 */
package studio.trc.bukkit.globalmarketplus.merchandise.auction;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import studio.trc.bukkit.globalmarketplus.api.GlobalMarket;
import studio.trc.bukkit.globalmarketplus.api.Mailbox;
import studio.trc.bukkit.globalmarketplus.api.Merchant;
import studio.trc.bukkit.globalmarketplus.api.a;
import studio.trc.bukkit.globalmarketplus.mailbox.ItemMail;
import studio.trc.bukkit.globalmarketplus.mailbox.ItemMailType;
import studio.trc.bukkit.globalmarketplus.merchandise.Merchandise;
import studio.trc.bukkit.globalmarketplus.merchandise.MerchandiseOption;
import studio.trc.bukkit.globalmarketplus.merchandise.MerchandiseType;
import studio.trc.bukkit.globalmarketplus.merchandise.auction.AuctionResult;
import studio.trc.bukkit.globalmarketplus.merchandise.auction.AuctionResultType;
import studio.trc.bukkit.globalmarketplus.merchant.MerchantGroup;
import studio.trc.bukkit.globalmarketplus.n.c;
import studio.trc.bukkit.globalmarketplus.n.d;

public class Auction
extends Merchandise {
    private final double taxed;
    private double biddingPrice;
    private long lastBiddingTime;
    private UUID topBidder = null;
    private String topBidderName = null;
    private Set participants = new HashSet();

    public Auction(long l2, UUID uUID, String string, ItemStack itemStack, MerchandiseType merchandiseType, MerchandiseOption merchandiseOption, long l3, long l4, double d2, double d3) {
        super(l2, uUID, string, itemStack, merchandiseType, merchandiseOption, l3, l4, d2);
        this.taxed = d3;
        this.biddingPrice = d2;
    }

    public AuctionResult confirm(boolean bl) {
        AuctionResult auctionResult = new AuctionResult(this);
        if (this.topBidder == null) {
            auctionResult.setResultType(AuctionResultType.NO_BIDDER);
            return auctionResult;
        }
        if (this.isExpired() && !bl) {
            auctionResult.setResultType(AuctionResultType.EXPIRED);
            return auctionResult;
        }
        studio.trc.bukkit.globalmarketplus.f.a a2 = studio.trc.bukkit.globalmarketplus.f.a.useMultipleCurrency() ? this.getCurrency() : studio.trc.bukkit.globalmarketplus.f.a.getSystemCurrency();
        Merchant merchant = Merchant.getMerchant(this.topBidder);
        Merchant merchant2 = Merchant.getMerchant(this.getOwnerUUID());
        d.a(merchant2, true);
        d.a(merchant, true);
        ItemStack itemStack = this.getItem();
        GlobalMarket globalMarket = GlobalMarket.getGlobalMarket();
        ItemStack itemStack2 = new ItemStack(itemStack);
        if (globalMarket.removeMerchandise(this.getMerchandiseUID())) {
            double d2 = this.biddingPrice * merchant2.getGroup().getTaxRate_Bidding() - this.taxed;
            d.a(merchant2, a2, this.biddingPrice - d2);
            MerchantGroup merchantGroup = merchant.getGroup();
            Player player = merchant.getPlayer();
            Mailbox mailbox = merchant.getMailbox();
            d.a(mailbox, true);
            ItemMail itemMail = mailbox.addMail(merchant.getPlayerUUID(), merchant.getPlayerName(), ItemMailType.FROM_AUCTION, System.currentTimeMillis(), merchantGroup.getExpirationTimeOfMail(), itemStack2, this.getOwnerUUID(), this.getOwnerName());
            auctionResult.getRunTasks().add(() -> {
                d.a(player, itemMail);
                Mailbox.record(itemMail, null);
            });
            auctionResult.setMail(itemMail);
            auctionResult.setResultType(AuctionResultType.SUCCESSFUL);
            auctionResult.setItem(itemStack2);
            auctionResult.setMerchant(merchant2);
            auctionResult.setExtraTaxed(d2);
            auctionResult.setPrice(this.biddingPrice);
            auctionResult.setTopBidder(merchant);
            this.record(auctionResult);
        } else {
            auctionResult.setResultType(AuctionResultType.FAILED);
        }
        return auctionResult;
    }

    public void record(AuctionResult auctionResult) {
        studio.trc.bukkit.globalmarketplus.j.b.a a2;
        a a3;
        if (auctionResult != null && a.c() && a.a(studio.trc.bukkit.globalmarketplus.j.c.AUCTION_RECORD) && !(a3 = a.b()).a(a2 = new studio.trc.bukkit.globalmarketplus.j.b.a(System.currentTimeMillis(), auctionResult.getTopBidder().getPlayerUUID(), auctionResult.getTopBidder().getPlayerName(), auctionResult.getPrice(), this))) {
            Map map = studio.trc.bukkit.globalmarketplus.g.c.e();
            map.put("{record}", a2.k().toJSONString());
            c.a("CreateRecordFailed", map);
        }
    }

    @Override
    public double getTaxed() {
        return this.taxed;
    }

    public double getBiddingPrice() {
        return this.biddingPrice;
    }

    public void setBiddingPrice(double d2) {
        this.biddingPrice = d2;
    }

    public long getLastBiddingTime() {
        return this.lastBiddingTime;
    }

    public void setLastBiddingTime(long l2) {
        this.lastBiddingTime = l2;
    }

    public UUID getTopBidder() {
        return this.topBidder;
    }

    public void setTopBidder(UUID uUID) {
        this.topBidder = uUID;
    }

    public String getTopBidderName() {
        return this.topBidderName;
    }

    public void setTopBidderName(String string) {
        this.topBidderName = string;
    }

    public Set getParticipants() {
        return this.participants;
    }

    public void setParticipants(Set set) {
        this.participants = set;
    }
}

