/*
 * Decompiled with CFR 0.152.
 */
package studio.trc.bukkit.globalmarketplus.merchant;

import com.pa_project.lib.json.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import studio.trc.bukkit.globalmarketplus.api.Merchant;
import studio.trc.bukkit.globalmarketplus.merchant.MerchantParameter;
import studio.trc.bukkit.globalmarketplus.merchant.MerchantStore$Statistics;
import studio.trc.bukkit.globalmarketplus.n.c;

public class MerchantStore {
    private final UUID ownerUUID;
    private final Merchant merchant;
    private boolean storeClosed = false;
    private String storeName = null;
    private MerchantStore$Statistics statistics = new MerchantStore$Statistics(this);
    private List storeDescription = new ArrayList();

    public MerchantStore(UUID uUID, Merchant merchant, boolean bl) {
        this.ownerUUID = uUID;
        this.merchant = merchant;
        if (bl) {
            this.storeClosed = MerchantParameter.STORE_CLOSED.getBoolean();
        }
    }

    public void setOptionValue(MerchantParameter merchantParameter, Object object, boolean bl) {
        switch (merchantParameter) {
            case STORE_CLOSED: {
                this.storeClosed = Boolean.valueOf(object.toString());
                break;
            }
            case STORE_NAME: {
                this.storeName = object.toString();
                break;
            }
            case STORE_DESCRIPTION: {
                this.storeDescription = (List)object;
            }
        }
    }

    public Object getOptionValue(MerchantParameter merchantParameter) {
        switch (merchantParameter) {
            case STORE_CLOSED: {
                return this.storeClosed;
            }
            case STORE_NAME: {
                return this.storeName;
            }
            case STORE_DESCRIPTION: {
                return this.storeDescription;
            }
        }
        return null;
    }

    public String getDisplayStoreName() {
        if (this.storeName == null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("{player}", Bukkit.getPlayer((UUID)this.ownerUUID) != null ? Bukkit.getPlayer((UUID)this.ownerUUID).getName() : (this.merchant.getPlayerName() != null ? this.merchant.getPlayerName() : c.b("Unknown")));
            return studio.trc.bukkit.globalmarketplus.g.c.a(MerchantParameter.STORE_NAME.getString(), hashMap);
        }
        return this.storeName;
    }

    public JSONObject serialize() {
        return MerchantStore.serialize(this);
    }

    public List getDisplayStoredescription() {
        return this.storeDescription.isEmpty() ? MerchantParameter.STORE_DESCRIPTION.getStringList() : this.storeDescription;
    }

    public static JSONObject serialize(MerchantStore merchantStore) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("OwnerUUID", merchantStore.ownerUUID.toString());
        if (merchantStore.statistics != null) {
            jSONObject.put("Statistics", merchantStore.statistics.serialize());
        }
        if (merchantStore.storeName != null && !merchantStore.storeName.equals(MerchantParameter.STORE_NAME.getString())) {
            jSONObject.put("StoreName", merchantStore.storeName);
        }
        if (!merchantStore.storeDescription.isEmpty() && !merchantStore.storeDescription.equals(MerchantParameter.STORE_DESCRIPTION.getStringList())) {
            jSONObject.put("StoreDescription", merchantStore.storeDescription);
        }
        if (merchantStore.storeClosed != MerchantParameter.STORE_CLOSED.getBoolean()) {
            jSONObject.put("StoreClosed", merchantStore.storeClosed);
        }
        return jSONObject;
    }

    public static MerchantStore deserialize(JSONObject jSONObject, Merchant merchant) {
        MerchantStore merchantStore = new MerchantStore(UUID.fromString(jSONObject.getString("OwnerUUID")), merchant, false);
        if (jSONObject.containsKey("Statistics")) {
            merchantStore.setStatistics(MerchantStore$Statistics.deserialize(jSONObject.getJSONObject("Statistics"), merchantStore));
        }
        if (jSONObject.containsKey("StoreClosed")) {
            merchantStore.setStoreClosed(jSONObject.getBoolean("StoreClosed"));
        }
        if (jSONObject.containsKey("StoreName")) {
            merchantStore.setStoreName(jSONObject.getString("StoreName"));
        }
        if (jSONObject.containsKey("StoreDescription")) {
            merchantStore.setStoreDescription(jSONObject.getJSONArray("StoreDescription"));
        }
        return merchantStore;
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public Merchant getMerchant() {
        return this.merchant;
    }

    public boolean isStoreClosed() {
        return this.storeClosed;
    }

    public void setStoreClosed(boolean bl) {
        this.storeClosed = bl;
    }

    public String getStoreName() {
        return this.storeName;
    }

    public void setStoreName(String string) {
        this.storeName = string;
    }

    public MerchantStore$Statistics getStatistics() {
        return this.statistics;
    }

    public void setStatistics(MerchantStore$Statistics merchantStore$Statistics) {
        this.statistics = merchantStore$Statistics;
    }

    public List getStoreDescription() {
        return this.storeDescription;
    }

    public void setStoreDescription(List list) {
        this.storeDescription = list;
    }
}

