/*
 * Decompiled with CFR 0.152.
 */
package com.dumptruckman.bukkit.configuration.json;

import com.dumptruckman.bukkit.configuration.SerializableSet;
import com.dumptruckman.bukkit.configuration.json.JsonConfigurationOptions;
import com.dumptruckman.bukkit.configuration.util.SerializationHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minidev.json.JSONValue;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.jetbrains.annotations.NotNull;

public class JsonConfiguration
extends FileConfiguration {
    protected static final String BLANK_CONFIG = "{}\n";
    private static final Logger LOG = Logger.getLogger(JsonConfiguration.class.getName());

    @NotNull
    public String saveToString() {
        String string = JSONValue.toJSONString(SerializationHelper.serialize(this.getValues(false)));
        if (string.equals(BLANK_CONFIG)) {
            string = "";
        }
        return string;
    }

    public void loadFromString(@NotNull String string) {
        Map map;
        if (string.isEmpty()) {
            return;
        }
        try {
            map = (Map)new JSONParser(16).parse(string);
        }
        catch (ParseException parseException) {
            throw new InvalidConfigurationException("Invalid JSON detected.", (Throwable)parseException);
        }
        catch (ClassCastException classCastException) {
            throw new InvalidConfigurationException("Top level is not a Map.", (Throwable)classCastException);
        }
        if (map == null) {
            throw new InvalidConfigurationException("An unknown error occurred while attempting to parse the json.");
        }
        this.convertMapsToSections(map, (ConfigurationSection)this);
    }

    private void convertMapsToSections(@NotNull Map<?, ?> map, @NotNull ConfigurationSection configurationSection) {
        Object object = SerializationHelper.deserialize(map);
        if (object instanceof Map) {
            map = (Map)object;
            for (Map.Entry entry : map.entrySet()) {
                String string = entry.getKey().toString();
                Object v = entry.getValue();
                if (v instanceof Map) {
                    this.convertMapsToSections((Map)v, configurationSection.createSection(string));
                    continue;
                }
                configurationSection.set(string, v);
            }
        } else {
            configurationSection.set("", object);
        }
    }

    protected String buildHeader() {
        return "";
    }

    public JsonConfigurationOptions options() {
        if (this.options == null) {
            this.options = new JsonConfigurationOptions(this);
        }
        return (JsonConfigurationOptions)this.options;
    }

    private static JsonConfiguration loadConfiguration(@NotNull JsonConfiguration jsonConfiguration, @NotNull File file) {
        try {
            jsonConfiguration.load(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOG.log(Level.SEVERE, "Cannot find file " + file, fileNotFoundException);
        }
        catch (IOException iOException) {
            LOG.log(Level.SEVERE, "Cannot load " + file, iOException);
        }
        catch (InvalidConfigurationException invalidConfigurationException) {
            LOG.log(Level.SEVERE, "Cannot load " + file, invalidConfigurationException);
        }
        return jsonConfiguration;
    }

    public static JsonConfiguration loadConfiguration(@NotNull File file) {
        return JsonConfiguration.loadConfiguration(new JsonConfiguration(), file);
    }

    public JsonConfiguration() {
        ConfigurationSerialization.registerClass(SerializableSet.class);
    }
}

