/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.geantyref;

import io.leangen.geantyref.AnnotatedCaptureType;
import io.leangen.geantyref.AnnotatedTypeImpl;
import io.leangen.geantyref.CaptureType;
import io.leangen.geantyref.CaptureTypeImpl;
import io.leangen.geantyref.VarMap;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.AnnotatedTypeVariable;
import java.lang.reflect.AnnotatedWildcardType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;

class AnnotatedCaptureTypeImpl
extends AnnotatedTypeImpl
implements AnnotatedCaptureType {
    private final AnnotatedWildcardType wildcard;
    private final AnnotatedTypeVariable variable;
    private final AnnotatedType[] lowerBounds;
    private AnnotatedType[] upperBounds;
    private final CaptureType type;
    private final Annotation[] declaredAnnotations;

    AnnotatedCaptureTypeImpl(AnnotatedWildcardType annotatedWildcardType, AnnotatedTypeVariable annotatedTypeVariable) {
        this(new CaptureTypeImpl((WildcardType)annotatedWildcardType.getType(), (TypeVariable)annotatedTypeVariable.getType()), annotatedWildcardType, annotatedTypeVariable);
    }

    AnnotatedCaptureTypeImpl(CaptureType captureType, AnnotatedWildcardType annotatedWildcardType, AnnotatedTypeVariable annotatedTypeVariable) {
        this(captureType, annotatedWildcardType, annotatedTypeVariable, null, null);
    }

    AnnotatedCaptureTypeImpl(CaptureType captureType, AnnotatedWildcardType annotatedWildcardType, AnnotatedTypeVariable annotatedTypeVariable, AnnotatedType[] annotatedTypeArray, Annotation[] annotationArray) {
        super(captureType, annotationArray != null ? annotationArray : (Annotation[])Stream.concat(Arrays.stream(annotatedWildcardType.getAnnotations()), Arrays.stream(annotatedTypeVariable.getAnnotations())).toArray(Annotation[]::new));
        this.type = captureType;
        this.wildcard = annotatedWildcardType;
        this.variable = annotatedTypeVariable;
        this.lowerBounds = annotatedWildcardType.getAnnotatedLowerBounds();
        this.upperBounds = annotatedTypeArray;
        this.declaredAnnotations = (Annotation[])Stream.concat(Arrays.stream(annotatedWildcardType.getDeclaredAnnotations()), Arrays.stream(annotatedTypeVariable.getDeclaredAnnotations())).toArray(Annotation[]::new);
    }

    void init(VarMap varMap) {
        ArrayList<AnnotatedType> arrayList = new ArrayList<AnnotatedType>(Arrays.asList(varMap.map(this.variable.getAnnotatedBounds())));
        List<AnnotatedType> list2 = Arrays.asList(this.wildcard.getAnnotatedUpperBounds());
        if (list2.size() > 0 && list2.get(0).getType() == Object.class) {
            arrayList.addAll(list2.subList(1, list2.size()));
        } else {
            arrayList.addAll(list2);
        }
        this.upperBounds = new AnnotatedType[arrayList.size()];
        arrayList.toArray(this.upperBounds);
        ((CaptureTypeImpl)this.type).init(varMap);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.declaredAnnotations;
    }

    @Override
    public AnnotatedType[] getAnnotatedUpperBounds() {
        assert (this.upperBounds != null);
        return (AnnotatedType[])this.upperBounds.clone();
    }

    @Override
    public void setAnnotatedUpperBounds(AnnotatedType[] annotatedTypeArray) {
        this.upperBounds = annotatedTypeArray;
        this.type.setUpperBounds((Type[])Arrays.stream(annotatedTypeArray).map(AnnotatedType::getType).toArray(Type[]::new));
    }

    @Override
    public AnnotatedType[] getAnnotatedLowerBounds() {
        return (AnnotatedType[])this.lowerBounds.clone();
    }

    @Override
    public AnnotatedTypeVariable getAnnotatedTypeVariable() {
        return this.variable;
    }

    @Override
    public AnnotatedWildcardType getAnnotatedWildcardType() {
        return this.wildcard;
    }
}

