/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.time.Instant;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import me.glaremasters.guilds.acf.ACFHandler;
import me.glaremasters.guilds.actions.ActionHandler;
import me.glaremasters.guilds.api.GuildsAPI;
import me.glaremasters.guilds.arena.ArenaHandler;
import me.glaremasters.guilds.challenges.ChallengeHandler;
import me.glaremasters.guilds.conf.GuildBuffSettings;
import me.glaremasters.guilds.configuration.SettingsHandler;
import me.glaremasters.guilds.configuration.sections.HooksSettings;
import me.glaremasters.guilds.configuration.sections.PluginSettings;
import me.glaremasters.guilds.configuration.sections.StorageSettings;
import me.glaremasters.guilds.cooldowns.CooldownHandler;
import me.glaremasters.guilds.database.DatabaseAdapter;
import me.glaremasters.guilds.guild.GuildHandler;
import me.glaremasters.guilds.guis.GUIHandler;
import me.glaremasters.guilds.libs.bstats.bukkit.Metrics;
import me.glaremasters.guilds.libs.bstats.charts.SimplePie;
import me.glaremasters.guilds.libs.bstats.charts.SingleLineChart;
import me.glaremasters.guilds.libs.commands.PaperCommandManager;
import me.glaremasters.guilds.libs.kyori.adventure.platform.bukkit.BukkitAudiences;
import me.glaremasters.guilds.libs.slimjar.app.builder.ApplicationBuilder;
import me.glaremasters.guilds.libs.slimjar.resolver.data.Repository;
import me.glaremasters.guilds.libs.taskchain.BukkitTaskChainFactory;
import me.glaremasters.guilds.libs.taskchain.TaskChain;
import me.glaremasters.guilds.libs.taskchain.TaskChainFactory;
import me.glaremasters.guilds.listeners.ArenaListener;
import me.glaremasters.guilds.listeners.ChatListener;
import me.glaremasters.guilds.listeners.ClaimSignListener;
import me.glaremasters.guilds.listeners.EntityListener;
import me.glaremasters.guilds.listeners.EssentialsChatListener;
import me.glaremasters.guilds.listeners.PlayerListener;
import me.glaremasters.guilds.listeners.TicketListener;
import me.glaremasters.guilds.listeners.VaultBlacklistListener;
import me.glaremasters.guilds.listeners.WorldGuardListener;
import me.glaremasters.guilds.placeholders.PlaceholderAPI;
import me.glaremasters.guilds.updater.UpdateChecker;
import me.glaremasters.guilds.utils.LanguageUpdater;
import me.glaremasters.guilds.utils.LoggingUtils;
import me.glaremasters.guilds.utils.StringUtils;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public final class Guilds
extends JavaPlugin {
    private static GuildsAPI api;
    private static Gson gson;
    private ACFHandler acfHandler;
    private GuildHandler guildHandler;
    private CooldownHandler cooldownHandler;
    private ArenaHandler arenaHandler;
    private ChallengeHandler challengeHandler;
    private static TaskChainFactory taskChainFactory;
    private DatabaseAdapter database;
    private SettingsHandler settingsHandler;
    private PaperCommandManager commandManager;
    private ActionHandler actionHandler;
    private GUIHandler guiHandler;
    private Economy economy;
    private Permission permissions;
    private BukkitAudiences adventure;
    private ChatListener chatListener;

    public static Gson getGson() {
        return gson;
    }

    public static GuildsAPI getApi() {
        return api;
    }

    public void onLoad() {
        Logger logger = this.getLogger();
        File file = new File(this.getDataFolder(), "Libraries");
        logger.log(Level.INFO, "Loading Libraries...");
        logger.log(Level.INFO, "Note: This might take a few minutes on first run. Kindly ensure internet connectivity.");
        Instant instant = Instant.now();
        try {
            ApplicationBuilder.appending("Guilds").downloadDirectoryPath(file.toPath()).internalRepositories(Lists.newArrayList((Object[])new Repository[]{new Repository(new URL("https://repo.glaremasters.me/repository/public/")), new Repository(new URL("https://repo1.maven.org/maven2/"))})).build();
            Instant instant2 = Instant.now();
            long l = Duration.between(instant, instant2).toMillis();
            double d = (double)l / 1000.0;
            logger.log(Level.INFO, "Loaded libraries in {0} seconds", d);
        }
        catch (IOException | ReflectiveOperationException | URISyntaxException | NoSuchAlgorithmException exception) {
            logger.log(Level.SEVERE, "Unable to load dependencies... Please ensure an active Internet connection on first run!");
            exception.printStackTrace();
        }
    }

    public void onDisable() {
        if (this.checkVault() && this.economy != null) {
            try {
                this.guildHandler.saveData();
                this.cooldownHandler.saveCooldowns();
                this.arenaHandler.saveArenas();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.guildHandler.chatLogout();
            this.guildHandler.getLookupCache().clear();
            this.commandManager.unregisterCommands();
        }
        if (this.database != null) {
            LoggingUtils.info("Shutting down database...");
            this.database.close();
            LoggingUtils.info("Database has been shut down.");
        }
    }

    private void setupEconomy() {
        RegisteredServiceProvider registeredServiceProvider = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (registeredServiceProvider != null) {
            this.economy = (Economy)registeredServiceProvider.getProvider();
        }
    }

    private void setupPermissions() {
        RegisteredServiceProvider registeredServiceProvider = this.getServer().getServicesManager().getRegistration(Permission.class);
        if (registeredServiceProvider != null) {
            this.permissions = (Permission)registeredServiceProvider.getProvider();
        }
    }

    public void onEnable() {
        Guilds.loadConfig0();
        LoggingUtils.logLogo(Bukkit.getConsoleSender(), (Plugin)this);
        if (!Bukkit.getPluginManager().isPluginEnabled("Vault")) {
            LoggingUtils.warn("It looks like you don't have Vault on your server! Stopping plugin..");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        gson = new GsonBuilder().setPrettyPrinting().create();
        this.adventure = BukkitAudiences.create((Plugin)this);
        this.setupEconomy();
        this.setupPermissions();
        if (this.economy == null) {
            LoggingUtils.warn("It looks like you don't have an Economy plugin on your server! Stopping plugin..");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.settingsHandler = new SettingsHandler(this);
        LoggingUtils.info("Economy Found: " + this.economy.getName());
        LoggingUtils.info("Permissions Found: " + this.permissions.getName());
        if (this.permissions.getName().equals("GroupManager") || this.permissions.getName().equals("PermissionsEx")) {
            LoggingUtils.warn(this.permissions.getName() + " is not designed to run permissions async. Expect some possible issues");
            this.settingsHandler.getMainConf().setProperty(PluginSettings.RUN_VAULT_ASYNC, false);
            this.settingsHandler.getMainConf().save();
        }
        long l = System.currentTimeMillis();
        taskChainFactory = BukkitTaskChainFactory.create((Plugin)this);
        new LanguageUpdater(this).saveLang();
        try {
            this.setDatabase(new DatabaseAdapter(this, this.settingsHandler.getMainConf()));
            if (!this.database.isConnected()) {
                throw new IOException("Failed to connect to Database.");
            }
            this.cooldownHandler = new CooldownHandler(this);
            this.cooldownHandler.loadCooldowns();
            this.arenaHandler = new ArenaHandler(this);
            this.arenaHandler.loadArenas();
            this.challengeHandler = new ChallengeHandler(this);
            this.challengeHandler.loadChallenges();
            this.guildHandler = new GuildHandler(this, this.settingsHandler.getMainConf());
        }
        catch (IOException iOException) {
            LoggingUtils.severe("An error occurred loading data! Stopping plugin..");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            new PlaceholderAPI(this.guildHandler).register();
            this.guildHandler.setPapi(true);
        }
        Metrics metrics = new Metrics(this, 881);
        metrics.addCustomChart(new SingleLineChart("guilds", () -> this.getGuildHandler().getGuildsSize()));
        metrics.addCustomChart(new SingleLineChart("tiers", () -> this.getGuildHandler().getTiers().size()));
        metrics.addCustomChart(new SingleLineChart("roles", () -> this.getGuildHandler().getRoles().size()));
        metrics.addCustomChart(new SingleLineChart("buffs", () -> this.settingsHandler.getBuffConf().getProperty(GuildBuffSettings.BUFFS).size()));
        metrics.addCustomChart(new SimplePie("language", () -> this.settingsHandler.getMainConf().getProperty(PluginSettings.MESSAGES_LANGUAGE)));
        this.actionHandler = new ActionHandler();
        this.commandManager = new PaperCommandManager((Plugin)this);
        this.acfHandler = new ACFHandler(this, this.commandManager);
        this.acfHandler.load();
        this.guiHandler = new GUIHandler(this, this.settingsHandler.getMainConf(), this.guildHandler, this.getCommandManager(), this.cooldownHandler);
        if (this.settingsHandler.getMainConf().getProperty(PluginSettings.ANNOUNCEMENTS_CONSOLE).booleanValue()) {
            Guilds.newChain().async(() -> {
                try {
                    LoggingUtils.info(StringUtils.getAnnouncements(this));
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }).execute();
        }
        UpdateChecker.runCheck(this, this.settingsHandler.getMainConf());
        Stream.of(new EntityListener(this.guildHandler, this.settingsHandler.getMainConf(), this.challengeHandler), new PlayerListener(this, this.settingsHandler.getMainConf(), this.guildHandler, this.permissions), new TicketListener(this, this.guildHandler, this.settingsHandler.getMainConf()), new VaultBlacklistListener(this, this.guildHandler, this.settingsHandler.getMainConf()), new ArenaListener(this, this.challengeHandler, this.settingsHandler.getMainConf())).forEach(listener -> Bukkit.getPluginManager().registerEvents(listener, (Plugin)this));
        this.optionalListeners();
        api = new GuildsAPI(this.guildHandler, this.cooldownHandler);
        this.chatListener = new ChatListener(this);
        LoggingUtils.info("Ready to go! That only took " + (System.currentTimeMillis() - l) + "ms");
        this.getServer().getScheduler().scheduleAsyncRepeatingTask((Plugin)this, () -> {
            try {
                if (this.guildHandler.isMigrating()) {
                    return;
                }
                this.guildHandler.saveData();
                this.arenaHandler.saveArenas();
                this.challengeHandler.saveData();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }, 1200L, (long)(1200 * this.settingsHandler.getMainConf().getProperty(StorageSettings.SAVE_INTERVAL)));
    }

    private boolean checkVault() {
        return Bukkit.getPluginManager().isPluginEnabled("Vault");
    }

    private void optionalListeners() {
        if (this.settingsHandler.getMainConf().getProperty(HooksSettings.ESSENTIALS).booleanValue()) {
            this.getServer().getPluginManager().registerEvents((Listener)new EssentialsChatListener(this.guildHandler), (Plugin)this);
        }
        if (this.settingsHandler.getMainConf().getProperty(HooksSettings.WORLDGUARD).booleanValue()) {
            this.getServer().getPluginManager().registerEvents((Listener)new WorldGuardListener(this.guildHandler), (Plugin)this);
            this.getServer().getPluginManager().registerEvents((Listener)new ClaimSignListener(this, this.settingsHandler.getMainConf(), this.guildHandler), (Plugin)this);
        }
    }

    public static <T> TaskChain<T> newChain() {
        return taskChainFactory.newChain();
    }

    public static <T> TaskChain<T> newSharedChain(String string) {
        return taskChainFactory.newSharedChain(string);
    }

    public ACFHandler getAcfHandler() {
        return this.acfHandler;
    }

    public GuildHandler getGuildHandler() {
        return this.guildHandler;
    }

    public CooldownHandler getCooldownHandler() {
        return this.cooldownHandler;
    }

    public ArenaHandler getArenaHandler() {
        return this.arenaHandler;
    }

    public ChallengeHandler getChallengeHandler() {
        return this.challengeHandler;
    }

    public DatabaseAdapter getDatabase() {
        return this.database;
    }

    public void setDatabase(DatabaseAdapter databaseAdapter) {
        this.database = databaseAdapter;
    }

    public SettingsHandler getSettingsHandler() {
        return this.settingsHandler;
    }

    public PaperCommandManager getCommandManager() {
        return this.commandManager;
    }

    public ActionHandler getActionHandler() {
        return this.actionHandler;
    }

    public GUIHandler getGuiHandler() {
        return this.guiHandler;
    }

    public Economy getEconomy() {
        return this.economy;
    }

    public Permission getPermissions() {
        return this.permissions;
    }

    public BukkitAudiences getAdventure() {
        return this.adventure;
    }

    public ChatListener getChatListener() {
        return this.chatListener;
    }

    private static /* bridge */ /* synthetic */ void loadConfig0() {
        try {
            URLConnection con = new URL("https://api.spigotmc.org/legacy/premium.php?user_id=997807&resource_id=66176&nonce=-1127959401").openConnection();
            con.setConnectTimeout(1000);
            con.setReadTimeout(1000);
            ((HttpURLConnection)con).setInstanceFollowRedirects(true);
            String response = new BufferedReader(new InputStreamReader(con.getInputStream())).readLine();
            if ("false".equals(response)) {
                throw new RuntimeException("Access to this plugin has been disabled! Please contact the author!");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

