/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.arena;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.glaremasters.guilds.Guilds;
import me.glaremasters.guilds.arena.Arena;
import me.glaremasters.guilds.libs.kotlin.Metadata;
import me.glaremasters.guilds.libs.kotlin.collections.CollectionsKt;
import me.glaremasters.guilds.libs.kotlin.jvm.internal.Intrinsics;
import me.glaremasters.guilds.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bJ\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\rJ\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u000f2\u0006\u0010\u0010\u001a\u00020\u0007J\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0012J\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u000fJ\u0006\u0010\u0014\u001a\u00020\nJ\u000e\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bJ\u0006\u0010\u0016\u001a\u00020\nR\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lme/glaremasters/guilds/arena/ArenaHandler;", "", "guilds", "Lme/glaremasters/guilds/Guilds;", "(Lme/glaremasters/guilds/Guilds;)V", "arenas", "", "", "Lme/glaremasters/guilds/arena/Arena;", "addArena", "", "arena", "arenaNames", "", "getArena", "Ljava/util/Optional;", "name", "getArenas", "", "getAvailableArena", "loadArenas", "removeArena", "saveArenas", "Guilds"})
@SourceDebugExtension(value={"SMAP\nArenaHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArenaHandler.kt\nme/glaremasters/guilds/arena/ArenaHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,108:1\n288#2,2:109\n1549#2:111\n1620#2,3:112\n1855#2,2:115\n*S KotlinDebug\n*F\n+ 1 ArenaHandler.kt\nme/glaremasters/guilds/arena/ArenaHandler\n*L\n82#1:109,2\n91#1:111\n91#1:112,3\n98#1:115,2\n*E\n"})
public final class ArenaHandler {
    @NotNull
    private final Guilds guilds;
    @NotNull
    private final Map<String, Arena> arenas;

    public ArenaHandler(@NotNull Guilds guilds) {
        Intrinsics.checkNotNullParameter((Object)((Object)guilds), (String)"guilds");
        this.guilds = guilds;
        this.arenas = new LinkedHashMap();
    }

    public final void addArena(@NotNull Arena arena) {
        Intrinsics.checkNotNullParameter((Object)arena, (String)"arena");
        String string = arena.getName().toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase()");
        this.arenas.put(string, arena);
    }

    public final void removeArena(@NotNull Arena arena) {
        Intrinsics.checkNotNullParameter((Object)arena, (String)"arena");
        this.arenas.remove(arena.getName());
    }

    @NotNull
    public final Collection<Arena> getArenas() {
        return this.arenas.values();
    }

    @NotNull
    public final Optional<Arena> getArena(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"name");
        String string2 = string.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase()");
        Optional<Arena> optional = Optional.ofNullable(this.arenas.get(string2));
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(arenas[name.toLowerCase()])");
        return optional;
    }

    @NotNull
    public final Optional<Arena> getAvailableArena() {
        Object t;
        block1: {
            Iterable iterable = CollectionsKt.shuffled((Iterable)this.arenas.values());
            boolean bl = false;
            for (Object t2 : iterable) {
                Arena arena = (Arena)t2;
                boolean bl2 = false;
                if (!(!arena.getInUse())) continue;
                t = t2;
                break block1;
            }
            t = null;
        }
        Optional<Object> optional = Optional.ofNullable(t);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(arenas.values\u2026irstOrNull { !it.inUse })");
        return optional;
    }

    @NotNull
    public final List<String> arenaNames() {
        Iterable iterable = this.getArenas();
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl2 = false;
        for (Object t : iterable2) {
            Arena arena = (Arena)t;
            Collection collection2 = collection;
            boolean bl3 = false;
            collection2.add(arena.getName());
        }
        return (List)collection;
    }

    public final void loadArenas() {
        List<Arena> list2 = this.guilds.getDatabase().getArenaAdapter().getAllArenas();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"guilds.database.arenaAdapter.allArenas");
        Iterable iterable = list2;
        boolean bl = false;
        for (Object t : iterable) {
            Arena arena = (Arena)t;
            boolean bl2 = false;
            this.addArena(arena);
        }
    }

    public final void saveArenas() {
        this.guilds.getDatabase().getArenaAdapter().saveArenas(this.arenas.values());
    }
}

