/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.commands.admin.arena;

import java.util.Collection;
import java.util.UUID;
import me.glaremasters.guilds.Guilds;
import me.glaremasters.guilds.arena.Arena;
import me.glaremasters.guilds.arena.ArenaHandler;
import me.glaremasters.guilds.exceptions.ExpectationNotMet;
import me.glaremasters.guilds.guild.GuildHandler;
import me.glaremasters.guilds.libs.commands.ACFBukkitUtil;
import me.glaremasters.guilds.libs.commands.BaseCommand;
import me.glaremasters.guilds.libs.commands.annotation.CommandAlias;
import me.glaremasters.guilds.libs.commands.annotation.CommandCompletion;
import me.glaremasters.guilds.libs.commands.annotation.CommandPermission;
import me.glaremasters.guilds.libs.commands.annotation.Dependency;
import me.glaremasters.guilds.libs.commands.annotation.Description;
import me.glaremasters.guilds.libs.commands.annotation.Single;
import me.glaremasters.guilds.libs.commands.annotation.Subcommand;
import me.glaremasters.guilds.libs.commands.annotation.Syntax;
import me.glaremasters.guilds.libs.commands.annotation.Values;
import me.glaremasters.guilds.libs.kotlin.Metadata;
import me.glaremasters.guilds.libs.kotlin.collections.CollectionsKt;
import me.glaremasters.guilds.libs.kotlin.jvm.internal.Intrinsics;
import me.glaremasters.guilds.libs.kotlin.text.StringsKt;
import me.glaremasters.guilds.messages.Messages;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@CommandAlias(value="%guilds")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0001\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u0019\u001a\u00020\u001aH\u0007J\u0018\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001dH\u0007J\u001a\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u0019\u001a\u00020\u001aH\u0007J\u001a\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u0019\u001a\u00020\u001aH\u0007J\u0010\u0010 \u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J$\u0010!\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\b\b\u0001\u0010\"\u001a\u00020\u001dH\u0007R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u00020\u00108\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006#"}, d2={"Lme/glaremasters/guilds/commands/admin/arena/CommandAdminArena;", "Lme/glaremasters/guilds/libs/commands/BaseCommand;", "()V", "arenaHandler", "Lme/glaremasters/guilds/arena/ArenaHandler;", "getArenaHandler", "()Lme/glaremasters/guilds/arena/ArenaHandler;", "setArenaHandler", "(Lme/glaremasters/guilds/arena/ArenaHandler;)V", "guildHandler", "Lme/glaremasters/guilds/guild/GuildHandler;", "getGuildHandler", "()Lme/glaremasters/guilds/guild/GuildHandler;", "setGuildHandler", "(Lme/glaremasters/guilds/guild/GuildHandler;)V", "guilds", "Lme/glaremasters/guilds/Guilds;", "getGuilds", "()Lme/glaremasters/guilds/Guilds;", "setGuilds", "(Lme/glaremasters/guilds/Guilds;)V", "challenger", "", "player", "Lorg/bukkit/entity/Player;", "arena", "Lme/glaremasters/guilds/arena/Arena;", "create", "name", "", "defender", "delete", "list", "teleport", "location", "Guilds"})
public final class CommandAdminArena
extends BaseCommand {
    @Dependency
    public Guilds guilds;
    @Dependency
    public GuildHandler guildHandler;
    @Dependency
    public ArenaHandler arenaHandler;

    @NotNull
    public final Guilds getGuilds() {
        Guilds guilds = this.guilds;
        if (guilds != null) {
            return guilds;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"guilds");
        return null;
    }

    public final void setGuilds(@NotNull Guilds guilds) {
        Intrinsics.checkNotNullParameter((Object)((Object)guilds), (String)"<set-?>");
        this.guilds = guilds;
    }

    @NotNull
    public final GuildHandler getGuildHandler() {
        GuildHandler guildHandler = this.guildHandler;
        if (guildHandler != null) {
            return guildHandler;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"guildHandler");
        return null;
    }

    public final void setGuildHandler(@NotNull GuildHandler guildHandler) {
        Intrinsics.checkNotNullParameter((Object)guildHandler, (String)"<set-?>");
        this.guildHandler = guildHandler;
    }

    @NotNull
    public final ArenaHandler getArenaHandler() {
        ArenaHandler arenaHandler = this.arenaHandler;
        if (arenaHandler != null) {
            return arenaHandler;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"arenaHandler");
        return null;
    }

    public final void setArenaHandler(@NotNull ArenaHandler arenaHandler) {
        Intrinsics.checkNotNullParameter((Object)arenaHandler, (String)"<set-?>");
        this.arenaHandler = arenaHandler;
    }

    @Subcommand(value="arena set challenger")
    @CommandPermission(value="guilds.command.admin")
    @Description(value="{@@descriptions.arena-challenger}")
    @Syntax(value="%arena")
    @CommandCompletion(value="@arenas")
    public final void challenger(@NotNull Player player, @Values(value="@arenas") @NotNull Arena arena) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)arena, (String)"arena");
        arena.setChallenger(ACFBukkitUtil.fullLocationToString(player.getLocation()));
        String[] stringArray = new String[]{"{arena}", arena.getName()};
        this.getCurrentCommandIssuer().sendInfo(Messages.ARENA__CHALLENGER_SET, stringArray);
    }

    @Subcommand(value="arena create")
    @CommandPermission(value="guilds.command.admin")
    @Description(value="{@@descriptions.arena-create}")
    @Syntax(value="%name")
    public final void create(@NotNull Player player, @NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)string, (String)"name");
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID()");
        Arena arena = new Arena(uUID, string, null, null, false);
        this.getArenaHandler().addArena(arena);
        String[] stringArray = new String[]{"{arena}", string};
        this.getCurrentCommandIssuer().sendInfo(Messages.ARENA__CREATED, stringArray);
    }

    @Subcommand(value="arena set defender")
    @CommandPermission(value="guilds.command.admin")
    @Description(value="{@@descriptions.arena-defender}")
    @Syntax(value="%arena")
    @CommandCompletion(value="@arenas")
    public final void defender(@NotNull Player player, @Values(value="@arenas") @NotNull Arena arena) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)arena, (String)"arena");
        arena.setDefender(ACFBukkitUtil.fullLocationToString(player.getLocation()));
        String[] stringArray = new String[]{"{arena}", arena.getName()};
        this.getCurrentCommandIssuer().sendInfo(Messages.ARENA__DEFENDER_SET, stringArray);
    }

    @Subcommand(value="arena delete")
    @CommandPermission(value="guilds.command.admin")
    @Description(value="{@@descriptions.arena-delete}")
    @CommandCompletion(value="@arenas")
    @Syntax(value="%name")
    public final void delete(@NotNull Player player, @Values(value="@arenas") @NotNull Arena arena) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)arena, (String)"arena");
        String string = arena.getName();
        this.getArenaHandler().removeArena(arena);
        String[] stringArray = new String[]{"{arena}", string};
        this.getCurrentCommandIssuer().sendInfo(Messages.ARENA__DELETED, stringArray);
    }

    @Subcommand(value="arena list")
    @CommandPermission(value="guilds.command.admin")
    @Description(value="{@@descriptions.arena-list}")
    public final void list(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Collection<Arena> collection = this.getArenaHandler().getArenas();
        if (collection.isEmpty()) {
            throw new ExpectationNotMet(Messages.ARENA__LIST_EMPTY);
        }
        String[] stringArray = new String[]{"{arenas}", CollectionsKt.joinToString$default((Iterable)this.getArenaHandler().arenaNames(), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)};
        this.getCurrentCommandIssuer().sendInfo(Messages.ARENA__LIST, stringArray);
    }

    @Subcommand(value="arena tp")
    @CommandPermission(value="guilds.command.admin")
    @Description(value="{@@descriptions.arena-tp}")
    @Syntax(value="%arena %position")
    @CommandCompletion(value="@arenas @locations")
    public final void teleport(@NotNull Player player, @Values(value="@arenas") @NotNull Arena arena, @Values(value="@locations") @Single @NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)arena, (String)"arena");
        Intrinsics.checkNotNullParameter((Object)string, (String)"location");
        if (StringsKt.equals((String)string, (String)"challenger", (boolean)true)) {
            if (arena.getChallenger() == null) {
                throw new ExpectationNotMet(Messages.ARENA__POSITION_NOT_SET);
            }
            player.teleport(ACFBukkitUtil.stringToLocation(arena.getChallenger()));
        } else if (StringsKt.equals((String)string, (String)"defender", (boolean)true)) {
            if (arena.getDefender() == null) {
                throw new ExpectationNotMet(Messages.ARENA__POSITION_NOT_SET);
            }
            player.teleport(ACFBukkitUtil.stringToLocation(arena.getDefender()));
        }
        String[] stringArray = new String[]{"{team}", string, "{arena}", arena.getName()};
        this.getCurrentCommandIssuer().sendInfo(Messages.ARENA__TELEPORTED_TO_SELECTION, stringArray);
    }
}

