/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.commands.ally;

import java.util.List;
import java.util.UUID;
import me.glaremasters.guilds.Guilds;
import me.glaremasters.guilds.api.events.GuildAddAllyEvent;
import me.glaremasters.guilds.api.events.GuildRemoveAllyEvent;
import me.glaremasters.guilds.exceptions.ExpectationNotMet;
import me.glaremasters.guilds.guild.Guild;
import me.glaremasters.guilds.guild.GuildHandler;
import me.glaremasters.guilds.libs.commands.BaseCommand;
import me.glaremasters.guilds.libs.commands.CommandIssuer;
import me.glaremasters.guilds.libs.commands.annotation.CommandAlias;
import me.glaremasters.guilds.libs.commands.annotation.CommandCompletion;
import me.glaremasters.guilds.libs.commands.annotation.CommandPermission;
import me.glaremasters.guilds.libs.commands.annotation.Conditions;
import me.glaremasters.guilds.libs.commands.annotation.Dependency;
import me.glaremasters.guilds.libs.commands.annotation.Description;
import me.glaremasters.guilds.libs.commands.annotation.Flags;
import me.glaremasters.guilds.libs.commands.annotation.Subcommand;
import me.glaremasters.guilds.libs.commands.annotation.Syntax;
import me.glaremasters.guilds.libs.kotlin.Metadata;
import me.glaremasters.guilds.libs.kotlin.collections.CollectionsKt;
import me.glaremasters.guilds.libs.kotlin.jvm.functions.Function1;
import me.glaremasters.guilds.libs.kotlin.jvm.internal.Intrinsics;
import me.glaremasters.guilds.libs.locales.MessageKeyProvider;
import me.glaremasters.guilds.messages.Messages;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@CommandAlias(value="%guilds")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0001\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u0014H\u0007J$\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u0014H\u0007J$\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u0014H\u0007J\u0018\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J$\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u0014H\u0007R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lme/glaremasters/guilds/commands/ally/CommandAlly;", "Lme/glaremasters/guilds/libs/commands/BaseCommand;", "()V", "guildHandler", "Lme/glaremasters/guilds/guild/GuildHandler;", "getGuildHandler", "()Lme/glaremasters/guilds/guild/GuildHandler;", "setGuildHandler", "(Lme/glaremasters/guilds/guild/GuildHandler;)V", "guilds", "Lme/glaremasters/guilds/Guilds;", "getGuilds", "()Lme/glaremasters/guilds/Guilds;", "setGuilds", "(Lme/glaremasters/guilds/Guilds;)V", "accept", "", "player", "Lorg/bukkit/entity/Player;", "guild", "Lme/glaremasters/guilds/guild/Guild;", "target", "add", "decline", "list", "remove", "Guilds"})
public final class CommandAlly
extends BaseCommand {
    @Dependency
    public Guilds guilds;
    @Dependency
    public GuildHandler guildHandler;

    @NotNull
    public final Guilds getGuilds() {
        Guilds guilds = this.guilds;
        if (guilds != null) {
            return guilds;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"guilds");
        return null;
    }

    public final void setGuilds(@NotNull Guilds guilds) {
        Intrinsics.checkNotNullParameter((Object)((Object)guilds), (String)"<set-?>");
        this.guilds = guilds;
    }

    @NotNull
    public final GuildHandler getGuildHandler() {
        GuildHandler guildHandler = this.guildHandler;
        if (guildHandler != null) {
            return guildHandler;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"guildHandler");
        return null;
    }

    public final void setGuildHandler(@NotNull GuildHandler guildHandler) {
        Intrinsics.checkNotNullParameter((Object)guildHandler, (String)"<set-?>");
        this.guildHandler = guildHandler;
    }

    @Subcommand(value="ally accept")
    @Description(value="{@@descriptions.ally-accept}")
    @CommandPermission(value="guilds.command.ally.accept")
    @CommandCompletion(value="@allyInvites")
    @Syntax(value="%guild")
    public final void accept(@NotNull Player player, @Conditions(value="perm:perm=ADD_ALLY|NotMaxedAllies") @NotNull Guild guild, @Flags(value="other") @NotNull Guild guild2) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)guild, (String)"guild");
        Intrinsics.checkNotNullParameter((Object)guild2, (String)"target");
        if (!guild.isAllyPending(guild2)) {
            return;
        }
        guild.removePendingAlly(guild2);
        this.getGuildHandler().addAlly(guild, guild2);
        String[] stringArray = new String[]{"{guild}", guild2.getName()};
        guild.sendMessage(this.getCurrentCommandManager(), Messages.ALLY__CURRENT_ACCEPTED, stringArray);
        stringArray = new String[]{"{guild}", guild.getName()};
        guild2.sendMessage(this.getCurrentCommandManager(), Messages.ALLY__TARGET_ACCEPTED, stringArray);
    }

    @Subcommand(value="ally add")
    @Description(value="{@@descriptions.ally-add}")
    @CommandPermission(value="guilds.command.ally.add")
    @CommandCompletion(value="@guilds")
    @Syntax(value="%guild")
    public final void add(@NotNull Player player, @Conditions(value="perm:perm=ADD_ALLY|NotMaxedAllies") @NotNull Guild guild, @Flags(value="other") @NotNull Guild guild2) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)guild, (String)"guild");
        Intrinsics.checkNotNullParameter((Object)guild2, (String)"target");
        if (guild2.isAllyPending(guild)) {
            throw new ExpectationNotMet(Messages.ALLY__ALREADY_REQUESTED);
        }
        if (this.getGuildHandler().isAlly(guild, guild2)) {
            throw new ExpectationNotMet(Messages.ALLY__ALREADY_ALLY);
        }
        if (Intrinsics.areEqual((Object)guild, (Object)guild2)) {
            throw new ExpectationNotMet(Messages.ALLY__SAME_GUILD);
        }
        GuildAddAllyEvent guildAddAllyEvent = new GuildAddAllyEvent(player, guild, guild2);
        this.getGuilds().getServer().getPluginManager().callEvent((Event)guildAddAllyEvent);
        if (guildAddAllyEvent.isCancelled()) {
            return;
        }
        String[] stringArray = new String[]{"{guild}", guild2.getName()};
        this.getCurrentCommandIssuer().sendInfo(Messages.ALLY__INVITE_SENT, stringArray);
        stringArray = new String[]{"{guild}", guild.getName()};
        guild2.sendMessage(this.getCurrentCommandManager(), Messages.ALLY__INCOMING_INVITE, stringArray);
        guild2.addPendingAlly(guild);
    }

    @Subcommand(value="ally decline")
    @Description(value="{@@descriptions.ally-decline}")
    @CommandPermission(value="guilds.command.ally.decline")
    @CommandCompletion(value="@allyInvites")
    @Syntax(value="%guild")
    public final void decline(@NotNull Player player, @Conditions(value="perm:perm=REMOVE_ALLY") @NotNull Guild guild, @Flags(value="other") @NotNull Guild guild2) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)guild, (String)"guild");
        Intrinsics.checkNotNullParameter((Object)guild2, (String)"target");
        if (!guild.isAllyPending(guild2)) {
            return;
        }
        guild.removePendingAlly(guild2);
        String[] stringArray = new String[]{"{guild}", guild2.getName()};
        guild.sendMessage(this.getCurrentCommandManager(), Messages.ALLY__CURRENT_DECLINED, stringArray);
        stringArray = new String[]{"{guild}", guild.getName()};
        guild2.sendMessage(this.getCurrentCommandManager(), Messages.ALLY__TARGET_DECLINED, stringArray);
    }

    @Subcommand(value="ally remove")
    @Description(value="{@@descriptions.ally-remove}")
    @CommandPermission(value="guilds.command.ally.remove")
    @CommandCompletion(value="@allies")
    @Syntax(value="%guild")
    public final void remove(@NotNull Player player, @Conditions(value="perm:perm=REMOVE_ALLY") @NotNull Guild guild, @Flags(value="other") @NotNull Guild guild2) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)guild, (String)"guild");
        Intrinsics.checkNotNullParameter((Object)guild2, (String)"target");
        if (!this.getGuildHandler().isAlly(guild, guild2)) {
            throw new ExpectationNotMet(Messages.ALLY__NOT_ALLIED);
        }
        GuildRemoveAllyEvent guildRemoveAllyEvent = new GuildRemoveAllyEvent(player, guild, guild2);
        this.getGuilds().getServer().getPluginManager().callEvent((Event)guildRemoveAllyEvent);
        if (guildRemoveAllyEvent.isCancelled()) {
            return;
        }
        this.getGuildHandler().removeAlly(guild, guild2);
        String[] stringArray = new String[]{"{guild}", guild2.getName()};
        guild.sendMessage(this.getCurrentCommandManager(), Messages.ALLY__CURRENT_REMOVE, stringArray);
        stringArray = new String[]{"{guild}", guild.getName()};
        guild2.sendMessage(this.getCurrentCommandManager(), Messages.ALLY__TARGET_REMOVE, stringArray);
    }

    @Subcommand(value="ally list")
    @Description(value="{@@descriptions.ally-list}")
    @Syntax(value="")
    @CommandPermission(value="guilds.command.ally.list")
    public final void list(@NotNull Player player, @NotNull Guild guild) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)guild, (String)"guild");
        if (!guild.hasAllies()) {
            throw new ExpectationNotMet(Messages.ALLY__NONE);
        }
        CommandIssuer commandIssuer = this.getCurrentCommandIssuer();
        MessageKeyProvider messageKeyProvider = Messages.ALLY__LIST;
        String[] stringArray = new String[2];
        stringArray[0] = "{ally-list}";
        List<UUID> list2 = guild.getAllies();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"guild.allies");
        stringArray[1] = CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)", ", null, null, (int)0, null, (Function1)((Function1)new Function1<UUID, CharSequence>(this){
            final /* synthetic */ CommandAlly this$0;
            {
                this.this$0 = commandAlly;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(UUID uUID) {
                Guild guild = this.this$0.getGuildHandler().getGuild(uUID);
                String string = guild != null ? guild.getName() : null;
                Intrinsics.checkNotNull((Object)string);
                return string;
            }
        }), (int)30, null);
        commandIssuer.sendInfo(messageKeyProvider, stringArray);
    }
}

