/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.commands.bank;

import me.glaremasters.guilds.Guilds;
import me.glaremasters.guilds.api.events.GuildDepositMoneyEvent;
import me.glaremasters.guilds.api.events.GuildWithdrawMoneyEvent;
import me.glaremasters.guilds.exceptions.ExpectationNotMet;
import me.glaremasters.guilds.exte.FuncsKt;
import me.glaremasters.guilds.guild.Guild;
import me.glaremasters.guilds.guild.GuildHandler;
import me.glaremasters.guilds.guild.GuildTier;
import me.glaremasters.guilds.libs.commands.BaseCommand;
import me.glaremasters.guilds.libs.commands.annotation.CommandAlias;
import me.glaremasters.guilds.libs.commands.annotation.CommandPermission;
import me.glaremasters.guilds.libs.commands.annotation.Conditions;
import me.glaremasters.guilds.libs.commands.annotation.Dependency;
import me.glaremasters.guilds.libs.commands.annotation.Description;
import me.glaremasters.guilds.libs.commands.annotation.Subcommand;
import me.glaremasters.guilds.libs.commands.annotation.Syntax;
import me.glaremasters.guilds.libs.kotlin.Metadata;
import me.glaremasters.guilds.libs.kotlin.jvm.internal.Intrinsics;
import me.glaremasters.guilds.messages.Messages;
import me.glaremasters.guilds.utils.EconomyUtils;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@CommandAlias(value="%guilds")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\"\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0007J\"\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0007R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u00020\u00108\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001f"}, d2={"Lme/glaremasters/guilds/commands/bank/CommandBank;", "Lme/glaremasters/guilds/libs/commands/BaseCommand;", "()V", "economy", "Lnet/milkbowl/vault/economy/Economy;", "getEconomy", "()Lnet/milkbowl/vault/economy/Economy;", "setEconomy", "(Lnet/milkbowl/vault/economy/Economy;)V", "guildHandler", "Lme/glaremasters/guilds/guild/GuildHandler;", "getGuildHandler", "()Lme/glaremasters/guilds/guild/GuildHandler;", "setGuildHandler", "(Lme/glaremasters/guilds/guild/GuildHandler;)V", "guilds", "Lme/glaremasters/guilds/Guilds;", "getGuilds", "()Lme/glaremasters/guilds/Guilds;", "setGuilds", "(Lme/glaremasters/guilds/Guilds;)V", "balance", "", "player", "Lorg/bukkit/entity/Player;", "guild", "Lme/glaremasters/guilds/guild/Guild;", "deposit", "amount", "", "withdraw", "Guilds"})
public final class CommandBank
extends BaseCommand {
    @Dependency
    public Guilds guilds;
    @Dependency
    public GuildHandler guildHandler;
    @Dependency
    public Economy economy;

    @NotNull
    public final Guilds getGuilds() {
        Guilds guilds = this.guilds;
        if (guilds != null) {
            return guilds;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"guilds");
        return null;
    }

    public final void setGuilds(@NotNull Guilds guilds) {
        Intrinsics.checkNotNullParameter((Object)((Object)guilds), (String)"<set-?>");
        this.guilds = guilds;
    }

    @NotNull
    public final GuildHandler getGuildHandler() {
        GuildHandler guildHandler = this.guildHandler;
        if (guildHandler != null) {
            return guildHandler;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"guildHandler");
        return null;
    }

    public final void setGuildHandler(@NotNull GuildHandler guildHandler) {
        Intrinsics.checkNotNullParameter((Object)guildHandler, (String)"<set-?>");
        this.guildHandler = guildHandler;
    }

    @NotNull
    public final Economy getEconomy() {
        Economy economy = this.economy;
        if (economy != null) {
            return economy;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"economy");
        return null;
    }

    public final void setEconomy(@NotNull Economy economy) {
        Intrinsics.checkNotNullParameter((Object)economy, (String)"<set-?>");
        this.economy = economy;
    }

    @Subcommand(value="bank balance")
    @Description(value="{@@descriptions.bank-balance}")
    @Syntax(value="")
    @CommandPermission(value="guilds.command.bank.balance")
    public final void balance(@NotNull Player player, @NotNull Guild guild) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)guild, (String)"guild");
        String[] stringArray = new String[]{"{amount}", EconomyUtils.format(guild.getBalance())};
        this.getCurrentCommandIssuer().sendInfo(Messages.BANK__BALANCE, stringArray);
    }

    @Subcommand(value="bank deposit")
    @Description(value="{@@descriptions.bank-deposit}")
    @CommandPermission(value="guilds.command.bank.deposit")
    @Syntax(value="%amount")
    public final void deposit(@NotNull Player player, @Conditions(value="perm:perm=DEPOSIT_MONEY") @NotNull Guild guild, double d) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)guild, (String)"guild");
        if (Double.isNaN(d)) {
            throw new ExpectationNotMet(Messages.SYNTAX__AMOUNT);
        }
        double d2 = guild.getBalance();
        double d3 = FuncsKt.rounded(d);
        double d4 = d3 + d2;
        GuildTier guildTier = guild.getTier();
        if (d3 < 0.0) {
            throw new ExpectationNotMet(Messages.ERROR__NOT_ENOUGH_MONEY);
        }
        if (!EconomyUtils.hasEnough(this.getCurrentCommandManager(), this.getEconomy(), player, d3)) {
            throw new ExpectationNotMet(Messages.ERROR__NOT_ENOUGH_MONEY);
        }
        if (d4 > guildTier.getMaxBankBalance()) {
            throw new ExpectationNotMet(Messages.BANK__OVER_MAX);
        }
        GuildDepositMoneyEvent guildDepositMoneyEvent = new GuildDepositMoneyEvent(player, guild, d3);
        Bukkit.getPluginManager().callEvent((Event)guildDepositMoneyEvent);
        if (guildDepositMoneyEvent.isCancelled()) {
            return;
        }
        this.getEconomy().withdrawPlayer((OfflinePlayer)player, d3);
        guild.setBalance(d4);
        String[] stringArray = new String[]{"{player}", player.getName(), "{amount}", EconomyUtils.format(d3), "{total}", EconomyUtils.format(guild.getBalance())};
        guild.sendMessage(this.getCurrentCommandManager(), Messages.BANK__DEPOSIT_SUCCESS, stringArray);
    }

    @Subcommand(value="bank withdraw")
    @Description(value="{@@descriptions.bank-withdraw}")
    @CommandPermission(value="guilds.command.bank.withdraw")
    @Syntax(value="%amount")
    public final void withdraw(@NotNull Player player, @Conditions(value="perm:perm=WITHDRAW_MONEY") @NotNull Guild guild, double d) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)guild, (String)"guild");
        if (Double.isNaN(d)) {
            throw new ExpectationNotMet(Messages.SYNTAX__AMOUNT);
        }
        double d2 = guild.getBalance();
        double d3 = FuncsKt.rounded(d);
        if (d3 < 0.0) {
            throw new ExpectationNotMet(Messages.ERROR__NOT_ENOUGH_MONEY);
        }
        if (d2 < d3) {
            throw new ExpectationNotMet(Messages.BANK__NOT_ENOUGH_BANK);
        }
        GuildWithdrawMoneyEvent guildWithdrawMoneyEvent = new GuildWithdrawMoneyEvent(player, guild, d3);
        Bukkit.getPluginManager().callEvent((Event)guildWithdrawMoneyEvent);
        if (guildWithdrawMoneyEvent.isCancelled()) {
            return;
        }
        guild.setBalance(d2 - d3);
        this.getEconomy().depositPlayer((OfflinePlayer)player, d3);
        String[] stringArray = new String[]{"{player}", player.getName(), "{amount}", EconomyUtils.format(d3), "{total}", EconomyUtils.format(guild.getBalance())};
        guild.sendMessage(this.getCurrentCommandManager(), Messages.BANK__WITHDRAWAL_SUCCESS, stringArray);
    }
}

