/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.commands.codes;

import me.glaremasters.guilds.Guilds;
import me.glaremasters.guilds.configuration.sections.CodeSettings;
import me.glaremasters.guilds.exceptions.ExpectationNotMet;
import me.glaremasters.guilds.guild.Guild;
import me.glaremasters.guilds.guild.GuildCode;
import me.glaremasters.guilds.guild.GuildHandler;
import me.glaremasters.guilds.libs.commands.BaseCommand;
import me.glaremasters.guilds.libs.commands.annotation.CommandAlias;
import me.glaremasters.guilds.libs.commands.annotation.CommandCompletion;
import me.glaremasters.guilds.libs.commands.annotation.CommandPermission;
import me.glaremasters.guilds.libs.commands.annotation.Conditions;
import me.glaremasters.guilds.libs.commands.annotation.Default;
import me.glaremasters.guilds.libs.commands.annotation.Dependency;
import me.glaremasters.guilds.libs.commands.annotation.Description;
import me.glaremasters.guilds.libs.commands.annotation.Single;
import me.glaremasters.guilds.libs.commands.annotation.Subcommand;
import me.glaremasters.guilds.libs.commands.annotation.Syntax;
import me.glaremasters.guilds.libs.commands.annotation.Values;
import me.glaremasters.guilds.libs.configme.SettingsManager;
import me.glaremasters.guilds.libs.kotlin.Metadata;
import me.glaremasters.guilds.libs.kotlin.jvm.internal.Intrinsics;
import me.glaremasters.guilds.messages.Messages;
import me.glaremasters.guilds.utils.PlayerUtils;
import me.glaremasters.guilds.utils.StringUtils;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@CommandAlias(value="%guilds")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0001\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\b\b\u0001\u0010\u001b\u001a\u00020\u001cH\u0007J$\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\b\b\u0001\u0010\u001e\u001a\u00020\u001fH\u0007J$\u0010 \u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\b\b\u0001\u0010\u001e\u001a\u00020\u001fH\u0007J\u0018\u0010!\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\u001a\u0010\"\u001a\u00020\u00162\b\b\u0001\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001fH\u0007R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u00020\u00108\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006#"}, d2={"Lme/glaremasters/guilds/commands/codes/CommandCode;", "Lme/glaremasters/guilds/libs/commands/BaseCommand;", "()V", "guildHandler", "Lme/glaremasters/guilds/guild/GuildHandler;", "getGuildHandler", "()Lme/glaremasters/guilds/guild/GuildHandler;", "setGuildHandler", "(Lme/glaremasters/guilds/guild/GuildHandler;)V", "guilds", "Lme/glaremasters/guilds/Guilds;", "getGuilds", "()Lme/glaremasters/guilds/Guilds;", "setGuilds", "(Lme/glaremasters/guilds/Guilds;)V", "settingsManager", "Lme/glaremasters/guilds/libs/configme/SettingsManager;", "getSettingsManager", "()Lch/jalu/configme/SettingsManager;", "setSettingsManager", "(Lch/jalu/configme/SettingsManager;)V", "create", "", "player", "Lorg/bukkit/entity/Player;", "guild", "Lme/glaremasters/guilds/guild/Guild;", "uses", "", "delete", "code", "", "info", "list", "redeem", "Guilds"})
public final class CommandCode
extends BaseCommand {
    @Dependency
    public Guilds guilds;
    @Dependency
    public SettingsManager settingsManager;
    @Dependency
    public GuildHandler guildHandler;

    @NotNull
    public final Guilds getGuilds() {
        Guilds guilds = this.guilds;
        if (guilds != null) {
            return guilds;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"guilds");
        return null;
    }

    public final void setGuilds(@NotNull Guilds guilds) {
        Intrinsics.checkNotNullParameter((Object)((Object)guilds), (String)"<set-?>");
        this.guilds = guilds;
    }

    @NotNull
    public final SettingsManager getSettingsManager() {
        SettingsManager settingsManager = this.settingsManager;
        if (settingsManager != null) {
            return settingsManager;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"settingsManager");
        return null;
    }

    public final void setSettingsManager(@NotNull SettingsManager settingsManager) {
        Intrinsics.checkNotNullParameter((Object)settingsManager, (String)"<set-?>");
        this.settingsManager = settingsManager;
    }

    @NotNull
    public final GuildHandler getGuildHandler() {
        GuildHandler guildHandler = this.guildHandler;
        if (guildHandler != null) {
            return guildHandler;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"guildHandler");
        return null;
    }

    public final void setGuildHandler(@NotNull GuildHandler guildHandler) {
        Intrinsics.checkNotNullParameter((Object)guildHandler, (String)"<set-?>");
        this.guildHandler = guildHandler;
    }

    @Subcommand(value="code create")
    @Description(value="{@@descriptions.code-create}")
    @Syntax(value="%uses")
    @CommandPermission(value="guilds.command.code.create")
    public final void create(@NotNull Player player, @Conditions(value="perm:perm=CREATE_CODE") @NotNull Guild guild, @Default(value="1") int n) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)guild, (String)"guild");
        Integer n2 = this.getSettingsManager().getProperty(CodeSettings.ACTIVE_CODE_AMOUNT);
        Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"settingsManager.getPrope\u2026tings.ACTIVE_CODE_AMOUNT)");
        if (guild.getActiveCheck(((Number)n2).intValue())) {
            throw new ExpectationNotMet(Messages.CODES__MAX);
        }
        Integer n3 = this.getSettingsManager().getProperty(CodeSettings.CODE_LENGTH);
        Intrinsics.checkNotNullExpressionValue((Object)n3, (String)"settingsManager.getPrope\u2026CodeSettings.CODE_LENGTH)");
        String string = StringUtils.generateString(((Number)n3).intValue());
        guild.addCode(string, n, player);
        String[] stringArray = new String[]{"{code}", string, "{amount}", String.valueOf(n)};
        this.getCurrentCommandIssuer().sendInfo(Messages.CODES__CREATED, stringArray);
    }

    @Subcommand(value="code delete")
    @Description(value="{@@descriptions.code-delete}")
    @CommandPermission(value="guilds.command.code.delete")
    @Syntax(value="%code")
    @CommandCompletion(value="@activeCodes")
    public final void delete(@NotNull Player player, @Conditions(value="perm:perm=DELETE_CODE") @NotNull Guild guild, @Values(value="@activeCodes") @Single @NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)guild, (String)"guild");
        Intrinsics.checkNotNullParameter((Object)string, (String)"code");
        guild.removeCode(string);
        this.getCurrentCommandIssuer().sendInfo(Messages.CODES__DELETED, new String[0]);
    }

    @Subcommand(value="code info")
    @Description(value="{@@descriptions.code-info}")
    @CommandPermission(value="guilds.command.code.info")
    @Syntax(value="%code")
    @CommandCompletion(value="@activeCodes")
    public final void info(@NotNull Player player, @Conditions(value="perm:perm=SEE_CODE_REDEEMERS") @NotNull Guild guild, @Values(value="@activeCodes") @Single @NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)guild, (String)"guild");
        Intrinsics.checkNotNullParameter((Object)string, (String)"code");
        GuildCode guildCode = guild.getCode(string);
        if (guildCode == null) {
            throw new ExpectationNotMet(Messages.CODES__INVALID_CODE);
        }
        GuildCode guildCode2 = guildCode;
        String[] stringArray = new String[]{"{code}", guildCode2.getId(), "{amount}", String.valueOf(guildCode2.getUses()), "{creator}", PlayerUtils.getPlayer(guildCode2.getCreator()).getName(), "{redeemers}", guild.getRedeemers(string)};
        this.getCurrentCommandIssuer().sendInfo(Messages.CODES__INFO, stringArray);
    }

    @Subcommand(value="code list")
    @Description(value="{@@descriptions.code-list}")
    @CommandPermission(value="guilds.command.code.list")
    @Syntax(value="")
    public final void list(@NotNull Player player, @NotNull Guild guild) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)guild, (String)"guild");
        if (guild.getCodes().isEmpty()) {
            throw new ExpectationNotMet(Messages.CODES__EMPTY);
        }
        this.getCurrentCommandIssuer().sendInfo(Messages.CODES__LIST_HEADER, new String[0]);
        Boolean bl = this.getSettingsManager().getProperty(CodeSettings.LIST_INACTIVE_CODES);
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"settingsManager.getPrope\u2026ings.LIST_INACTIVE_CODES)");
        if (bl.booleanValue()) {
            this.getGuildHandler().handleCodeList(this.getGuilds().getCommandManager(), player, guild.getCodes());
        } else {
            this.getGuildHandler().handleCodeList(this.getGuilds().getCommandManager(), player, guild.getActiveCodes());
        }
    }

    @Subcommand(value="code redeem")
    @Description(value="{@@descriptions.code-redeem}")
    @CommandPermission(value="guilds.command.code.redeem")
    @Syntax(value="%code")
    public final void redeem(@Conditions(value="NoGuild") @NotNull Player player, @NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)string, (String)"code");
        Guild guild = this.getGuildHandler().getGuildByCode(string);
        if (guild == null) {
            throw new ExpectationNotMet(Messages.CODES__INVALID_CODE);
        }
        Guild guild2 = guild;
        if (this.getGuildHandler().checkIfFull(guild2)) {
            throw new ExpectationNotMet(Messages.ACCEPT__GUILD_FULL);
        }
        this.getGuildHandler().handleInvite(this.getGuilds().getCommandManager(), player, guild2, guild2.getCode(string));
    }
}

