/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.commands.console;

import java.io.IOException;
import me.glaremasters.guilds.Guilds;
import me.glaremasters.guilds.actions.ActionHandler;
import me.glaremasters.guilds.actions.ConfirmAction;
import me.glaremasters.guilds.arena.ArenaHandler;
import me.glaremasters.guilds.challenges.ChallengeHandler;
import me.glaremasters.guilds.commands.console.CommandConsole;
import me.glaremasters.guilds.cooldowns.CooldownHandler;
import me.glaremasters.guilds.database.DatabaseAdapter;
import me.glaremasters.guilds.database.DatabaseBackend;
import me.glaremasters.guilds.exceptions.ExpectationNotMet;
import me.glaremasters.guilds.guild.Guild;
import me.glaremasters.guilds.guild.GuildHandler;
import me.glaremasters.guilds.libs.commands.BaseCommand;
import me.glaremasters.guilds.libs.commands.CommandIssuer;
import me.glaremasters.guilds.libs.commands.annotation.CommandAlias;
import me.glaremasters.guilds.libs.commands.annotation.CommandCompletion;
import me.glaremasters.guilds.libs.commands.annotation.CommandPermission;
import me.glaremasters.guilds.libs.commands.annotation.Dependency;
import me.glaremasters.guilds.libs.commands.annotation.Description;
import me.glaremasters.guilds.libs.commands.annotation.Subcommand;
import me.glaremasters.guilds.libs.commands.annotation.Syntax;
import me.glaremasters.guilds.libs.commands.annotation.Values;
import me.glaremasters.guilds.libs.configme.SettingsManager;
import me.glaremasters.guilds.libs.kotlin.Metadata;
import me.glaremasters.guilds.libs.kotlin.Unit;
import me.glaremasters.guilds.libs.kotlin.jvm.internal.Intrinsics;
import me.glaremasters.guilds.messages.Messages;
import me.glaremasters.guilds.utils.BackupUtils;
import me.glaremasters.guilds.utils.ClaimUtils;
import org.bukkit.command.CommandSender;
import org.codemc.worldguardwrapper.WorldGuardWrapper;
import org.jetbrains.annotations.NotNull;

@CommandAlias(value="%guilds")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0007J\u001a\u00101\u001a\u00020.2\u0006\u0010/\u001a\u0002002\b\b\u0001\u00102\u001a\u000203H\u0007J\u0010\u00104\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0007R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u00020\u00108\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0015\u001a\u00020\u00168\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001e\u0010\u001b\u001a\u00020\u001c8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001e\u0010!\u001a\u00020\"8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001e\u0010'\u001a\u00020(8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,\u00a8\u00065"}, d2={"Lme/glaremasters/guilds/commands/console/CommandConsole;", "Lme/glaremasters/guilds/libs/commands/BaseCommand;", "()V", "actionHandler", "Lme/glaremasters/guilds/actions/ActionHandler;", "getActionHandler", "()Lme/glaremasters/guilds/actions/ActionHandler;", "setActionHandler", "(Lme/glaremasters/guilds/actions/ActionHandler;)V", "arenaHandler", "Lme/glaremasters/guilds/arena/ArenaHandler;", "getArenaHandler", "()Lme/glaremasters/guilds/arena/ArenaHandler;", "setArenaHandler", "(Lme/glaremasters/guilds/arena/ArenaHandler;)V", "challengeHandler", "Lme/glaremasters/guilds/challenges/ChallengeHandler;", "getChallengeHandler", "()Lme/glaremasters/guilds/challenges/ChallengeHandler;", "setChallengeHandler", "(Lme/glaremasters/guilds/challenges/ChallengeHandler;)V", "cooldownHandler", "Lme/glaremasters/guilds/cooldowns/CooldownHandler;", "getCooldownHandler", "()Lme/glaremasters/guilds/cooldowns/CooldownHandler;", "setCooldownHandler", "(Lme/glaremasters/guilds/cooldowns/CooldownHandler;)V", "guildHandler", "Lme/glaremasters/guilds/guild/GuildHandler;", "getGuildHandler", "()Lme/glaremasters/guilds/guild/GuildHandler;", "setGuildHandler", "(Lme/glaremasters/guilds/guild/GuildHandler;)V", "guilds", "Lme/glaremasters/guilds/Guilds;", "getGuilds", "()Lme/glaremasters/guilds/Guilds;", "setGuilds", "(Lme/glaremasters/guilds/Guilds;)V", "settingsManager", "Lme/glaremasters/guilds/libs/configme/SettingsManager;", "getSettingsManager", "()Lch/jalu/configme/SettingsManager;", "setSettingsManager", "(Lch/jalu/configme/SettingsManager;)V", "backup", "", "issuer", "Lme/glaremasters/guilds/libs/commands/CommandIssuer;", "migrate", "toBackend", "", "unclaim", "Guilds"})
public final class CommandConsole
extends BaseCommand {
    @Dependency
    public Guilds guilds;
    @Dependency
    public GuildHandler guildHandler;
    @Dependency
    public ActionHandler actionHandler;
    @Dependency
    public ArenaHandler arenaHandler;
    @Dependency
    public ChallengeHandler challengeHandler;
    @Dependency
    public CooldownHandler cooldownHandler;
    @Dependency
    public SettingsManager settingsManager;

    @NotNull
    public final Guilds getGuilds() {
        Guilds guilds = this.guilds;
        if (guilds != null) {
            return guilds;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"guilds");
        return null;
    }

    public final void setGuilds(@NotNull Guilds guilds) {
        Intrinsics.checkNotNullParameter((Object)((Object)guilds), (String)"<set-?>");
        this.guilds = guilds;
    }

    @NotNull
    public final GuildHandler getGuildHandler() {
        GuildHandler guildHandler = this.guildHandler;
        if (guildHandler != null) {
            return guildHandler;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"guildHandler");
        return null;
    }

    public final void setGuildHandler(@NotNull GuildHandler guildHandler) {
        Intrinsics.checkNotNullParameter((Object)guildHandler, (String)"<set-?>");
        this.guildHandler = guildHandler;
    }

    @NotNull
    public final ActionHandler getActionHandler() {
        ActionHandler actionHandler = this.actionHandler;
        if (actionHandler != null) {
            return actionHandler;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"actionHandler");
        return null;
    }

    public final void setActionHandler(@NotNull ActionHandler actionHandler) {
        Intrinsics.checkNotNullParameter((Object)actionHandler, (String)"<set-?>");
        this.actionHandler = actionHandler;
    }

    @NotNull
    public final ArenaHandler getArenaHandler() {
        ArenaHandler arenaHandler = this.arenaHandler;
        if (arenaHandler != null) {
            return arenaHandler;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"arenaHandler");
        return null;
    }

    public final void setArenaHandler(@NotNull ArenaHandler arenaHandler) {
        Intrinsics.checkNotNullParameter((Object)arenaHandler, (String)"<set-?>");
        this.arenaHandler = arenaHandler;
    }

    @NotNull
    public final ChallengeHandler getChallengeHandler() {
        ChallengeHandler challengeHandler = this.challengeHandler;
        if (challengeHandler != null) {
            return challengeHandler;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"challengeHandler");
        return null;
    }

    public final void setChallengeHandler(@NotNull ChallengeHandler challengeHandler) {
        Intrinsics.checkNotNullParameter((Object)challengeHandler, (String)"<set-?>");
        this.challengeHandler = challengeHandler;
    }

    @NotNull
    public final CooldownHandler getCooldownHandler() {
        CooldownHandler cooldownHandler = this.cooldownHandler;
        if (cooldownHandler != null) {
            return cooldownHandler;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"cooldownHandler");
        return null;
    }

    public final void setCooldownHandler(@NotNull CooldownHandler cooldownHandler) {
        Intrinsics.checkNotNullParameter((Object)cooldownHandler, (String)"<set-?>");
        this.cooldownHandler = cooldownHandler;
    }

    @NotNull
    public final SettingsManager getSettingsManager() {
        SettingsManager settingsManager = this.settingsManager;
        if (settingsManager != null) {
            return settingsManager;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"settingsManager");
        return null;
    }

    public final void setSettingsManager(@NotNull SettingsManager settingsManager) {
        Intrinsics.checkNotNullParameter((Object)settingsManager, (String)"<set-?>");
        this.settingsManager = settingsManager;
    }

    @Subcommand(value="console backup")
    @Description(value="{@@descriptions.console-backup}")
    @CommandPermission(value="guilds.command.admin")
    public final void backup(@NotNull CommandIssuer commandIssuer) {
        Intrinsics.checkNotNullParameter((Object)commandIssuer, (String)"issuer");
        if (commandIssuer.isPlayer()) {
            throw new ExpectationNotMet(Messages.ERROR__CONSOLE_COMMAND);
        }
        this.getCurrentCommandIssuer().sendInfo(Messages.BACKUP__WARNING, new String[0]);
        ActionHandler actionHandler = this.getActionHandler();
        Object t = commandIssuer.getIssuer();
        Intrinsics.checkNotNullExpressionValue(t, (String)"issuer.getIssuer()");
        actionHandler.addAction((CommandSender)t, new ConfirmAction(this, commandIssuer){
            final /* synthetic */ CommandConsole this$0;
            final /* synthetic */ CommandIssuer $issuer;
            {
                this.this$0 = commandConsole;
                this.$issuer = commandIssuer;
            }

            public void accept() {
                this.this$0.getGuilds().getCommandManager().getCommandIssuer(this.$issuer.getIssuer()).sendInfo(Messages.BACKUP__STARTED, new String[0]);
                Guilds.newChain().async(() -> backup.1.accept$lambda$0(this.this$0)).sync(arg_0 -> backup.1.accept$lambda$1(this.this$0, this.$issuer, arg_0)).execute();
                this.this$0.getActionHandler().removeAction((CommandSender)this.$issuer.getIssuer());
            }

            public void decline() {
                this.this$0.getActionHandler().removeAction((CommandSender)this.$issuer.getIssuer());
                this.this$0.getCurrentCommandIssuer().sendInfo(Messages.BACKUP__CANCELLED, new String[0]);
            }

            private static final void accept$lambda$0(CommandConsole commandConsole) {
                Intrinsics.checkNotNullParameter((Object)commandConsole, (String)"this$0");
                try {
                    BackupUtils.zipDir("guilds-backup-" + System.currentTimeMillis() + ".zip", commandConsole.getGuilds().getDataFolder().getPath());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }

            private static final Unit accept$lambda$1(CommandConsole commandConsole, CommandIssuer commandIssuer, Object object) {
                Intrinsics.checkNotNullParameter((Object)commandConsole, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)commandIssuer, (String)"$issuer");
                commandConsole.getGuilds().getCommandManager().getCommandIssuer(commandIssuer.getIssuer()).sendInfo(Messages.BACKUP__FINISHED, new String[0]);
                return Unit.INSTANCE;
            }
        });
    }

    @Subcommand(value="console migrate")
    @Description(value="{@@descriptions.console-migrate}")
    @CommandPermission(value="guilds.command.admin")
    @Syntax(value="%new-backend")
    @CommandCompletion(value="@sources")
    public final void migrate(@NotNull CommandIssuer commandIssuer, @Values(value="@sources") @NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)commandIssuer, (String)"issuer");
        Intrinsics.checkNotNullParameter((Object)string, (String)"toBackend");
        if (commandIssuer.isPlayer()) {
            throw new ExpectationNotMet(Messages.ERROR__CONSOLE_COMMAND);
        }
        this.getCurrentCommandIssuer().sendInfo(Messages.MIGRATE__WARNING, new String[0]);
        ActionHandler actionHandler = this.getActionHandler();
        Object t = commandIssuer.getIssuer();
        Intrinsics.checkNotNullExpressionValue(t, (String)"issuer.getIssuer()");
        actionHandler.addAction((CommandSender)t, new ConfirmAction(string, this, commandIssuer){
            final /* synthetic */ String $toBackend;
            final /* synthetic */ CommandConsole this$0;
            final /* synthetic */ CommandIssuer $issuer;
            {
                this.$toBackend = string;
                this.this$0 = commandConsole;
                this.$issuer = commandIssuer;
            }

            public void accept() {
                DatabaseBackend databaseBackend = DatabaseBackend.getByBackendName(this.$toBackend);
                if (databaseBackend == null) {
                    throw new ExpectationNotMet(Messages.MIGRATE__INVALID_BACKEND);
                }
                DatabaseBackend databaseBackend2 = databaseBackend;
                Guilds.newChain().async(() -> migrate.1.accept$lambda$0(this.this$0, databaseBackend2)).sync(arg_0 -> migrate.1.accept$lambda$1(this.this$0, this.$issuer, arg_0)).execute();
            }

            public void decline() {
                this.this$0.getCurrentCommandIssuer().sendInfo(Messages.MIGRATE__CANCELLED, new String[0]);
                this.this$0.getActionHandler().removeAction((CommandSender)this.$issuer.getIssuer());
            }

            private static final void accept$lambda$0(CommandConsole commandConsole, DatabaseBackend databaseBackend) {
                Intrinsics.checkNotNullParameter((Object)commandConsole, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)((Object)databaseBackend), (String)"$resolvedBackend");
                try {
                    commandConsole.getGuildHandler().setMigrating(true);
                    DatabaseAdapter databaseAdapter = commandConsole.getGuilds().getDatabase().cloneWith(databaseBackend);
                    if (!databaseAdapter.isConnected()) {
                        commandConsole.getGuildHandler().setMigrating(false);
                        throw new ExpectationNotMet(Messages.MIGRATE__CONNECTION_FAILED);
                    }
                    databaseAdapter.getGuildAdapter().saveGuilds(commandConsole.getGuildHandler().getGuilds().values());
                    databaseAdapter.getArenaAdapter().saveArenas(commandConsole.getArenaHandler().getArenas());
                    databaseAdapter.getCooldownAdapter().saveCooldowns(commandConsole.getCooldownHandler().getCooldowns().values());
                    databaseAdapter.getChallengeAdapter().saveChallenges(commandConsole.getChallengeHandler().getChallenges());
                    DatabaseAdapter databaseAdapter2 = commandConsole.getGuilds().getDatabase();
                    commandConsole.getGuilds().setDatabase(databaseAdapter);
                    databaseAdapter2.close();
                    commandConsole.getGuildHandler().setMigrating(false);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    commandConsole.getGuildHandler().setMigrating(false);
                    throw new ExpectationNotMet(Messages.MIGRATE__SAME_BACKEND);
                }
                catch (IOException iOException) {
                    commandConsole.getGuildHandler().setMigrating(false);
                    iOException.printStackTrace();
                }
            }

            private static final Unit accept$lambda$1(CommandConsole commandConsole, CommandIssuer commandIssuer, Object object) {
                Intrinsics.checkNotNullParameter((Object)commandConsole, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)commandIssuer, (String)"$issuer");
                String[] stringArray = new String[]{"{amount}", String.valueOf(commandConsole.getGuildHandler().getGuildsSize())};
                commandConsole.getGuilds().getCommandManager().getCommandIssuer(commandIssuer.getIssuer()).sendInfo(Messages.MIGRATE__COMPLETE, stringArray);
                commandConsole.getActionHandler().removeAction((CommandSender)commandIssuer.getIssuer());
                return Unit.INSTANCE;
            }
        });
    }

    @Subcommand(value="console unclaimall")
    @Description(value="{@@descriptions.console-unclaim-all}")
    @CommandPermission(value="guilds.command.admin")
    public final void unclaim(@NotNull CommandIssuer commandIssuer) {
        Intrinsics.checkNotNullParameter((Object)commandIssuer, (String)"issuer");
        if (commandIssuer.isPlayer()) {
            throw new ExpectationNotMet(Messages.ERROR__CONSOLE_COMMAND);
        }
        if (!ClaimUtils.isEnabled(this.getSettingsManager())) {
            throw new ExpectationNotMet(Messages.CLAIM__HOOK_DISABLED);
        }
        this.getCurrentCommandIssuer().sendInfo(Messages.UNCLAIM__ALL_WARNING, new String[0]);
        ActionHandler actionHandler = this.getActionHandler();
        Object t = commandIssuer.getIssuer();
        Intrinsics.checkNotNullExpressionValue(t, (String)"issuer.getIssuer()");
        actionHandler.addAction((CommandSender)t, new ConfirmAction(this, commandIssuer){
            final /* synthetic */ CommandConsole this$0;
            final /* synthetic */ CommandIssuer $issuer;
            {
                this.this$0 = commandConsole;
                this.$issuer = commandIssuer;
            }

            public void accept() {
                WorldGuardWrapper worldGuardWrapper = WorldGuardWrapper.getInstance();
                Iterable iterable = this.this$0.getGuildHandler().getGuilds().values();
                boolean bl = false;
                for (T t : iterable) {
                    Guild guild = (Guild)t;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)worldGuardWrapper, (String)"wrapper");
                    Intrinsics.checkNotNullExpressionValue((Object)guild, (String)"guild");
                    if (!ClaimUtils.checkAlreadyExist(worldGuardWrapper, guild)) continue;
                    ClaimUtils.removeClaim(worldGuardWrapper, guild);
                }
                this.this$0.getCurrentCommandIssuer().sendInfo(Messages.UNCLAIM__ALL_SUCCESS, new String[0]);
            }

            public void decline() {
                this.this$0.getCurrentCommandIssuer().sendInfo(Messages.UNCLAIM__ALL_CANCELLED, new String[0]);
                this.this$0.getActionHandler().removeAction((CommandSender)this.$issuer.getIssuer());
            }
        });
    }
}

