/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.commands.management;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import me.glaremasters.guilds.Guilds;
import me.glaremasters.guilds.actions.ActionHandler;
import me.glaremasters.guilds.actions.ConfirmAction;
import me.glaremasters.guilds.api.events.GuildCreateEvent;
import me.glaremasters.guilds.configuration.sections.CostSettings;
import me.glaremasters.guilds.configuration.sections.GuildSettings;
import me.glaremasters.guilds.cooldowns.Cooldown;
import me.glaremasters.guilds.cooldowns.CooldownHandler;
import me.glaremasters.guilds.exceptions.ExpectationNotMet;
import me.glaremasters.guilds.guild.Guild;
import me.glaremasters.guilds.guild.GuildCode;
import me.glaremasters.guilds.guild.GuildHandler;
import me.glaremasters.guilds.guild.GuildMember;
import me.glaremasters.guilds.guild.GuildRole;
import me.glaremasters.guilds.libs.commands.BaseCommand;
import me.glaremasters.guilds.libs.commands.CommandManager;
import me.glaremasters.guilds.libs.commands.annotation.CommandAlias;
import me.glaremasters.guilds.libs.commands.annotation.CommandPermission;
import me.glaremasters.guilds.libs.commands.annotation.Conditions;
import me.glaremasters.guilds.libs.commands.annotation.Dependency;
import me.glaremasters.guilds.libs.commands.annotation.Description;
import me.glaremasters.guilds.libs.commands.annotation.Optional;
import me.glaremasters.guilds.libs.commands.annotation.Subcommand;
import me.glaremasters.guilds.libs.commands.annotation.Syntax;
import me.glaremasters.guilds.libs.configme.SettingsManager;
import me.glaremasters.guilds.libs.kotlin.Metadata;
import me.glaremasters.guilds.libs.kotlin.jvm.internal.Intrinsics;
import me.glaremasters.guilds.libs.locales.MessageKeyProvider;
import me.glaremasters.guilds.messages.Messages;
import me.glaremasters.guilds.utils.EconomyUtils;
import me.glaremasters.guilds.utils.StringUtils;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CommandAlias(value="%guilds")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010-\u001a\u00020.2\b\b\u0001\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\n\b\u0001\u00103\u001a\u0004\u0018\u000102H\u0007R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u00020\u00108\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0015\u001a\u00020\u00168\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001e\u0010\u001b\u001a\u00020\u001c8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001e\u0010!\u001a\u00020\"8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001e\u0010'\u001a\u00020(8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,\u00a8\u00064"}, d2={"Lme/glaremasters/guilds/commands/management/CommandCreate;", "Lme/glaremasters/guilds/libs/commands/BaseCommand;", "()V", "actionHandler", "Lme/glaremasters/guilds/actions/ActionHandler;", "getActionHandler", "()Lme/glaremasters/guilds/actions/ActionHandler;", "setActionHandler", "(Lme/glaremasters/guilds/actions/ActionHandler;)V", "cooldownHandler", "Lme/glaremasters/guilds/cooldowns/CooldownHandler;", "getCooldownHandler", "()Lme/glaremasters/guilds/cooldowns/CooldownHandler;", "setCooldownHandler", "(Lme/glaremasters/guilds/cooldowns/CooldownHandler;)V", "economy", "Lnet/milkbowl/vault/economy/Economy;", "getEconomy", "()Lnet/milkbowl/vault/economy/Economy;", "setEconomy", "(Lnet/milkbowl/vault/economy/Economy;)V", "guildHandler", "Lme/glaremasters/guilds/guild/GuildHandler;", "getGuildHandler", "()Lme/glaremasters/guilds/guild/GuildHandler;", "setGuildHandler", "(Lme/glaremasters/guilds/guild/GuildHandler;)V", "guilds", "Lme/glaremasters/guilds/Guilds;", "getGuilds", "()Lme/glaremasters/guilds/Guilds;", "setGuilds", "(Lme/glaremasters/guilds/Guilds;)V", "permission", "Lnet/milkbowl/vault/permission/Permission;", "getPermission", "()Lnet/milkbowl/vault/permission/Permission;", "setPermission", "(Lnet/milkbowl/vault/permission/Permission;)V", "settingsManager", "Lme/glaremasters/guilds/libs/configme/SettingsManager;", "getSettingsManager", "()Lch/jalu/configme/SettingsManager;", "setSettingsManager", "(Lch/jalu/configme/SettingsManager;)V", "create", "", "player", "Lorg/bukkit/entity/Player;", "name", "", "prefix", "Guilds"})
public final class CommandCreate
extends BaseCommand {
    @Dependency
    public Guilds guilds;
    @Dependency
    public GuildHandler guildHandler;
    @Dependency
    public SettingsManager settingsManager;
    @Dependency
    public ActionHandler actionHandler;
    @Dependency
    public Economy economy;
    @Dependency
    public Permission permission;
    @Dependency
    public CooldownHandler cooldownHandler;

    @NotNull
    public final Guilds getGuilds() {
        Guilds guilds = this.guilds;
        if (guilds != null) {
            return guilds;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"guilds");
        return null;
    }

    public final void setGuilds(@NotNull Guilds guilds) {
        Intrinsics.checkNotNullParameter((Object)((Object)guilds), (String)"<set-?>");
        this.guilds = guilds;
    }

    @NotNull
    public final GuildHandler getGuildHandler() {
        GuildHandler guildHandler = this.guildHandler;
        if (guildHandler != null) {
            return guildHandler;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"guildHandler");
        return null;
    }

    public final void setGuildHandler(@NotNull GuildHandler guildHandler) {
        Intrinsics.checkNotNullParameter((Object)guildHandler, (String)"<set-?>");
        this.guildHandler = guildHandler;
    }

    @NotNull
    public final SettingsManager getSettingsManager() {
        SettingsManager settingsManager = this.settingsManager;
        if (settingsManager != null) {
            return settingsManager;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"settingsManager");
        return null;
    }

    public final void setSettingsManager(@NotNull SettingsManager settingsManager) {
        Intrinsics.checkNotNullParameter((Object)settingsManager, (String)"<set-?>");
        this.settingsManager = settingsManager;
    }

    @NotNull
    public final ActionHandler getActionHandler() {
        ActionHandler actionHandler = this.actionHandler;
        if (actionHandler != null) {
            return actionHandler;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"actionHandler");
        return null;
    }

    public final void setActionHandler(@NotNull ActionHandler actionHandler) {
        Intrinsics.checkNotNullParameter((Object)actionHandler, (String)"<set-?>");
        this.actionHandler = actionHandler;
    }

    @NotNull
    public final Economy getEconomy() {
        Economy economy = this.economy;
        if (economy != null) {
            return economy;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"economy");
        return null;
    }

    public final void setEconomy(@NotNull Economy economy) {
        Intrinsics.checkNotNullParameter((Object)economy, (String)"<set-?>");
        this.economy = economy;
    }

    @NotNull
    public final Permission getPermission() {
        Permission permission = this.permission;
        if (permission != null) {
            return permission;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"permission");
        return null;
    }

    public final void setPermission(@NotNull Permission permission) {
        Intrinsics.checkNotNullParameter((Object)permission, (String)"<set-?>");
        this.permission = permission;
    }

    @NotNull
    public final CooldownHandler getCooldownHandler() {
        CooldownHandler cooldownHandler = this.cooldownHandler;
        if (cooldownHandler != null) {
            return cooldownHandler;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"cooldownHandler");
        return null;
    }

    public final void setCooldownHandler(@NotNull CooldownHandler cooldownHandler) {
        Intrinsics.checkNotNullParameter((Object)cooldownHandler, (String)"<set-?>");
        this.cooldownHandler = cooldownHandler;
    }

    @Subcommand(value="create")
    @Description(value="{@@descriptions.create}")
    @CommandPermission(value="guilds.command.create")
    @Syntax(value="%name %optional %prefix")
    @Conditions(value="NotMigrating")
    public final void create(@Conditions(value="NoGuild") @NotNull Player player, @NotNull String string, @Optional @Nullable String string2) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)string, (String)"name");
        String string3 = Cooldown.Type.Join.name();
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"player.uniqueId");
        UUID uUID2 = uUID;
        if (this.getCooldownHandler().hasCooldown(string3, uUID2)) {
            String[] stringArray = new String[]{"{amount}", String.valueOf(this.getCooldownHandler().getRemaining(string3, uUID2))};
            throw new ExpectationNotMet((MessageKeyProvider)Messages.ACCEPT__COOLDOWN, stringArray);
        }
        Double d = this.getSettingsManager().getProperty(CostSettings.CREATION);
        if (this.getGuildHandler().checkGuildNames(string)) {
            throw new ExpectationNotMet(Messages.CREATE__GUILD_NAME_TAKEN);
        }
        Boolean bl = this.getSettingsManager().getProperty(GuildSettings.BLACKLIST_TOGGLE);
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"settingsManager.getPrope\u2026ettings.BLACKLIST_TOGGLE)");
        if (bl.booleanValue() && this.getGuildHandler().blacklistCheck(string, this.getSettingsManager())) {
            throw new ExpectationNotMet(Messages.ERROR__BLACKLIST);
        }
        if (!this.getGuildHandler().nameCheck(string, this.getSettingsManager())) {
            throw new ExpectationNotMet(Messages.CREATE__REQUIREMENTS);
        }
        if (!this.getSettingsManager().getProperty(GuildSettings.DISABLE_PREFIX).booleanValue()) {
            if (string2 != null) {
                if (!this.getGuildHandler().prefixCheck(string2, this.getSettingsManager())) {
                    throw new ExpectationNotMet(Messages.CREATE__PREFIX_TOO_LONG);
                }
            } else if (!this.getGuildHandler().prefixCheck(string, this.getSettingsManager())) {
                throw new ExpectationNotMet(Messages.CREATE__NAME_TOO_LONG);
            }
        }
        CommandManager commandManager = this.getCurrentCommandManager();
        Economy economy = this.getEconomy();
        Intrinsics.checkNotNullExpressionValue((Object)d, (String)"cost");
        if (!EconomyUtils.hasEnough(commandManager, economy, player, d)) {
            throw new ExpectationNotMet(Messages.ERROR__NOT_ENOUGH_MONEY);
        }
        String[] stringArray = new String[]{"{amount}", EconomyUtils.format(d)};
        this.getCurrentCommandIssuer().sendInfo(Messages.CREATE__WARNING, stringArray);
        this.getActionHandler().addAction((CommandSender)player, new ConfirmAction(this, player, d, string, string2, uUID2){
            final /* synthetic */ CommandCreate this$0;
            final /* synthetic */ Player $player;
            final /* synthetic */ Double $cost;
            final /* synthetic */ String $name;
            final /* synthetic */ String $prefix;
            final /* synthetic */ UUID $id;
            {
                this.this$0 = commandCreate;
                this.$player = player;
                this.$cost = d;
                this.$name = string;
                this.$prefix = string2;
                this.$id = uUID;
            }

            public void accept() {
                CommandManager commandManager = this.this$0.getCurrentCommandManager();
                Economy economy = this.this$0.getEconomy();
                Double d = this.$cost;
                Intrinsics.checkNotNullExpressionValue((Object)d, (String)"cost");
                if (!EconomyUtils.hasEnough(commandManager, economy, this.$player, ((Number)d).doubleValue())) {
                    throw new ExpectationNotMet(Messages.ERROR__NOT_ENOUGH_MONEY);
                }
                Guild.GuildBuilder guildBuilder = Guild.builder();
                guildBuilder.id(UUID.randomUUID());
                guildBuilder.name(StringUtils.color(this.$name));
                if (!this.this$0.getSettingsManager().getProperty(GuildSettings.DISABLE_PREFIX).booleanValue()) {
                    if (this.$prefix == null) {
                        guildBuilder.prefix(StringUtils.color(this.$name));
                    } else {
                        guildBuilder.prefix(StringUtils.color(this.$prefix));
                    }
                } else {
                    guildBuilder.prefix("");
                }
                guildBuilder.status(Guild.Status.Private);
                GuildRole guildRole = this.this$0.getGuildHandler().getGuildRole(0);
                Intrinsics.checkNotNull((Object)guildRole);
                GuildMember guildMember = new GuildMember(this.$id, guildRole);
                guildMember.setJoinDate(System.currentTimeMillis());
                guildBuilder.guildMaster(guildMember);
                List list2 = new ArrayList<E>();
                list2.add(guildMember);
                guildBuilder.members(list2);
                guildBuilder.home(null);
                guildBuilder.balance(0.0);
                guildBuilder.tier(this.this$0.getGuildHandler().getGuildTier(1));
                guildBuilder.invitedMembers((List<UUID>)new ArrayList<E>());
                guildBuilder.allies((List<UUID>)new ArrayList<E>());
                guildBuilder.pendingAllies((List<UUID>)new ArrayList<E>());
                guildBuilder.vaults((List<String>)new ArrayList<E>());
                guildBuilder.codes((List<GuildCode>)new ArrayList<E>());
                Guild guild = guildBuilder.build();
                guild.setCreationDate(System.currentTimeMillis());
                Intrinsics.checkNotNullExpressionValue((Object)guild, (String)"guild");
                GuildCreateEvent guildCreateEvent = new GuildCreateEvent(this.$player, guild);
                Bukkit.getPluginManager().callEvent((Event)guildCreateEvent);
                if (guildCreateEvent.isCancelled()) {
                    return;
                }
                this.this$0.getGuildHandler().addGuild(guild);
                Economy economy2 = this.this$0.getEconomy();
                OfflinePlayer offlinePlayer = (OfflinePlayer)this.$player;
                Double d2 = this.$cost;
                Intrinsics.checkNotNullExpressionValue((Object)d2, (String)"cost");
                economy2.withdrawPlayer(offlinePlayer, ((Number)d2).doubleValue());
                String[] stringArray = new String[]{"{guild}", guild.getName()};
                this.this$0.getCurrentCommandIssuer().sendInfo(Messages.CREATE__SUCCESSFUL, stringArray);
                this.this$0.getGuildHandler().addGuildPerms(this.this$0.getPermission(), (OfflinePlayer)this.$player);
                this.this$0.getGuildHandler().addRolePerm(this.this$0.getPermission(), (OfflinePlayer)this.$player);
                guild.updateGuildSkull(this.$player, this.this$0.getSettingsManager());
                this.this$0.getGuildHandler().addToMemberCache(this.$player.getUniqueId(), guild.getId());
                this.this$0.getActionHandler().removeAction((CommandSender)this.$player);
            }

            public void decline() {
                this.this$0.getCurrentCommandIssuer().sendInfo(Messages.CREATE__CANCELLED, new String[0]);
                this.this$0.getActionHandler().removeAction((CommandSender)this.$player);
            }
        });
    }
}

