/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.commands.management;

import me.glaremasters.guilds.Guilds;
import me.glaremasters.guilds.api.events.GuildRenameEvent;
import me.glaremasters.guilds.configuration.sections.CostSettings;
import me.glaremasters.guilds.configuration.sections.GuildSettings;
import me.glaremasters.guilds.exceptions.ExpectationNotMet;
import me.glaremasters.guilds.guild.Guild;
import me.glaremasters.guilds.guild.GuildHandler;
import me.glaremasters.guilds.libs.commands.BaseCommand;
import me.glaremasters.guilds.libs.commands.annotation.CommandAlias;
import me.glaremasters.guilds.libs.commands.annotation.CommandPermission;
import me.glaremasters.guilds.libs.commands.annotation.Conditions;
import me.glaremasters.guilds.libs.commands.annotation.Dependency;
import me.glaremasters.guilds.libs.commands.annotation.Description;
import me.glaremasters.guilds.libs.commands.annotation.Subcommand;
import me.glaremasters.guilds.libs.commands.annotation.Syntax;
import me.glaremasters.guilds.libs.configme.SettingsManager;
import me.glaremasters.guilds.libs.kotlin.Metadata;
import me.glaremasters.guilds.libs.kotlin.Unit;
import me.glaremasters.guilds.libs.kotlin.jvm.functions.Function1;
import me.glaremasters.guilds.libs.kotlin.jvm.internal.Intrinsics;
import me.glaremasters.guilds.messages.Messages;
import me.glaremasters.guilds.utils.ClaimUtils;
import me.glaremasters.guilds.utils.EconomyUtils;
import me.glaremasters.guilds.utils.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.codemc.worldguardwrapper.WorldGuardWrapper;
import org.codemc.worldguardwrapper.region.IWrappedRegion;
import org.jetbrains.annotations.NotNull;

@CommandAlias(value="%guilds")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0007R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u00020\u00108\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001d"}, d2={"Lme/glaremasters/guilds/commands/management/CommandRename;", "Lme/glaremasters/guilds/libs/commands/BaseCommand;", "()V", "guildHandler", "Lme/glaremasters/guilds/guild/GuildHandler;", "getGuildHandler", "()Lme/glaremasters/guilds/guild/GuildHandler;", "setGuildHandler", "(Lme/glaremasters/guilds/guild/GuildHandler;)V", "guilds", "Lme/glaremasters/guilds/Guilds;", "getGuilds", "()Lme/glaremasters/guilds/Guilds;", "setGuilds", "(Lme/glaremasters/guilds/Guilds;)V", "settingsManager", "Lme/glaremasters/guilds/libs/configme/SettingsManager;", "getSettingsManager", "()Lch/jalu/configme/SettingsManager;", "setSettingsManager", "(Lch/jalu/configme/SettingsManager;)V", "rename", "", "player", "Lorg/bukkit/entity/Player;", "guild", "Lme/glaremasters/guilds/guild/Guild;", "name", "", "Guilds"})
public final class CommandRename
extends BaseCommand {
    @Dependency
    public Guilds guilds;
    @Dependency
    public GuildHandler guildHandler;
    @Dependency
    public SettingsManager settingsManager;

    @NotNull
    public final Guilds getGuilds() {
        Guilds guilds = this.guilds;
        if (guilds != null) {
            return guilds;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"guilds");
        return null;
    }

    public final void setGuilds(@NotNull Guilds guilds) {
        Intrinsics.checkNotNullParameter((Object)((Object)guilds), (String)"<set-?>");
        this.guilds = guilds;
    }

    @NotNull
    public final GuildHandler getGuildHandler() {
        GuildHandler guildHandler = this.guildHandler;
        if (guildHandler != null) {
            return guildHandler;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"guildHandler");
        return null;
    }

    public final void setGuildHandler(@NotNull GuildHandler guildHandler) {
        Intrinsics.checkNotNullParameter((Object)guildHandler, (String)"<set-?>");
        this.guildHandler = guildHandler;
    }

    @NotNull
    public final SettingsManager getSettingsManager() {
        SettingsManager settingsManager = this.settingsManager;
        if (settingsManager != null) {
            return settingsManager;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"settingsManager");
        return null;
    }

    public final void setSettingsManager(@NotNull SettingsManager settingsManager) {
        Intrinsics.checkNotNullParameter((Object)settingsManager, (String)"<set-?>");
        this.settingsManager = settingsManager;
    }

    @Subcommand(value="rename")
    @Description(value="{@@descriptions.rename}")
    @CommandPermission(value="guilds.command.rename")
    @Syntax(value="%name")
    public final void rename(@NotNull Player player, @Conditions(value="perm:perm=RENAME") @NotNull Guild guild, @NotNull String string) {
        String[] stringArray;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)guild, (String)"guild");
        Intrinsics.checkNotNullParameter((Object)string, (String)"name");
        if (this.getGuildHandler().checkGuildNames(string)) {
            throw new ExpectationNotMet(Messages.CREATE__GUILD_NAME_TAKEN);
        }
        if (!this.getGuildHandler().nameCheck(string, this.getSettingsManager())) {
            throw new ExpectationNotMet(Messages.CREATE__REQUIREMENTS);
        }
        Boolean bl2 = this.getSettingsManager().getProperty(GuildSettings.BLACKLIST_TOGGLE);
        Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"settingsManager.getPrope\u2026ettings.BLACKLIST_TOGGLE)");
        if (bl2.booleanValue() && this.getGuildHandler().blacklistCheck(string, this.getSettingsManager())) {
            throw new ExpectationNotMet(Messages.ERROR__BLACKLIST);
        }
        Double d = this.getSettingsManager().getProperty(CostSettings.RENAME);
        boolean bl3 = bl = !Intrinsics.areEqual((Double)d, (double)0.0);
        if (bl) {
            double d2 = guild.getBalance();
            Intrinsics.checkNotNullExpressionValue((Object)d, (String)"renameCost");
            if (!EconomyUtils.hasEnough(d2, d)) {
                throw new ExpectationNotMet(Messages.BANK__NOT_ENOUGH_BANK);
            }
        }
        GuildRenameEvent guildRenameEvent = new GuildRenameEvent(player, guild, string);
        Bukkit.getPluginManager().callEvent((Event)guildRenameEvent);
        if (guildRenameEvent.isCancelled()) {
            return;
        }
        double d3 = guild.getBalance();
        Intrinsics.checkNotNullExpressionValue((Object)d, (String)"renameCost");
        guild.setBalance(d3 - d);
        guild.setName(StringUtils.color(string));
        if (ClaimUtils.isEnabled(this.getSettingsManager())) {
            stringArray = WorldGuardWrapper.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"wrapper");
            if (ClaimUtils.checkAlreadyExist((WorldGuardWrapper)stringArray, guild)) {
                ClaimUtils.getGuildClaim((WorldGuardWrapper)stringArray, player, guild).ifPresent(arg_0 -> CommandRename.rename$lambda$0((Function1)new Function1<IWrappedRegion, Unit>((WorldGuardWrapper)stringArray, this, guild){
                    final /* synthetic */ WorldGuardWrapper $wrapper;
                    final /* synthetic */ CommandRename this$0;
                    final /* synthetic */ Guild $guild;
                    {
                        this.$wrapper = worldGuardWrapper;
                        this.this$0 = commandRename;
                        this.$guild = guild;
                        super(1);
                    }

                    public final void invoke(@NotNull IWrappedRegion iWrappedRegion) {
                        Intrinsics.checkNotNullParameter((Object)iWrappedRegion, (String)"region");
                        WorldGuardWrapper worldGuardWrapper = this.$wrapper;
                        Intrinsics.checkNotNullExpressionValue((Object)worldGuardWrapper, (String)"wrapper");
                        ClaimUtils.setEnterMessage(worldGuardWrapper, iWrappedRegion, this.this$0.getSettingsManager(), this.$guild);
                        WorldGuardWrapper worldGuardWrapper2 = this.$wrapper;
                        Intrinsics.checkNotNullExpressionValue((Object)worldGuardWrapper2, (String)"wrapper");
                        ClaimUtils.setExitMessage(worldGuardWrapper2, iWrappedRegion, this.this$0.getSettingsManager(), this.$guild);
                    }
                }, arg_0));
            }
        }
        stringArray = new String[]{"{name}", string};
        this.getCurrentCommandIssuer().sendInfo(Messages.RENAME__SUCCESSFUL, stringArray);
    }

    private static final void rename$lambda$0(Function1 function1, Object object) {
        Intrinsics.checkNotNullParameter((Object)function1, (String)"$tmp0");
        function1.invoke(object);
    }
}

