/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.commands.member;

import me.glaremasters.guilds.Guilds;
import me.glaremasters.guilds.exceptions.ExpectationNotMet;
import me.glaremasters.guilds.guild.Guild;
import me.glaremasters.guilds.guild.GuildHandler;
import me.glaremasters.guilds.guild.GuildMember;
import me.glaremasters.guilds.libs.commands.BaseCommand;
import me.glaremasters.guilds.libs.commands.annotation.CommandAlias;
import me.glaremasters.guilds.libs.commands.annotation.CommandCompletion;
import me.glaremasters.guilds.libs.commands.annotation.CommandPermission;
import me.glaremasters.guilds.libs.commands.annotation.Conditions;
import me.glaremasters.guilds.libs.commands.annotation.Dependency;
import me.glaremasters.guilds.libs.commands.annotation.Description;
import me.glaremasters.guilds.libs.commands.annotation.Single;
import me.glaremasters.guilds.libs.commands.annotation.Subcommand;
import me.glaremasters.guilds.libs.commands.annotation.Syntax;
import me.glaremasters.guilds.libs.commands.annotation.Values;
import me.glaremasters.guilds.libs.kotlin.Metadata;
import me.glaremasters.guilds.libs.kotlin.jvm.internal.Intrinsics;
import me.glaremasters.guilds.libs.kotlin.text.StringsKt;
import me.glaremasters.guilds.libs.locales.MessageKeyProvider;
import me.glaremasters.guilds.messages.Messages;
import me.glaremasters.guilds.utils.RoleUtils;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@CommandAlias(value="%guilds")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u0016H\u0007R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lme/glaremasters/guilds/commands/member/CommandDemote;", "Lme/glaremasters/guilds/libs/commands/BaseCommand;", "()V", "guildHandler", "Lme/glaremasters/guilds/guild/GuildHandler;", "getGuildHandler", "()Lme/glaremasters/guilds/guild/GuildHandler;", "setGuildHandler", "(Lme/glaremasters/guilds/guild/GuildHandler;)V", "guilds", "Lme/glaremasters/guilds/Guilds;", "getGuilds", "()Lme/glaremasters/guilds/Guilds;", "setGuilds", "(Lme/glaremasters/guilds/Guilds;)V", "demote", "", "player", "Lorg/bukkit/entity/Player;", "guild", "Lme/glaremasters/guilds/guild/Guild;", "target", "", "Guilds"})
public final class CommandDemote
extends BaseCommand {
    @Dependency
    public Guilds guilds;
    @Dependency
    public GuildHandler guildHandler;

    @NotNull
    public final Guilds getGuilds() {
        Guilds guilds = this.guilds;
        if (guilds != null) {
            return guilds;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"guilds");
        return null;
    }

    public final void setGuilds(@NotNull Guilds guilds) {
        Intrinsics.checkNotNullParameter((Object)((Object)guilds), (String)"<set-?>");
        this.guilds = guilds;
    }

    @NotNull
    public final GuildHandler getGuildHandler() {
        GuildHandler guildHandler = this.guildHandler;
        if (guildHandler != null) {
            return guildHandler;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"guildHandler");
        return null;
    }

    public final void setGuildHandler(@NotNull GuildHandler guildHandler) {
        Intrinsics.checkNotNullParameter((Object)guildHandler, (String)"<set-?>");
        this.guildHandler = guildHandler;
    }

    @Subcommand(value="demote")
    @Description(value="{@@descriptions.demote}")
    @CommandPermission(value="guilds.command.demote")
    @CommandCompletion(value="@members")
    @Syntax(value="%player")
    public final void demote(@NotNull Player player, @Conditions(value="perm:perm=DEMOTE") @NotNull Guild guild, @Values(value="@members") @Single @NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)guild, (String)"guild");
        Intrinsics.checkNotNullParameter((Object)string, (String)"target");
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)string);
        Intrinsics.checkNotNullExpressionValue((Object)offlinePlayer, (String)"getOfflinePlayer(target)");
        OfflinePlayer offlinePlayer2 = offlinePlayer;
        if (StringsKt.equals$default((String)offlinePlayer2.getName(), (String)player.getName(), (boolean)false, (int)2, null)) {
            throw new ExpectationNotMet(Messages.DEMOTE__CANT_DEMOTE);
        }
        if (!RoleUtils.inGuild(guild, offlinePlayer2)) {
            String[] stringArray = new String[]{"{player}", string};
            throw new ExpectationNotMet((MessageKeyProvider)Messages.ERROR__PLAYER_NOT_IN_GUILD, stringArray);
        }
        GuildMember guildMember = guild.getMember(offlinePlayer2.getUniqueId());
        if (RoleUtils.sameRole(guild, (OfflinePlayer)player, offlinePlayer2)) {
            throw new ExpectationNotMet(Messages.DEMOTE__CANT_DEMOTE);
        }
        if (RoleUtils.isLowest(this.getGuildHandler(), guildMember) || RoleUtils.isLower(guildMember, guild.getMember(player.getUniqueId()))) {
            throw new ExpectationNotMet(Messages.DEMOTE__CANT_DEMOTE);
        }
        RoleUtils.demote(this.getGuildHandler(), guild, offlinePlayer2);
        String string2 = RoleUtils.getPreDemotedRoleName(this.getGuildHandler(), guildMember);
        String string3 = RoleUtils.getCurrentRoleName(guildMember);
        String[] stringArray = new String[]{"{player}", string, "{old}", string2, "{new}", string3};
        this.getCurrentCommandIssuer().sendInfo(Messages.DEMOTE__DEMOTE_SUCCESSFUL, stringArray);
        if (!offlinePlayer2.isOnline()) {
            return;
        }
        stringArray = new String[]{"{old}", string2, "{new}", string3};
        this.getCurrentCommandManager().getCommandIssuer(offlinePlayer2).sendInfo(Messages.DEMOTE__YOU_WERE_DEMOTED, stringArray);
    }
}

