/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.commands.member;

import me.glaremasters.guilds.Guilds;
import me.glaremasters.guilds.api.events.GuildInviteEvent;
import me.glaremasters.guilds.exceptions.ExpectationNotMet;
import me.glaremasters.guilds.guild.Guild;
import me.glaremasters.guilds.guild.GuildHandler;
import me.glaremasters.guilds.libs.commands.BaseCommand;
import me.glaremasters.guilds.libs.commands.annotation.CommandAlias;
import me.glaremasters.guilds.libs.commands.annotation.CommandCompletion;
import me.glaremasters.guilds.libs.commands.annotation.CommandPermission;
import me.glaremasters.guilds.libs.commands.annotation.Conditions;
import me.glaremasters.guilds.libs.commands.annotation.Dependency;
import me.glaremasters.guilds.libs.commands.annotation.Description;
import me.glaremasters.guilds.libs.commands.annotation.Single;
import me.glaremasters.guilds.libs.commands.annotation.Subcommand;
import me.glaremasters.guilds.libs.commands.annotation.Syntax;
import me.glaremasters.guilds.libs.commands.annotation.Values;
import me.glaremasters.guilds.libs.kotlin.Metadata;
import me.glaremasters.guilds.libs.kotlin.jvm.internal.Intrinsics;
import me.glaremasters.guilds.libs.locales.MessageKeyProvider;
import me.glaremasters.guilds.messages.Messages;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@CommandAlias(value="%guilds")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u0016H\u0007R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lme/glaremasters/guilds/commands/member/CommandInvite;", "Lme/glaremasters/guilds/libs/commands/BaseCommand;", "()V", "guildHandler", "Lme/glaremasters/guilds/guild/GuildHandler;", "getGuildHandler", "()Lme/glaremasters/guilds/guild/GuildHandler;", "setGuildHandler", "(Lme/glaremasters/guilds/guild/GuildHandler;)V", "guilds", "Lme/glaremasters/guilds/Guilds;", "getGuilds", "()Lme/glaremasters/guilds/Guilds;", "setGuilds", "(Lme/glaremasters/guilds/Guilds;)V", "invite", "", "player", "Lorg/bukkit/entity/Player;", "guild", "Lme/glaremasters/guilds/guild/Guild;", "target", "", "Guilds"})
public final class CommandInvite
extends BaseCommand {
    @Dependency
    public Guilds guilds;
    @Dependency
    public GuildHandler guildHandler;

    @NotNull
    public final Guilds getGuilds() {
        Guilds guilds = this.guilds;
        if (guilds != null) {
            return guilds;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"guilds");
        return null;
    }

    public final void setGuilds(@NotNull Guilds guilds) {
        Intrinsics.checkNotNullParameter((Object)((Object)guilds), (String)"<set-?>");
        this.guilds = guilds;
    }

    @NotNull
    public final GuildHandler getGuildHandler() {
        GuildHandler guildHandler = this.guildHandler;
        if (guildHandler != null) {
            return guildHandler;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"guildHandler");
        return null;
    }

    public final void setGuildHandler(@NotNull GuildHandler guildHandler) {
        Intrinsics.checkNotNullParameter((Object)guildHandler, (String)"<set-?>");
        this.guildHandler = guildHandler;
    }

    @Subcommand(value="invite")
    @Description(value="{@@descriptions.invite}")
    @CommandPermission(value="guilds.command.invite")
    @CommandCompletion(value="@players")
    @Syntax(value="%name")
    public final void invite(@NotNull Player player, @Conditions(value="perm:perm=INVITE") @NotNull Guild guild, @Values(value="@players") @Single @NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)guild, (String)"guild");
        Intrinsics.checkNotNullParameter((Object)string, (String)"target");
        Player player2 = Bukkit.getPlayer((String)string);
        if (player2 == null || !player2.isOnline()) {
            String[] stringArray = new String[]{"{player}", string};
            throw new ExpectationNotMet((MessageKeyProvider)Messages.ERROR__PLAYER_NOT_FOUND, stringArray);
        }
        if (this.getGuildHandler().getGuild((OfflinePlayer)player2) != null) {
            String[] stringArray = new String[]{"{player}", string};
            throw new ExpectationNotMet((MessageKeyProvider)Messages.INVITE__ALREADY_IN_GUILD, stringArray);
        }
        if (guild.checkIfInvited(player2)) {
            throw new ExpectationNotMet(Messages.INVITE__ALREADY_INVITED);
        }
        GuildInviteEvent guildInviteEvent = new GuildInviteEvent(player, guild, player2);
        Bukkit.getPluginManager().callEvent((Event)guildInviteEvent);
        if (guildInviteEvent.isCancelled()) {
            return;
        }
        guild.inviteMember(player2.getUniqueId());
        String[] stringArray = new String[]{"{player}", player.getName(), "{guild}", guild.getName()};
        this.getCurrentCommandManager().getCommandIssuer(player2).sendInfo(Messages.INVITE__MESSAGE, stringArray);
        stringArray = new String[]{"{player}", player2.getName()};
        this.getCurrentCommandIssuer().sendInfo(Messages.INVITE__SUCCESSFUL, stringArray);
    }
}

