/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.configuration;

import java.io.File;
import java.io.IOException;
import me.glaremasters.guilds.libs.configme.configurationdata.ConfigurationData;
import me.glaremasters.guilds.libs.configme.migration.PlainMigrationService;
import me.glaremasters.guilds.libs.configme.resource.PropertyReader;
import me.glaremasters.guilds.utils.LoggingUtils;
import org.bukkit.configuration.file.YamlConfiguration;

public class GuildsMigrationService
extends PlainMigrationService {
    private final File pluginFolder;

    public GuildsMigrationService(File file) {
        this.pluginFolder = file;
    }

    @Override
    protected boolean performMigrations(PropertyReader propertyReader, ConfigurationData configurationData) {
        return this.hasOldObject(propertyReader, "tiers.list", "tiers.yml", true) | this.hasOldObject(propertyReader, "roles", "roles.yml", true) | this.hasOldObject(propertyReader, "guis.guild-buffs.buffs", "buffs.yml", true) || GuildsMigrationService.hasDeprecatedProperties(propertyReader);
    }

    private static boolean hasDeprecatedProperties(PropertyReader propertyReader) {
        String[] stringArray;
        for (String string : stringArray = new String[]{"hooks.essentials-remove-brackets", "tablist.enabled", "settings.save-interval", "settings.player-update-languages", "tiers.list", "tiers.carry-over", "roles", "guis.guild-buffs", "timers.cooldowns.sethome", "guild.damage.respect-wg-pvp-flag", "settings.syntax-name"}) {
            if (!propertyReader.contains(string)) continue;
            return true;
        }
        return false;
    }

    private boolean hasOldObject(PropertyReader propertyReader, String string, String string2, boolean bl) {
        if (propertyReader.contains(string)) {
            LoggingUtils.info("&f=====&a[CONFIG MIGRATOR]&f=====");
            LoggingUtils.info("&3Found old config value (&f" + string + "&3)");
            LoggingUtils.info("&3Converting old config values to new config file (&f" + string2 + "&3)...");
            File file = new File(this.pluginFolder, string2);
            if (!file.exists()) {
                try {
                    file.createNewFile();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    return false;
                }
                YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
                for (String string3 : propertyReader.getChildKeys(string)) {
                    if (bl) {
                        for (String string4 : propertyReader.getChildKeys(string3)) {
                            yamlConfiguration.set(string4, propertyReader.getObject(string4));
                        }
                        continue;
                    }
                    yamlConfiguration.set(string3, propertyReader.getObject(string3));
                }
                try {
                    yamlConfiguration.save(file);
                    LoggingUtils.info("&3Converting done!");
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            return true;
        }
        return false;
    }
}

