/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.configuration.sections;

import java.util.List;
import me.glaremasters.guilds.libs.configme.Comment;
import me.glaremasters.guilds.libs.configme.SettingsHolder;
import me.glaremasters.guilds.libs.configme.configurationdata.CommentsConfiguration;
import me.glaremasters.guilds.libs.configme.properties.Property;
import me.glaremasters.guilds.libs.configme.properties.PropertyInitializer;

public class ClaimSettings
implements SettingsHolder {
    @Comment(value={"This is the number of blocks around the player it will try to create the region.", "Keep in mind this is the RADIUS, it will go this many blocks in both directions.", "For example, if you take the default 15, it'll do 30 total as it will go 15 blocks in both directions.", "This is a CUBOID region, not SPHERE."})
    public static final Property<Integer> RADIUS = PropertyInitializer.newProperty("claims.radius", 15);
    @Comment(value={"Customize the entrance and exit message of joining claims.", "Supports {prefix} for guild prefix and {guild} for guild name.", "Also supports color codes!"})
    public static final Property<String> ENTER_MESSAGE = PropertyInitializer.newProperty("claims.enter-message", "&aNow entering &d{guild}'s &aclaim!");
    public static final Property<String> EXIT_MESSAGE = PropertyInitializer.newProperty("claims.exit-message", "&aNow leaving &d{guild}'s &aclaim!");
    @Comment(value={"Would you like to disable guild claiming in specific worlds?"})
    public static final Property<List<String>> DISABLED_WORLDS = PropertyInitializer.newListProperty("claims.disabled-worlds", "");
    @Comment(value={"Would you like to enable claim signs?", "Format - ", "First Line: [Guild Claim]", "Second Line: WorldGuard Region Name", "Third Line: Price"})
    public static final Property<Boolean> CLAIM_SIGNS = PropertyInitializer.newProperty("claims.claim-signs", false);
    @Comment(value={"The text to look for on a sign for the guild claims"})
    public static final Property<String> CLAIM_SIGN_TEXT = PropertyInitializer.newProperty("claims.claim-sign-text", "[Guild Claim]");
    @Comment(value={"Would you like to make it so that claims can only be aquired through the purchasing with signs?", "This will disable the regular claim commands."})
    public static final Property<Boolean> FORCE_CLAIM_SIGNS = PropertyInitializer.newProperty("claims.force-claim-signs", false);

    private ClaimSettings() {
    }

    @Override
    public void registerComments(CommentsConfiguration commentsConfiguration) {
        String[] stringArray = new String[]{"This section of the config will allow you to handle guild land claiming.", "Remember that the enable / disable for this is the WorldGuard Hook at the TOP of the config.", "There are multiple options when it comes to guild claims. For the time being, all guilds will only get one claim."};
        commentsConfiguration.setComment("claims", stringArray);
    }
}

