/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.configuration.sections;

import java.util.List;
import me.glaremasters.guilds.libs.configme.Comment;
import me.glaremasters.guilds.libs.configme.SettingsHolder;
import me.glaremasters.guilds.libs.configme.properties.Property;
import me.glaremasters.guilds.libs.configme.properties.PropertyInitializer;

public class WarSettings
implements SettingsHolder {
    @Comment(value={"How often (in minutes) can a guild be the defender in a war?", "This is to help prevent abuse from guilds fighting each other to farm rewards.", "This is defaulted to 1 day."})
    public static final Property<Integer> DEFEND_COOLDOWN = PropertyInitializer.newProperty("war.defend-cooldown", 1440);
    @Comment(value={"Would you like to block commands while a player is in the war?"})
    public static final Property<Boolean> DISABLE_COMMANDS = PropertyInitializer.newProperty("war.disable-commands", false);
    @Comment(value={"Would you like to have the players keep their inventory when they die in the arena?"})
    public static final Property<Boolean> KEEP_INVENTORY = PropertyInitializer.newProperty("war.keep-inventory", true);
    @Comment(value={"Would you like to have the players keep their experience when they die in the arena?"})
    public static final Property<Boolean> KEEP_EXP = PropertyInitializer.newProperty("war.keep-exp", true);
    @Comment(value={"Would you like to clear the drops when a player dies in the arena?", "This is typically paired with keeping inventory true so that you can prevent duplication."})
    public static final Property<Boolean> CLEAR_DROPS = PropertyInitializer.newProperty("war.clear-drops", true);
    @Comment(value={"How long does a defending guild have to accept a war challenge? (In seconds)"})
    public static final Property<Integer> ACCEPT_TIME = PropertyInitializer.newProperty("war.accept-time", 120);
    @Comment(value={"What is the min number of players needed on each side for a war to start?"})
    public static final Property<Integer> MIN_PLAYERS = PropertyInitializer.newProperty("war.min-players", 3);
    @Comment(value={"What is the max number of players allowed on each side for a war?"})
    public static final Property<Integer> MAX_PLAYERS = PropertyInitializer.newProperty("war.max-players", 8);
    @Comment(value={"How long do players of both sides have to join the war? (In seconds)"})
    public static final Property<Integer> JOIN_TIME = PropertyInitializer.newProperty("war.join-time", 60);
    @Comment(value={"How long should we wait to teleport the players and start the war after everyone joined?"})
    public static final Property<Integer> READY_TIME = PropertyInitializer.newProperty("war.ready-time", 60);
    @Comment(value={"How would you like to notify the player about joining the war and the countdowns?", "Options: [actionbar, title, subtitle, none]"})
    public static final Property<String> NOTIFY_TYPE = PropertyInitializer.newProperty("war.notify-type", "actionbar");
    @Comment(value={"Would you like to enable running commands after a challenge ends? (such as broadcasting)"})
    public static final Property<Boolean> ENABLE_POST_CHALLENGE_COMMANDS = PropertyInitializer.newProperty("war.post-challenge-commands.enabled", false);
    @Comment(value={"What commands would you like to run after a challenge ends??", "Supports the following placeholder:", "{challenger} - The name of the challenging Guild", "{defender} - The name of the defending Guild", "{winner} - The winner of the challenge", "{loser} - The loser of the challenge"})
    public static final Property<List<String>> POST_CHALLENGE_COMMANDS = PropertyInitializer.newListProperty("war.post-challenge-commands.commands", "");
    @Comment(value={"Would you like to give rewards to the winning guild?"})
    public static final Property<Boolean> WAR_REWARDS_ENABLED = PropertyInitializer.newProperty("war.rewards.enabled", false);
    @Comment(value={"What rewards (commands) would you like to run for the winning Guild?", "Current supports {player}."})
    public static final Property<List<String>> WAR_REWARDS = PropertyInitializer.newListProperty("war.rewards.rewards", "");
}

