/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.database.arenas;

import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.glaremasters.guilds.Guilds;
import me.glaremasters.guilds.arena.Arena;
import me.glaremasters.guilds.database.DatabaseAdapter;
import me.glaremasters.guilds.database.DatabaseBackend;
import me.glaremasters.guilds.database.arenas.ArenaProvider;
import me.glaremasters.guilds.database.arenas.provider.ArenaJsonProvider;
import org.jetbrains.annotations.NotNull;

public class ArenaAdapter {
    private final ArenaProvider provider;
    private String sqlTablePrefix;

    public ArenaAdapter(Guilds guilds, DatabaseAdapter databaseAdapter) {
        DatabaseBackend databaseBackend = databaseAdapter.getBackend();
        switch (databaseBackend) {
            default: {
                File file = new File(guilds.getDataFolder(), "arenas");
                this.provider = new ArenaJsonProvider(file);
                break;
            }
            case MYSQL: 
            case SQLITE: 
            case MARIADB: {
                this.sqlTablePrefix = databaseAdapter.getSqlTablePrefix();
                this.provider = databaseAdapter.getDatabaseManager().getJdbi().onDemand(databaseBackend.getArenaProvider());
            }
        }
    }

    public void createContainer() {
        this.provider.createContainer(this.sqlTablePrefix);
    }

    public boolean arenaExists(@NotNull String string) {
        return this.provider.arenaExists(this.sqlTablePrefix, string);
    }

    public List<String> getAllArenaIds() {
        return this.provider.getAllArenaIds(this.sqlTablePrefix);
    }

    public List<Arena> getAllArenas() {
        return this.provider.getAllArenas(this.sqlTablePrefix);
    }

    public void saveArenas(@NotNull Collection<Arena> collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Arena object : collection) {
            this.saveArena(object);
            arrayList.add(object.getId().toString());
        }
        for (String string : this.getAllArenaIds()) {
            boolean bl = arrayList.stream().anyMatch(string2 -> string2.equals(string));
            if (bl) continue;
            this.deleteArena(string);
        }
        arrayList.clear();
    }

    public void saveArena(@NotNull Arena arena) {
        if (!this.arenaExists(arena.getId().toString())) {
            this.createArena(arena);
        } else {
            this.updateArena(arena);
        }
    }

    public void createArena(@NotNull Arena arena) {
        this.provider.createArena(this.sqlTablePrefix, arena.getId().toString(), Guilds.getGson().toJson((Object)arena, (Type)((Object)Arena.class)));
    }

    public void updateArena(@NotNull Arena arena) {
        this.provider.updateArena(this.sqlTablePrefix, arena.getId().toString(), Guilds.getGson().toJson((Object)arena, (Type)((Object)Arena.class)));
    }

    public void deleteArena(@NotNull String string) {
        this.provider.deleteArena(this.sqlTablePrefix, string);
    }
}

