/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.database.cooldowns;

import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import me.glaremasters.guilds.Guilds;
import me.glaremasters.guilds.cooldowns.Cooldown;
import me.glaremasters.guilds.database.DatabaseAdapter;
import me.glaremasters.guilds.database.DatabaseBackend;
import me.glaremasters.guilds.database.cooldowns.CooldownProvider;
import me.glaremasters.guilds.database.cooldowns.provider.CooldownJsonProvider;
import me.glaremasters.guilds.utils.LoggingUtils;

public class CooldownAdapter {
    private final CooldownProvider provider;
    private String sqlTablePrefix;

    public CooldownAdapter(Guilds guilds, DatabaseAdapter databaseAdapter) {
        DatabaseBackend databaseBackend = databaseAdapter.getBackend();
        switch (databaseBackend) {
            default: {
                File file = new File(guilds.getDataFolder(), "cooldowns");
                this.provider = new CooldownJsonProvider(file);
                break;
            }
            case MYSQL: 
            case SQLITE: 
            case MARIADB: {
                this.sqlTablePrefix = databaseAdapter.getSqlTablePrefix();
                this.provider = databaseAdapter.getDatabaseManager().getJdbi().onDemand(databaseBackend.getCooldownProvider());
            }
        }
    }

    public void createContainer() {
        this.provider.createContainer(this.sqlTablePrefix);
    }

    public List<Cooldown> getAllCooldowns() {
        return this.provider.getAllCooldowns(this.sqlTablePrefix);
    }

    public boolean cooldownExists(Cooldown cooldown) {
        return this.cooldownExists(cooldown.getCooldownType(), cooldown.getCooldownOwner());
    }

    public boolean cooldownExists(Cooldown.Type type, UUID uUID) {
        return this.provider.cooldownExists(this.sqlTablePrefix, type.getTypeName(), uUID.toString());
    }

    public void createCooldown(Cooldown cooldown) {
        this.createCooldown(cooldown.getCooldownType(), cooldown.getCooldownOwner(), cooldown.getCooldownExpiry());
    }

    public void createCooldown(Cooldown.Type type, UUID uUID, Long l) {
        this.provider.createCooldown(this.sqlTablePrefix, type.getTypeName(), uUID.toString(), new Timestamp(l));
    }

    public void deleteCooldown(Cooldown cooldown) {
        this.deleteCooldown(cooldown.getCooldownType(), cooldown.getCooldownOwner());
    }

    public void deleteCooldown(Cooldown.Type type, UUID uUID) {
        this.provider.deleteCooldown(this.sqlTablePrefix, type.getTypeName(), uUID.toString());
    }

    public void saveCooldowns(Collection<Cooldown> collection) {
        try {
            for (Cooldown cooldown : collection) {
                if (this.cooldownExists(cooldown)) continue;
                this.createCooldown(cooldown);
            }
        }
        catch (IOException iOException) {
            LoggingUtils.warn("Failed to save cooldowns");
        }
    }
}

