/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.database.cooldowns.provider;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import me.glaremasters.guilds.Guilds;
import me.glaremasters.guilds.cooldowns.Cooldown;
import me.glaremasters.guilds.database.cooldowns.CooldownProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CooldownJsonProvider
implements CooldownProvider {
    private final File dataFolder;
    private final File cooldownFile;
    private Gson gson;
    private Type cooldownCollectionType;

    public CooldownJsonProvider(File file) {
        this.dataFolder = file;
        this.cooldownFile = new File(file, "cooldowns.json");
        this.gson = Guilds.getGson();
        this.cooldownCollectionType = new TypeToken<List<Cooldown>>(){}.getType();
    }

    @Override
    public void createContainer(@Nullable String string) {
        if (!this.dataFolder.exists()) {
            this.dataFolder.mkdir();
        }
        if (!this.cooldownFile.exists()) {
            this.cooldownFile.createNewFile();
        }
    }

    @Override
    public boolean cooldownExists(@Nullable String string, @NotNull String string2, @NotNull String string3) {
        return this.cooldownExists(string2, string3, this.getAllCooldowns(string));
    }

    @Override
    public List<Cooldown> getAllCooldowns(@Nullable String string) {
        List list2 = (List)this.gson.fromJson((Reader)new InputStreamReader((InputStream)new FileInputStream(this.cooldownFile), StandardCharsets.UTF_8), this.cooldownCollectionType);
        return list2 == null ? new ArrayList() : list2;
    }

    @Override
    public void createCooldown(@Nullable String string, @NotNull String string2, @NotNull String string3, @NotNull String string4, @NotNull Timestamp timestamp) {
        List<Cooldown> list2 = this.getAllCooldowns(string);
        if (this.cooldownExists(string3, string4, list2)) {
            return;
        }
        list2.add(new Cooldown(UUID.fromString(string2), Cooldown.Type.getByTypeName(string3), UUID.fromString(string4), timestamp.getTime()));
        this.writeCooldownFile(this.cooldownFile, list2);
    }

    @Override
    public void deleteCooldown(@Nullable String string, @NotNull String string2, @NotNull String string3) {
        List<Cooldown> list2 = this.getAllCooldowns(string);
        if (!this.cooldownExists(string2, string3, list2)) {
            return;
        }
        list2.removeIf(cooldown -> cooldown.getCooldownType().getTypeName().equalsIgnoreCase(string2) && cooldown.getCooldownOwner().toString().equals(string3));
        this.writeCooldownFile(this.cooldownFile, list2);
    }

    private void writeCooldownFile(File file, List<Cooldown> list2) {
        Files.write(Paths.get(file.getPath(), new String[0]), this.gson.toJson(list2, this.cooldownCollectionType).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    private boolean cooldownExists(@NotNull String string, @NotNull String string2, @NotNull List<Cooldown> list2) {
        return list2.stream().filter(cooldown -> cooldown.getCooldownType().getTypeName().equalsIgnoreCase(string) && cooldown.getCooldownOwner().toString().equals(string2)).findFirst().orElse(null) != null;
    }
}

