/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.database.guild.provider;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import me.glaremasters.guilds.Guilds;
import me.glaremasters.guilds.database.guild.GuildProvider;
import me.glaremasters.guilds.guild.Guild;
import me.glaremasters.guilds.utils.LoggingUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuildJsonProvider
implements GuildProvider {
    private final File dataFolder;
    private Gson gson;

    public GuildJsonProvider(File file) {
        this.dataFolder = file;
        this.gson = Guilds.getGson();
    }

    @Override
    public void createContainer(@Nullable String string) {
        if (!this.dataFolder.exists()) {
            this.dataFolder.mkdir();
        }
    }

    @Override
    public boolean guildExists(@Nullable String string, @NotNull String string3) {
        return Arrays.stream(Objects.requireNonNull(this.dataFolder.listFiles())).map(file -> com.google.common.io.Files.getNameWithoutExtension((String)file.getName())).anyMatch(string2 -> string2.equals(string3));
    }

    @Override
    public List<String> getAllGuildIds(@Nullable String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (File file : Objects.requireNonNull(this.dataFolder.listFiles())) {
            arrayList.add(com.google.common.io.Files.getNameWithoutExtension((String)file.getName()));
        }
        return arrayList;
    }

    @Override
    public List<Guild> getAllGuilds(@Nullable String string) {
        ArrayList<Guild> arrayList = new ArrayList<Guild>();
        for (File file : Objects.requireNonNull(this.dataFolder.listFiles())) {
            try {
                Guild guild = this.gson.fromJson((Reader)new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8), Guild.class);
                guild.getId();
                arrayList.add(guild);
            }
            catch (Exception exception) {
                LoggingUtils.severe("There was an error loading a Guild from the following file: " + file.getAbsolutePath());
                LoggingUtils.severe("To prevent data loss in the plugin, this Guild has been prevented from loading.");
            }
        }
        return arrayList;
    }

    @Override
    public Guild getGuild(@Nullable String string, @NotNull String string2) {
        File file2 = Arrays.stream(Objects.requireNonNull(this.dataFolder.listFiles())).filter(file -> com.google.common.io.Files.getNameWithoutExtension((String)file.getName()).equals(string2)).findFirst().orElse(null);
        if (file2 == null) {
            return null;
        }
        return this.gson.fromJson((Reader)new InputStreamReader((InputStream)new FileInputStream(file2), StandardCharsets.UTF_8), Guild.class);
    }

    @Override
    public void createGuild(@Nullable String string, @NotNull String string2, @NotNull String string3) {
        if (this.guildExists(string, string2)) {
            return;
        }
        this.writeGuildFile(new File(this.dataFolder, string2 + ".json"), string3);
    }

    @Override
    public void updateGuild(@Nullable String string, @NotNull String string2, @NotNull String string3) {
        File file = new File(this.dataFolder, string2 + ".json");
        this.deleteGuild(file);
        this.writeGuildFile(file, string3);
    }

    private void writeGuildFile(File file, String string) {
        Files.write(Paths.get(file.getPath(), new String[0]), string.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    @Override
    public void deleteGuild(@Nullable String string, @NotNull String string2) {
        this.deleteGuild(new File(this.dataFolder, string2 + ".json"));
    }

    private void deleteGuild(File file) {
        if (file.exists()) {
            file.delete();
        }
    }
}

