/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.guild;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import me.glaremasters.guilds.Guilds;
import me.glaremasters.guilds.configuration.sections.GuildListSettings;
import me.glaremasters.guilds.guild.GuildCode;
import me.glaremasters.guilds.guild.GuildHandler;
import me.glaremasters.guilds.guild.GuildHome;
import me.glaremasters.guilds.guild.GuildMember;
import me.glaremasters.guilds.guild.GuildRole;
import me.glaremasters.guilds.guild.GuildRolePerm;
import me.glaremasters.guilds.guild.GuildScore;
import me.glaremasters.guilds.guild.GuildSkull;
import me.glaremasters.guilds.guild.GuildTier;
import me.glaremasters.guilds.libs.commands.CommandManager;
import me.glaremasters.guilds.libs.configme.SettingsManager;
import me.glaremasters.guilds.messages.Messages;
import me.glaremasters.guilds.utils.SkullUtils;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class Guild {
    private final UUID id;
    private String name;
    private String prefix;
    private String motd;
    private GuildMember guildMaster;
    private GuildHome home;
    private GuildSkull guildSkull;
    private Status status;
    private GuildTier tier;
    private GuildScore guildScore;
    private double balance;
    private List<GuildMember> members;
    private List<UUID> invitedMembers;
    private List<UUID> allies;
    private List<UUID> pendingAllies;
    private List<GuildCode> codes;
    private List<String> vaults;
    private long lastDefended;
    private long creationDate;

    public Guild(UUID uUID) {
        this.id = uUID;
    }

    public Guild(UUID uUID, String string, String string2, String string3, GuildMember guildMember, GuildHome guildHome, GuildSkull guildSkull, Status status, GuildTier guildTier, GuildScore guildScore, double d, List<GuildMember> list2, List<UUID> list3, List<UUID> list4, List<UUID> list5, List<GuildCode> list6, List<String> list7, long l) {
        this.id = uUID;
        this.name = string;
        this.prefix = string2;
        this.motd = string3;
        this.guildMaster = guildMember;
        this.home = guildHome;
        this.guildSkull = guildSkull;
        this.status = status;
        this.tier = guildTier;
        this.guildScore = guildScore;
        this.balance = d;
        this.members = list2;
        this.invitedMembers = list3;
        this.allies = list4;
        this.pendingAllies = list5;
        this.codes = list6;
        this.vaults = list7;
        this.lastDefended = l;
    }

    public static GuildBuilder builder() {
        return new GuildBuilder();
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setPrefix(String string) {
        this.prefix = string;
    }

    public void setMotd(String string) {
        this.motd = string;
    }

    public void setGuildMaster(GuildMember guildMember) {
        this.guildMaster = guildMember;
    }

    public void setHome(GuildHome guildHome) {
        this.home = guildHome;
    }

    public void setGuildSkull(GuildSkull guildSkull) {
        this.guildSkull = guildSkull;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setTier(GuildTier guildTier) {
        this.tier = guildTier;
    }

    public void setGuildScore(GuildScore guildScore) {
        this.guildScore = guildScore;
    }

    public void setBalance(double d) {
        this.balance = d;
    }

    public void setMembers(List<GuildMember> list2) {
        this.members = list2;
    }

    public void setInvitedMembers(List<UUID> list2) {
        this.invitedMembers = list2;
    }

    public void setAllies(List<UUID> list2) {
        this.allies = list2;
    }

    public void setPendingAllies(List<UUID> list2) {
        this.pendingAllies = list2;
    }

    public void setCodes(List<GuildCode> list2) {
        this.codes = list2;
    }

    public void setVaults(List<String> list2) {
        this.vaults = list2;
    }

    public void setLastDefended(long l) {
        this.lastDefended = l;
    }

    public long getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(long l) {
        this.creationDate = l;
    }

    public GuildMember getMember(UUID uUID) {
        return this.members.stream().filter(guildMember -> guildMember.getUuid().equals(uUID)).findFirst().orElse(null);
    }

    public ItemStack getSkull() {
        return SkullUtils.getSkull(this.guildSkull.getSerialized());
    }

    public void addMember(OfflinePlayer offlinePlayer, GuildHandler guildHandler) {
        GuildMember guildMember = new GuildMember(offlinePlayer.getUniqueId(), guildHandler.getLowestGuildRole());
        if (this.members.contains(guildMember)) {
            return;
        }
        this.removeInvitedMember(guildMember.getUuid());
        this.members.add(guildMember);
        guildMember.setJoinDate(System.currentTimeMillis());
    }

    public void addMemberByCode(GuildMember guildMember) {
        this.members.add(guildMember);
    }

    public void removeMember(GuildMember guildMember) {
        this.members.remove(guildMember);
    }

    public void removeMember(OfflinePlayer offlinePlayer) {
        this.removeMember(this.getMember(offlinePlayer.getUniqueId()));
    }

    public void removeAlly(Guild guild) {
        this.allies.remove(guild.getId());
    }

    public void addAlly(Guild guild) {
        this.allies.add(guild.getId());
    }

    public boolean hasAllies() {
        return !this.allies.isEmpty();
    }

    public boolean hasPendingAllies() {
        return !this.pendingAllies.isEmpty();
    }

    public void addPendingAlly(Guild guild) {
        this.pendingAllies.add(guild.getId());
    }

    public boolean isAllyPending(Guild guild) {
        return this.pendingAllies.contains(guild.getId());
    }

    public void removePendingAlly(Guild guild) {
        this.pendingAllies.remove(guild.getId());
    }

    public void inviteMember(UUID uUID) {
        if (this.invitedMembers.contains(uUID)) {
            return;
        }
        this.invitedMembers.add(uUID);
    }

    public boolean checkIfInvited(Player player) {
        return this.invitedMembers.contains(player.getUniqueId());
    }

    public void removeInvitedMember(UUID uUID) {
        this.invitedMembers.remove(uUID);
    }

    public int getSize() {
        return this.members.size();
    }

    public List<GuildMember> getOnlineMembers() {
        return this.members.stream().filter(GuildMember::isOnline).collect(Collectors.toList());
    }

    public List<Player> getOnlineAsPlayers() {
        return this.getOnlineMembers().stream().map(guildMember -> Bukkit.getPlayer((UUID)guildMember.getUuid())).collect(Collectors.toList());
    }

    public List<UUID> getOnlineAsUUIDs() {
        return this.getOnlineMembers().stream().map(GuildMember::getUuid).collect(Collectors.toList());
    }

    public List<OfflinePlayer> getAllAsPlayers() {
        return this.members.stream().map(GuildMember::getAsOfflinePlayer).collect(Collectors.toList());
    }

    public boolean hasInviteCode(String string) {
        return this.codes.stream().anyMatch(guildCode -> guildCode.getId().equals(string));
    }

    public GuildCode getCode(String string) {
        return this.codes.stream().filter(guildCode -> guildCode.getId().equals(string)).findFirst().orElse(null);
    }

    public List<GuildCode> getActiveCodes() {
        return this.codes.stream().filter(guildCode -> guildCode.getUses() > 0).collect(Collectors.toList());
    }

    public void addCode(String string, int n, Player player) {
        this.codes.add(new GuildCode(string, n, player.getUniqueId(), new ArrayList<UUID>()));
    }

    public void removeCode(String string) {
        this.codes.removeIf(guildCode -> guildCode.getId().equals(string));
    }

    public boolean getActiveCheck(int n) {
        return this.getActiveCodes().size() >= n;
    }

    public String getRedeemers(String string) {
        GuildCode guildCode = this.getCode(string);
        if (guildCode.getRedeemers().isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        guildCode.getRedeemers().forEach(uUID -> stringBuilder.append(Bukkit.getOfflinePlayer((UUID)uUID).getName() + ", "));
        stringBuilder.setLength(stringBuilder.length() - 2);
        return stringBuilder.toString();
    }

    public void sendMessage(CommandManager commandManager, Messages messages, String ... stringArray) {
        this.getOnlineMembers().forEach(guildMember -> commandManager.getCommandIssuer(Bukkit.getPlayer((UUID)guildMember.getUuid())).sendInfo(messages, stringArray));
    }

    public void sendMessage(String string) {
        this.getOnlineAsPlayers().forEach(player -> player.sendMessage(string));
    }

    public void toggleStatus() {
        if (this.status == Status.Private) {
            this.setStatus(Status.Public);
        } else {
            this.setStatus(Status.Private);
        }
    }

    public void delHome() {
        this.setHome(null);
    }

    public void setNewHome(Player player) {
        Location location = player.getLocation();
        this.setHome(new GuildHome(location.getWorld().getName(), location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch()));
    }

    public boolean isPrivate() {
        return this.status == Status.Private;
    }

    public boolean isMaster(OfflinePlayer offlinePlayer) {
        return this.guildMaster.getUuid().equals(offlinePlayer.getUniqueId());
    }

    public void transferGuild(OfflinePlayer offlinePlayer, OfflinePlayer offlinePlayer2, GuildHandler guildHandler, Permission permission) {
        GuildMember guildMember = this.getMember(offlinePlayer.getUniqueId());
        GuildMember guildMember2 = this.getMember(offlinePlayer2.getUniqueId());
        GuildRole guildRole = guildMember.getRole();
        guildHandler.removeRolePerm(permission, offlinePlayer);
        guildHandler.removeRolePerm(permission, offlinePlayer2);
        guildMember.setRole(guildMember2.getRole());
        guildMember2.setRole(guildRole);
        guildHandler.addRolePerm(permission, offlinePlayer);
        guildHandler.addRolePerm(permission, offlinePlayer2);
        this.setGuildMaster(guildMember2);
    }

    public void transferGuildAdmin(OfflinePlayer offlinePlayer, GuildHandler guildHandler, Permission permission) {
        GuildMember guildMember = this.getMember(this.getGuildMaster().getUuid());
        GuildMember guildMember2 = this.getMember(offlinePlayer.getUniqueId());
        GuildRole guildRole = guildMember.getRole();
        guildHandler.removeRolePerm(permission, guildMember.getAsOfflinePlayer());
        guildHandler.removeRolePerm(permission, guildMember2.getAsOfflinePlayer());
        guildMember.setRole(guildHandler.getGuildRole(guildRole.getLevel() + 1));
        guildMember2.setRole(guildHandler.getGuildRole(0));
        guildHandler.addRolePerm(permission, guildMember.getAsOfflinePlayer());
        guildHandler.addRolePerm(permission, guildMember2.getAsOfflinePlayer());
        this.setGuildMaster(guildMember2);
    }

    public void addPotion(String string, int n, int n2) {
        this.getOnlineAsPlayers().forEach(player -> player.addPotionEffect(new PotionEffect(PotionEffectType.getByName((String)string), n, n2)));
    }

    public boolean memberHasPermission(Player player, String string) {
        return this.memberHasPermission(player, GuildRolePerm.valueOf(string));
    }

    public boolean memberHasPermission(Player player, GuildRolePerm guildRolePerm) {
        GuildMember guildMember = this.getMember(player.getUniqueId());
        GuildRole guildRole = guildMember.getRole();
        return guildRole.hasPerm(guildRolePerm);
    }

    public void updateGuildSkull(Player player, SettingsManager settingsManager) {
        Guilds.newChain().async(() -> {
            try {
                this.guildSkull = new GuildSkull(player);
            }
            catch (Exception exception) {
                this.guildSkull = new GuildSkull(settingsManager.getProperty(GuildListSettings.GUILD_LIST_HEAD_DEFAULT_URL));
            }
        }).execute();
    }

    public void addPotion(PotionEffect potionEffect) {
        this.getOnlineAsPlayers().forEach(player -> player.addPotionEffect(potionEffect));
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getMotd() {
        return this.motd;
    }

    public GuildMember getGuildMaster() {
        return this.guildMaster;
    }

    public GuildHome getHome() {
        return this.home;
    }

    public GuildSkull getGuildSkull() {
        return this.guildSkull;
    }

    public Status getStatus() {
        return this.status;
    }

    public GuildTier getTier() {
        return this.tier;
    }

    public double getBalance() {
        return this.balance;
    }

    public List<GuildMember> getMembers() {
        if (this.members == null) {
            this.members = new ArrayList<GuildMember>();
        }
        return this.members;
    }

    public List<UUID> getInvitedMembers() {
        if (this.invitedMembers == null) {
            this.invitedMembers = new ArrayList<UUID>();
        }
        return this.invitedMembers;
    }

    public List<UUID> getAllies() {
        if (this.allies == null) {
            this.allies = new ArrayList<UUID>();
        }
        return this.allies;
    }

    public List<UUID> getPendingAllies() {
        if (this.pendingAllies == null) {
            this.pendingAllies = new ArrayList<UUID>();
        }
        return this.pendingAllies;
    }

    public GuildScore getGuildScore() {
        if (this.guildScore == null) {
            this.guildScore = new GuildScore();
        }
        return this.guildScore;
    }

    public List<GuildCode> getCodes() {
        if (this.codes == null) {
            this.codes = new ArrayList<GuildCode>();
        }
        return this.codes;
    }

    public List<String> getVaults() {
        if (this.vaults == null) {
            this.vaults = new ArrayList<String>();
        }
        return this.vaults;
    }

    public long getLastDefended() {
        return this.lastDefended;
    }

    public static enum Status {
        Public("Public"),
        Private("Private");


        private Status(String string2) {
        }
    }

    public static class GuildBuilder {
        private UUID id;
        private String name;
        private String prefix;
        private String motd;
        private GuildMember guildMaster;
        private GuildHome home;
        private GuildSkull guildSkull;
        private Status status;
        private GuildTier tier;
        private GuildScore guildScore;
        private double balance;
        private List<GuildMember> members;
        private List<UUID> invitedMembers;
        private List<UUID> allies;
        private List<UUID> pendingAllies;
        private List<GuildCode> codes;
        private List<String> vaults;
        private long lastDefended;

        GuildBuilder() {
        }

        public GuildBuilder id(UUID uUID) {
            this.id = uUID;
            return this;
        }

        public GuildBuilder name(String string) {
            this.name = string;
            return this;
        }

        public GuildBuilder prefix(String string) {
            this.prefix = string;
            return this;
        }

        public GuildBuilder motd(String string) {
            this.motd = string;
            return this;
        }

        public GuildBuilder guildMaster(GuildMember guildMember) {
            this.guildMaster = guildMember;
            return this;
        }

        public GuildBuilder home(GuildHome guildHome) {
            this.home = guildHome;
            return this;
        }

        public GuildBuilder guildSkull(GuildSkull guildSkull) {
            this.guildSkull = guildSkull;
            return this;
        }

        public GuildBuilder status(Status status) {
            this.status = status;
            return this;
        }

        public GuildBuilder tier(GuildTier guildTier) {
            this.tier = guildTier;
            return this;
        }

        public GuildBuilder guildScore(GuildScore guildScore) {
            this.guildScore = guildScore;
            return this;
        }

        public GuildBuilder balance(double d) {
            this.balance = d;
            return this;
        }

        public GuildBuilder members(List<GuildMember> list2) {
            this.members = list2;
            return this;
        }

        public GuildBuilder invitedMembers(List<UUID> list2) {
            this.invitedMembers = list2;
            return this;
        }

        public GuildBuilder allies(List<UUID> list2) {
            this.allies = list2;
            return this;
        }

        public GuildBuilder pendingAllies(List<UUID> list2) {
            this.pendingAllies = list2;
            return this;
        }

        public GuildBuilder codes(List<GuildCode> list2) {
            this.codes = list2;
            return this;
        }

        public GuildBuilder vaults(List<String> list2) {
            this.vaults = list2;
            return this;
        }

        public GuildBuilder lastDefended(long l) {
            this.lastDefended = l;
            return this;
        }

        public Guild build() {
            return new Guild(this.id, this.name, this.prefix, this.motd, this.guildMaster, this.home, this.guildSkull, this.status, this.tier, this.guildScore, this.balance, this.members, this.invitedMembers, this.allies, this.pendingAllies, this.codes, this.vaults, this.lastDefended);
        }

        public String toString() {
            return "Guild.GuildBuilder(id=" + this.id + ", name=" + this.name + ", prefix=" + this.prefix + ", motd=" + this.motd + ", guildMaster=" + this.guildMaster + ", home=" + this.home + ", guildSkull=" + this.guildSkull + ", status=" + (Object)((Object)this.status) + ", tier=" + this.tier + ", guildScore=" + this.guildScore + ", balance=" + this.balance + ", members=" + this.members + ", invitedMembers=" + this.invitedMembers + ", allies=" + this.allies + ", pendingAllies=" + this.pendingAllies + ", codes=" + this.codes + ", vaults=" + this.vaults + ", lastDefended=" + this.lastDefended + ")";
        }
    }
}

