/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.guild;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.clip.placeholderapi.PlaceholderAPI;
import me.glaremasters.guilds.Guilds;
import me.glaremasters.guilds.configuration.sections.GuildSettings;
import me.glaremasters.guilds.configuration.sections.GuildVaultSettings;
import me.glaremasters.guilds.configuration.sections.PluginSettings;
import me.glaremasters.guilds.configuration.sections.TicketSettings;
import me.glaremasters.guilds.exceptions.ExpectationNotMet;
import me.glaremasters.guilds.guild.Guild;
import me.glaremasters.guilds.guild.GuildCode;
import me.glaremasters.guilds.guild.GuildMember;
import me.glaremasters.guilds.guild.GuildRole;
import me.glaremasters.guilds.guild.GuildRolePerm;
import me.glaremasters.guilds.guild.GuildTier;
import me.glaremasters.guilds.libs.commands.ACFBukkitUtil;
import me.glaremasters.guilds.libs.commands.ACFUtil;
import me.glaremasters.guilds.libs.commands.PaperCommandManager;
import me.glaremasters.guilds.libs.configme.SettingsManager;
import me.glaremasters.guilds.messages.Messages;
import me.glaremasters.guilds.utils.ClaimUtils;
import me.glaremasters.guilds.utils.ItemBuilder;
import me.glaremasters.guilds.utils.LoggingUtils;
import me.glaremasters.guilds.utils.Serialization;
import me.glaremasters.guilds.utils.StringUtils;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.codemc.worldguardwrapper.WorldGuardWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuildHandler {
    private final Guilds guildsPlugin;
    private final SettingsManager settingsManager;
    private final Map<UUID, Guild> guilds = new HashMap<UUID, Guild>();
    private final List<GuildRole> roles = new ArrayList<GuildRole>();
    private final List<GuildTier> tiers = new ArrayList<GuildTier>();
    private final List<Player> spies = new ArrayList<Player>();
    private final Map<Guild, List<Inventory>> vaults = new HashMap<Guild, List<Inventory>>();
    private final List<Player> opened = new ArrayList<Player>();
    private final Map<UUID, String> lookupCache = new HashMap<UUID, String>();
    private final Map<UUID, UUID> memberCache = new HashMap<UUID, UUID>();
    private boolean migrating = false;
    public boolean papi = false;

    public GuildHandler(Guilds guilds, SettingsManager settingsManager) {
        this.guildsPlugin = guilds;
        this.settingsManager = settingsManager;
        this.loadRoles();
        this.loadTiers();
        try {
            this.loadGuilds();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void loadGuilds() {
        List<Guild> list2 = this.guildsPlugin.getDatabase().getGuildAdapter().getAllGuilds();
        list2.forEach(guild -> this.guilds.put(guild.getId(), (Guild)guild));
        for (Guild guild2 : this.guilds.values()) {
            this.createVaultCache(guild2);
            GuildTier guildTier = this.getGuildTier(guild2.getTier().getLevel());
            if (guildTier != null) {
                guild2.setTier(guildTier);
            } else {
                guild2.setTier(this.getLowestGuildTier());
                LoggingUtils.severe("The guild (" + guild2.getName() + ") had a tier level that doesn't exist on the server anymore. To prevent issues, they've been automatically set the the lowest tier level on the server.");
            }
            if (guild2.getCreationDate() == 0L) {
                guild2.setCreationDate(System.currentTimeMillis());
            }
            for (GuildMember guildMember : guild2.getMembers()) {
                GuildRole guildRole = this.getGuildRole(guildMember.getRole().getLevel());
                if (guildRole != null) {
                    guildMember.setRole(guildRole);
                } else {
                    guildMember.setRole(this.getLowestGuildRole());
                    LoggingUtils.severe("The player (" + guildMember.getName() + ") had a role level that doesn't exist on the server anymore. To prevent issues, they've been automatically set the the lowest role level on the server.");
                }
                this.addToMemberCache(guildMember.getUuid(), guild2.getId());
            }
        }
    }

    private void loadRoles() {
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)new File(this.guildsPlugin.getDataFolder(), "roles.yml"));
        ConfigurationSection configurationSection = yamlConfiguration.getConfigurationSection("roles");
        for (String string : configurationSection.getKeys(false)) {
            String string2 = string + ".permissions.";
            String string3 = configurationSection.getString(string + ".name");
            String string4 = configurationSection.getString(string + ".permission-node");
            int n = Integer.parseInt(string);
            GuildRole guildRole = new GuildRole(string3, string4, n);
            for (GuildRolePerm guildRolePerm : GuildRolePerm.values()) {
                String string5 = string2 + guildRolePerm.name().replace("_", "-").toLowerCase();
                if (!configurationSection.getBoolean(string5)) continue;
                guildRole.addPerm(guildRolePerm);
            }
            this.roles.add(guildRole);
        }
    }

    private void loadTiers() {
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)new File(this.guildsPlugin.getDataFolder(), "tiers.yml"));
        ConfigurationSection configurationSection = yamlConfiguration.getConfigurationSection("tiers.list");
        for (String string : configurationSection.getKeys(false)) {
            this.tiers.add(GuildTier.builder().level(configurationSection.getInt(string + ".level")).name(configurationSection.getString(string + ".name")).cost(configurationSection.getDouble(string + ".cost", 1000.0)).maxMembers(configurationSection.getInt(string + ".max-members", 10)).vaultAmount(configurationSection.getInt(string + ".vault-amount", 1)).mobXpMultiplier(configurationSection.getDouble(string + ".mob-xp-multiplier", 1.0)).damageMultiplier(configurationSection.getDouble(string + ".damage-multiplier", 1.0)).maxBankBalance(configurationSection.getDouble(string + ".max-bank-balance", 10000.0)).membersToRankup(configurationSection.getInt(string + ".members-to-rankup", 5)).maxAllies(configurationSection.getInt(string + ".max-allies", 10)).useBuffs(configurationSection.getBoolean(string + ".use-buffs", true)).permissions(configurationSection.getStringList(string + ".permissions")).build());
        }
    }

    public void saveData() {
        this.guilds.values().forEach(this::saveVaultCache);
        this.guildsPlugin.getDatabase().getGuildAdapter().saveGuilds(this.guilds.values());
    }

    public void addGuild(@NotNull Guild guild) {
        this.guilds.put(guild.getId(), guild);
        this.createVaultCache(guild);
    }

    public void removeGuild(@NotNull Guild guild) {
        this.vaults.remove(guild);
        guild.getMembers().forEach(guildMember -> this.removeFromMemberCache(guildMember.getUuid()));
        this.guilds.remove(guild.getId());
        try {
            this.guildsPlugin.getDatabase().getGuildAdapter().deleteGuild(guild.getId().toString());
        }
        catch (IOException iOException) {
            LoggingUtils.warn("There was an error deleting a guild with the following uuid: " + guild.getId());
            iOException.printStackTrace();
        }
    }

    @Nullable
    public Guild getGuild(@NotNull String string) {
        return this.guilds.values().stream().filter(guild -> ACFBukkitUtil.removeColors(guild.getName()).equals(string)).findFirst().orElse(null);
    }

    @Nullable
    public Guild getGuild(@NotNull OfflinePlayer offlinePlayer) {
        return this.getGuildByPlayerId(offlinePlayer.getUniqueId());
    }

    @Nullable
    public Guild getGuild(@NotNull UUID uUID) {
        return this.guilds.get(uUID);
    }

    @Nullable
    public Guild getGuildByPlayerId(@NotNull UUID uUID) {
        UUID uUID2 = this.memberCache.get(uUID);
        return uUID2 == null ? null : this.guilds.get(uUID2);
    }

    @Nullable
    public Guild getGuildByCode(@NotNull String string) {
        return this.guilds.values().stream().filter(guild -> guild.hasInviteCode(string)).findFirst().orElse(null);
    }

    @Nullable
    public GuildMember getGuildMember(@NotNull UUID uUID) {
        Guild guild = this.getGuildByPlayerId(uUID);
        return guild == null ? null : guild.getMember(uUID);
    }

    public String getNameById(@NotNull UUID uUID) {
        return ACFBukkitUtil.removeColors(this.getGuild(uUID).getName());
    }

    @Nullable
    public GuildTier getGuildTier(int n) {
        return this.tiers.stream().filter(guildTier -> guildTier.getLevel() == n).findFirst().orElse(null);
    }

    @Nullable
    public GuildRole getGuildRole(int n) {
        return this.roles.stream().filter(guildRole -> guildRole.getLevel() == n).findFirst().orElse(null);
    }

    public void addAlly(Guild guild, Guild guild2) {
        guild.addAlly(guild2);
        guild2.addAlly(guild);
        this.removePendingAlly(guild, guild2);
    }

    public boolean isAlly(Guild guild, Guild guild2) {
        return guild.getAllies().contains(guild2.getId());
    }

    public boolean isAlly(Player player, Player player2) {
        Guild guild = this.getGuild((OfflinePlayer)player);
        Guild guild2 = this.getGuild((OfflinePlayer)player2);
        if (guild == null || guild2 == null) {
            return false;
        }
        return guild.getAllies().contains(guild2.getId());
    }

    public boolean isSameGuild(@NotNull Player player, @NotNull Player player2) {
        Guild guild = this.getGuild((OfflinePlayer)player);
        Guild guild2 = this.getGuild((OfflinePlayer)player2);
        if (guild == null || guild2 == null) {
            return false;
        }
        return guild.getId().equals(guild2.getId());
    }

    public boolean isSameGuild(@NotNull Guild guild, @NotNull Guild guild2) {
        return guild.getId().equals(guild2.getId());
    }

    public void removeAlly(@NotNull Guild guild, @NotNull Guild guild2) {
        guild.removeAlly(guild2);
        guild2.removeAlly(guild);
    }

    public void addPendingAlly(Guild guild, Guild guild2) {
        guild.addPendingAlly(guild2);
        guild2.addPendingAlly(guild);
    }

    public void removePendingAlly(Guild guild, Guild guild2) {
        guild.removePendingAlly(guild2);
        guild2.removePendingAlly(guild);
    }

    public int getGuildsSize() {
        return this.guilds.size();
    }

    public int getMaxTierLevel() {
        return this.tiers.size();
    }

    public boolean isMaxTier(Guild guild) {
        return guild.getTier().getLevel() >= this.getMaxTierLevel();
    }

    public GuildRole getLowestGuildRole() {
        return this.roles.get(this.roles.size() - 1);
    }

    public GuildTier getLowestGuildTier() {
        return this.tiers.get(0);
    }

    public void upgradeTier(Guild guild) {
        guild.setTier(this.getGuildTier(guild.getTier().getLevel() + 1));
    }

    public List<String> getInvitedGuilds(OfflinePlayer offlinePlayer) {
        return this.guilds.values().stream().filter(guild -> guild.getInvitedMembers().contains(offlinePlayer.getUniqueId())).map(Guild::getName).collect(Collectors.toList());
    }

    public List<String> getGuildNames() {
        return this.guilds.values().stream().map(Guild::getName).map(ACFBukkitUtil::removeColors).collect(Collectors.toList());
    }

    private void createVaultCache(@NotNull Guild guild) {
        ArrayList arrayList = new ArrayList();
        if (guild.getVaults() == null) {
            return;
        }
        guild.getVaults().forEach(string -> {
            try {
                arrayList.add(Serialization.deserializeInventory(string, this.settingsManager));
            }
            catch (InvalidConfigurationException invalidConfigurationException) {
                invalidConfigurationException.printStackTrace();
            }
        });
        this.vaults.put(guild, arrayList);
    }

    private void saveVaultCache(@NotNull Guild guild) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (guild.getVaults() == null) {
            return;
        }
        this.vaults.get(guild).forEach(inventory -> arrayList.add(Serialization.serializeInventory(inventory)));
        guild.setVaults(arrayList);
    }

    public Inventory getGuildVault(Guild guild, int n) {
        return this.vaults.get(guild).get(n - 1);
    }

    private boolean isSpy(@NotNull Player player) {
        return this.spies.contains(player);
    }

    private void addSpy(PaperCommandManager paperCommandManager, Player player) {
        this.spies.add(player);
        paperCommandManager.getCommandIssuer(player).sendInfo(Messages.ADMIN__SPY_ON, new String[0]);
    }

    public void removeSpy(PaperCommandManager paperCommandManager, Player player) {
        this.spies.remove(player);
        paperCommandManager.getCommandIssuer(player).sendInfo(Messages.ADMIN__SPY_OFF, new String[0]);
    }

    public void toggleSpy(PaperCommandManager paperCommandManager, Player player) {
        if (this.isSpy(player)) {
            this.removeSpy(paperCommandManager, player);
        } else {
            this.addSpy(paperCommandManager, player);
        }
    }

    public void chatLogout(Player player) {
        this.spies.remove(player);
        this.guildsPlugin.getChatListener().getPlayerChatMap().remove(player.getUniqueId());
    }

    public void chatLogout() {
        this.spies.clear();
        this.guildsPlugin.getChatListener().getPlayerChatMap().clear();
    }

    public void checkInvites(PaperCommandManager paperCommandManager, Player player) {
        List<String> list2 = this.getInvitedGuilds((OfflinePlayer)player);
        if (list2.isEmpty()) {
            paperCommandManager.getCommandIssuer(player).sendInfo(Messages.ERROR__NO_PENDING_INVITES, new String[0]);
            return;
        }
        paperCommandManager.getCommandIssuer(player).sendInfo(Messages.PENDING__INVITES, "{number}", String.valueOf(list2.size()), "{guilds}", String.join((CharSequence)",", list2));
    }

    public boolean memberCheck(Guild guild) {
        GuildTier guildTier = guild.getTier();
        return guildTier.getMembersToRankup() != 0 && guild.getMembers().size() < guildTier.getMembersToRankup();
    }

    public boolean nameCheck(String string, SettingsManager settingsManager) {
        String string2 = settingsManager.getProperty(GuildSettings.NAME_REQUIREMENTS);
        if (!settingsManager.getProperty(GuildSettings.INCLUDE_COLOR_CODES).booleanValue()) {
            String string3 = StringUtils.color(string);
            return ChatColor.stripColor((String)string3).matches(string2);
        }
        return string.matches(string2);
    }

    public boolean prefixCheck(String string, SettingsManager settingsManager) {
        String string2 = settingsManager.getProperty(GuildSettings.PREFIX_REQUIREMENTS);
        if (!settingsManager.getProperty(GuildSettings.INCLUDE_COLOR_CODES).booleanValue()) {
            String string3 = StringUtils.color(string);
            return ChatColor.stripColor((String)string3).matches(string2);
        }
        return string.matches(string2);
    }

    public boolean blacklistCheck(String string, SettingsManager settingsManager) {
        if (settingsManager.getProperty(GuildSettings.BLACKLIST_SENSITIVE).booleanValue()) {
            return settingsManager.getProperty(GuildSettings.BLACKLIST_WORDS).stream().anyMatch(string2 -> string2.toLowerCase().contains(string));
        }
        return settingsManager.getProperty(GuildSettings.BLACKLIST_WORDS).stream().anyMatch(string2 -> string2.equalsIgnoreCase(string));
    }

    public boolean hasVaultUnlocked(int n, Guild guild) {
        return n <= this.getGuildTier(guild.getTier().getLevel()).getVaultAmount();
    }

    public Inventory createNewVault(SettingsManager settingsManager) {
        return Bukkit.createInventory(null, (int)54, (String)StringUtils.color(settingsManager.getProperty(GuildVaultSettings.VAULT_NAME)));
    }

    public List<Player> getOnlineInviters(Guild guild) {
        List list2 = guild.getOnlineMembers().stream().filter(guildMember -> guildMember.getRole().hasPerm(GuildRolePerm.INVITE)).collect(Collectors.toList());
        return list2.stream().map(GuildMember::getAsPlayer).collect(Collectors.toList());
    }

    public void pingOnlineInviters(Guild guild, PaperCommandManager paperCommandManager, Player player) {
        this.getOnlineInviters(guild).forEach(player2 -> paperCommandManager.getCommandIssuer(player2).sendInfo(Messages.REQUEST__INCOMING_REQUEST, "{player}", player.getName()));
    }

    public ItemStack getUpgradeTicket(SettingsManager settingsManager, int n) {
        ItemBuilder itemBuilder = new ItemBuilder(Material.valueOf((String)settingsManager.getProperty(TicketSettings.TICKET_MATERIAL)));
        itemBuilder.setAmount(n);
        itemBuilder.setName(StringUtils.color(settingsManager.getProperty(TicketSettings.TICKET_NAME)));
        itemBuilder.setLore(settingsManager.getProperty(TicketSettings.TICKET_LORE).stream().map(StringUtils::color).collect(Collectors.toList()));
        return itemBuilder.build();
    }

    public ItemStack matchTicket(SettingsManager settingsManager) {
        ItemBuilder itemBuilder = new ItemBuilder(Material.valueOf((String)settingsManager.getProperty(TicketSettings.TICKET_MATERIAL)));
        itemBuilder.setAmount(1);
        itemBuilder.setName(StringUtils.color(settingsManager.getProperty(TicketSettings.TICKET_NAME)));
        itemBuilder.setLore(settingsManager.getProperty(TicketSettings.TICKET_LORE).stream().map(StringUtils::color).collect(Collectors.toList()));
        return itemBuilder.build();
    }

    public boolean checkIfFull(Guild guild) {
        return guild.getSize() >= this.getGuildTier(guild.getTier().getLevel()).getMaxMembers();
    }

    public void removePerms(Permission permission, OfflinePlayer offlinePlayer, List<String> list2) {
        if (this.settingsManager.getProperty(PluginSettings.RUN_VAULT_ASYNC).booleanValue()) {
            Guilds.newChain().async(() -> {
                for (String string : list2) {
                    if (string.equals("")) continue;
                    permission.playerRemove(null, offlinePlayer, string);
                }
            }).execute();
        } else {
            for (String string : list2) {
                if (string.equals("")) continue;
                permission.playerRemove(null, offlinePlayer, string);
            }
        }
    }

    public void addPerms(Permission permission, OfflinePlayer offlinePlayer, List<String> list2) {
        if (this.settingsManager.getProperty(PluginSettings.RUN_VAULT_ASYNC).booleanValue()) {
            Guilds.newChain().async(() -> {
                for (String string : list2) {
                    if (string.equals("")) continue;
                    permission.playerAdd(null, offlinePlayer, string);
                }
            }).execute();
        } else {
            for (String string : list2) {
                if (string.equals("")) continue;
                permission.playerAdd(null, offlinePlayer, string);
            }
        }
    }

    public void addGuildPerms(Permission permission, OfflinePlayer offlinePlayer) {
        Guild guild = this.getGuild(offlinePlayer);
        if (guild == null) {
            return;
        }
        GuildTier guildTier = this.getGuildTier(guild.getTier().getLevel());
        if (guildTier.getPermissions().isEmpty()) {
            return;
        }
        this.addPerms(permission, offlinePlayer, guildTier.getPermissions());
    }

    public void removeGuildPerms(Permission permission, OfflinePlayer offlinePlayer) {
        Guild guild = this.getGuild(offlinePlayer);
        if (guild == null) {
            return;
        }
        GuildTier guildTier = this.getGuildTier(guild.getTier().getLevel());
        if (guildTier.getPermissions().isEmpty()) {
            return;
        }
        this.removePerms(permission, offlinePlayer, guildTier.getPermissions());
    }

    public void addRolePerm(Permission permission, OfflinePlayer offlinePlayer) {
        Guild guild = this.getGuild(offlinePlayer);
        if (guild == null) {
            return;
        }
        GuildMember guildMember = guild.getMember(offlinePlayer.getUniqueId());
        GuildRole guildRole = guildMember.getRole();
        this.addPerms(permission, offlinePlayer, Collections.singletonList(guildRole.getNode()));
    }

    public void removeRolePerm(Permission permission, OfflinePlayer offlinePlayer) {
        Guild guild = this.getGuild(offlinePlayer);
        if (guild == null) {
            return;
        }
        GuildMember guildMember = guild.getMember(offlinePlayer.getUniqueId());
        GuildRole guildRole = guildMember.getRole();
        this.removePerms(permission, offlinePlayer, Collections.singletonList(guildRole.getNode()));
    }

    public void addGuildPermsToAll(Permission permission, Guild guild) {
        GuildTier guildTier = this.getGuildTier(guild.getTier().getLevel());
        if (guildTier.getPermissions().isEmpty()) {
            return;
        }
        for (OfflinePlayer offlinePlayer : guild.getAllAsPlayers()) {
            this.addPerms(permission, offlinePlayer, guildTier.getPermissions());
        }
    }

    public void removeGuildPermsFromAll(Permission permission, Guild guild) {
        GuildTier guildTier = this.getGuildTier(guild.getTier().getLevel());
        if (guildTier.getPermissions().isEmpty()) {
            return;
        }
        for (OfflinePlayer offlinePlayer : guild.getAllAsPlayers()) {
            this.removePerms(permission, offlinePlayer, guildTier.getPermissions());
        }
    }

    public void removeRolePermsFromAll(Permission permission, Guild guild) {
        for (OfflinePlayer offlinePlayer : guild.getAllAsPlayers()) {
            GuildRole guildRole = guild.getMember(offlinePlayer.getUniqueId()).getRole();
            this.removePerms(permission, offlinePlayer, Collections.singletonList(guildRole.getNode()));
        }
    }

    public void handleInvite(PaperCommandManager paperCommandManager, Player player, Guild guild, GuildCode guildCode) {
        if (guildCode.getUses() <= 0) {
            ACFUtil.sneaky(new ExpectationNotMet(Messages.CODES__OUT));
        }
        guildCode.addRedeemer(player);
        guild.addMemberByCode(new GuildMember(player.getUniqueId(), this.getLowestGuildRole()));
        this.addToMemberCache(player.getUniqueId(), guild.getId());
        if (ClaimUtils.isEnabled(this.settingsManager)) {
            WorldGuardWrapper worldGuardWrapper = WorldGuardWrapper.getInstance();
            ClaimUtils.getGuildClaim(worldGuardWrapper, player, guild).ifPresent(iWrappedRegion -> ClaimUtils.addMember(iWrappedRegion, player));
        }
        paperCommandManager.getCommandIssuer(player).sendInfo(Messages.CODES__JOINED, "{guild}", guild.getName());
        guild.sendMessage(paperCommandManager, Messages.CODES__GUILD_MESSAGE, "{player}", player.getName(), "{creator}", Bukkit.getOfflinePlayer((UUID)guildCode.getCreator()).getName());
    }

    public void handleCodeList(PaperCommandManager paperCommandManager, Player player, List<GuildCode> list2) {
        list2.forEach(guildCode -> paperCommandManager.getCommandIssuer(player).sendInfo(Messages.CODES__LIST_ITEM, "{code}", guildCode.getId(), "{amount}", String.valueOf(guildCode.getUses()), "{creator}", Bukkit.getOfflinePlayer((UUID)guildCode.getCreator()).getName()));
    }

    public void removeAlliesOnDelete(Guild guild) {
        this.getGuilds().values().forEach(guild2 -> guild2.getPendingAllies().removeIf(uUID -> uUID.equals(guild.getId())));
        this.getGuilds().values().forEach(guild2 -> guild2.getAllies().removeIf(uUID -> uUID.equals(guild.getId())));
    }

    public void notifyAllies(Guild guild, PaperCommandManager paperCommandManager) {
        guild.getAllies().forEach(uUID -> this.getGuild((UUID)uUID).sendMessage(paperCommandManager, Messages.DELETE__NOTIFY_ALLIES, "{guild}", guild.getName()));
    }

    public List<String> getPublicGuilds() {
        return this.guilds.values().stream().filter(guild -> !guild.isPrivate()).map(Guild::getName).collect(Collectors.toList());
    }

    public List<String> getJoinableGuild(Player player) {
        return Stream.concat(this.getInvitedGuilds((OfflinePlayer)player).stream(), this.getPublicGuilds().stream()).map(ACFBukkitUtil::removeColors).collect(Collectors.toList());
    }

    public boolean checkGuildNames(String string) {
        return this.guilds.values().stream().anyMatch(guild -> guild.getName().equalsIgnoreCase(string));
    }

    public void handleGuildChat(Guild guild, Player player, String string) {
        String string2 = this.settingsManager.getProperty(GuildSettings.GUILD_CHAT_FORMAT);
        String string3 = this.settingsManager.getProperty(GuildSettings.SPY_CHAT_FORMAT);
        boolean bl = this.settingsManager.getProperty(GuildSettings.LOG_GUILD_CHAT);
        guild.sendMessage(this.chatGenerator(guild, player, string2, string));
        for (Player player2 : this.spies) {
            player2.sendMessage(this.chatGenerator(guild, player, string3, string));
        }
        if (bl) {
            LoggingUtils.info(this.chatGenerator(guild, player, string3, string));
        }
    }

    public void handleAllyChat(Guild guild, Player player, String string) {
        String string2 = this.settingsManager.getProperty(GuildSettings.ALLY_CHAT_FORMAT);
        String string3 = this.settingsManager.getProperty(GuildSettings.SPY_CHAT_FORMAT);
        boolean bl = this.settingsManager.getProperty(GuildSettings.LOG_ALLY_CHAT);
        guild.sendMessage(this.chatGenerator(guild, player, string2, string));
        for (UUID uUID : guild.getAllies()) {
            Guild guild2 = this.getGuild(uUID);
            guild2.sendMessage(this.chatGenerator(guild, player, string2, string));
        }
        for (Player player2 : this.spies) {
            player2.sendMessage(this.chatGenerator(guild, player, string3, string));
        }
        if (bl) {
            LoggingUtils.info(this.chatGenerator(guild, player, string3, string));
        }
    }

    private String chatGenerator(Guild guild, Player player, String string, String string2) {
        GuildRole guildRole = this.getGuildRole(guild.getMember(player.getUniqueId()).getRole().getLevel());
        String string3 = StringUtils.color(string.replace("{role}", guildRole.getName()).replace("{player}", player.getName()).replace("{display-name}", player.getDisplayName()).replace("{message}", string2).replace("{guild}", guild.getName()));
        if (this.hasPapi()) {
            string3 = PlaceholderAPI.setPlaceholders((Player)player, (String)string3);
        }
        return string3;
    }

    public String getFormattedPlaceholder(Player player) {
        String string = this.settingsManager.getProperty(GuildSettings.FORMAT_BRACKET_LEFT);
        String string2 = this.settingsManager.getProperty(GuildSettings.FORMAT_CONTENT);
        String string3 = this.settingsManager.getProperty(GuildSettings.FORMAT_NO_GUILD);
        String string4 = this.settingsManager.getProperty(GuildSettings.FORMAT_BRACKET_RIGHT);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string).append(string2).append(string4);
        String string5 = stringBuilder.toString();
        Guild guild = this.getGuild((OfflinePlayer)player);
        if (guild == null) {
            return string3;
        }
        return StringUtils.color(string5.replace("{name}", guild.getName()).replace("{prefix}", guild.getPrefix()));
    }

    public void removeFromChat(UUID uUID) {
        this.guildsPlugin.getChatListener().getPlayerChatMap().remove(uUID);
    }

    public void addToMemberCache(UUID uUID, UUID uUID2) {
        this.memberCache.put(uUID, uUID2);
    }

    public void removeFromMemberCache(UUID uUID) {
        this.memberCache.remove(uUID);
    }

    public Guilds getGuildsPlugin() {
        return this.guildsPlugin;
    }

    public Map<UUID, Guild> getGuilds() {
        return this.guilds;
    }

    public List<Player> getSpies() {
        return this.spies;
    }

    public List<GuildTier> getTiers() {
        return this.tiers;
    }

    public List<GuildRole> getRoles() {
        return this.roles;
    }

    public Map<Guild, List<Inventory>> getVaults() {
        return this.vaults;
    }

    public List<Player> getOpened() {
        return this.opened;
    }

    public boolean isMigrating() {
        return this.migrating;
    }

    public void setMigrating(boolean bl) {
        this.migrating = bl;
    }

    public Map<UUID, String> getLookupCache() {
        return this.lookupCache;
    }

    public boolean hasPapi() {
        return this.papi;
    }

    public void setPapi(boolean bl) {
        this.papi = bl;
    }
}

