/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.guild;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import java.lang.reflect.InvocationTargetException;
import java.util.Base64;
import java.util.Iterator;
import me.glaremasters.guilds.utils.SkullUtils;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class GuildSkull {
    private final String serialized;
    private transient ItemStack itemStack;

    public GuildSkull(Player player) {
        this.serialized = SkullUtils.getEncoded(this.getTextureUrl(player));
        this.itemStack = SkullUtils.getSkull(this.serialized);
    }

    public GuildSkull(String string) {
        this.serialized = SkullUtils.getEncoded("https://textures.minecraft.net/texture/" + string);
        this.itemStack = SkullUtils.getSkull(this.serialized);
    }

    private String getTextureUrl(Player player) {
        GameProfile gameProfile = this.getProfile(player);
        if (gameProfile == null) {
            return "";
        }
        PropertyMap propertyMap = gameProfile.getProperties();
        Iterator iterator = propertyMap.get((Object)"textures").iterator();
        if (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            byte[] byArray = Base64.getDecoder().decode(property.getValue());
            JsonObject jsonObject = new JsonParser().parse(new String(byArray)).getAsJsonObject().get("textures").getAsJsonObject().get("SKIN").getAsJsonObject();
            return jsonObject.get("url").getAsString();
        }
        return "";
    }

    private GameProfile getProfile(Player player) {
        try {
            Class<?> clazz = Class.forName("org.bukkit.craftbukkit." + this.getServerVersion() + ".entity.CraftPlayer");
            return (GameProfile)clazz.cast(player).getClass().getMethod("getProfile", new Class[0]).invoke(clazz.cast(player), new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            reflectiveOperationException.printStackTrace();
            return null;
        }
    }

    private String getServerVersion() {
        try {
            return Bukkit.getServer().getClass().getPackage().getName().replace(".", ",").split(",")[3];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return "unknown";
        }
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public String getSerialized() {
        return this.serialized;
    }
}

