/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.commands;

import com.destroystokyo.paper.event.server.AsyncTabCompleteEvent;
import java.util.Arrays;
import java.util.List;
import me.glaremasters.guilds.libs.commands.ACFPatterns;
import me.glaremasters.guilds.libs.commands.ACFUtil;
import me.glaremasters.guilds.libs.commands.BukkitCommandIssuer;
import me.glaremasters.guilds.libs.commands.CommandCompletions;
import me.glaremasters.guilds.libs.commands.LogLevel;
import me.glaremasters.guilds.libs.commands.PaperCommandManager;
import me.glaremasters.guilds.libs.commands.RootCommand;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

class PaperAsyncTabCompleteHandler
implements Listener {
    private final PaperCommandManager manager;

    PaperAsyncTabCompleteHandler(PaperCommandManager paperCommandManager) {
        this.manager = paperCommandManager;
        paperCommandManager.log(LogLevel.INFO, "Enabled Asynchronous Tab Completion Support!");
    }

    @EventHandler(ignoreCancelled=true)
    public void onAsyncTabComplete(AsyncTabCompleteEvent asyncTabCompleteEvent) {
        block5: {
            String string = asyncTabCompleteEvent.getBuffer();
            if (!asyncTabCompleteEvent.isCommand() && !string.startsWith("/") || string.indexOf(32) == -1) {
                return;
            }
            try {
                List<String> list2 = this.getCompletions(string, asyncTabCompleteEvent.getCompletions(), asyncTabCompleteEvent.getSender(), true);
                if (list2 != null) {
                    if (list2.size() == 1 && list2.get(0).equals("")) {
                        list2.set(0, " ");
                    }
                    asyncTabCompleteEvent.setCompletions(list2);
                    asyncTabCompleteEvent.setHandled(true);
                }
            }
            catch (Exception exception) {
                if (exception instanceof CommandCompletions.SyncCompletionRequired) break block5;
                throw exception;
            }
        }
    }

    private List<String> getCompletions(String string, List<String> list2, CommandSender commandSender, boolean bl) {
        String[] stringArray;
        String[] stringArray2 = ACFPatterns.SPACE.split(string, -1);
        String string2 = PaperAsyncTabCompleteHandler.stripLeadingSlash(stringArray2[0]);
        if (stringArray2.length > 1) {
            stringArray = Arrays.copyOfRange(stringArray2, 1, stringArray2.length);
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = "";
        }
        stringArray2 = stringArray;
        RootCommand rootCommand = this.manager.getRootCommand(string2);
        if (rootCommand == null) {
            return null;
        }
        BukkitCommandIssuer bukkitCommandIssuer = this.manager.getCommandIssuer(commandSender);
        List<String> list4 = rootCommand.getTabCompletions(bukkitCommandIssuer, string2, stringArray2, false, bl);
        return ACFUtil.preformOnImmutable(list2, list3 -> list3.addAll(list4));
    }

    private static String stripLeadingSlash(String string) {
        return string.startsWith("/") ? string.substring(1) : string;
    }
}

