/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.configme;

import java.io.File;
import java.nio.file.Path;
import java.util.Objects;
import javax.annotation.Nullable;
import me.glaremasters.guilds.libs.configme.SettingsHolder;
import me.glaremasters.guilds.libs.configme.SettingsManager;
import me.glaremasters.guilds.libs.configme.SettingsManagerImpl;
import me.glaremasters.guilds.libs.configme.configurationdata.ConfigurationData;
import me.glaremasters.guilds.libs.configme.configurationdata.ConfigurationDataBuilder;
import me.glaremasters.guilds.libs.configme.migration.MigrationService;
import me.glaremasters.guilds.libs.configme.migration.PlainMigrationService;
import me.glaremasters.guilds.libs.configme.resource.PropertyResource;
import me.glaremasters.guilds.libs.configme.resource.YamlFileResource;
import me.glaremasters.guilds.libs.configme.resource.YamlFileResourceOptions;
import me.glaremasters.guilds.libs.configme.utils.Utils;

public final class SettingsManagerBuilder {
    private final PropertyResource resource;
    private ConfigurationData configurationData;
    private MigrationService migrationService;

    private SettingsManagerBuilder(PropertyResource propertyResource) {
        this.resource = propertyResource;
    }

    public static SettingsManagerBuilder withYamlFile(Path path) {
        return SettingsManagerBuilder.withYamlFile(path, YamlFileResourceOptions.builder().build());
    }

    public static SettingsManagerBuilder withYamlFile(File file) {
        return SettingsManagerBuilder.withYamlFile(file.toPath());
    }

    public static SettingsManagerBuilder withYamlFile(Path path, YamlFileResourceOptions yamlFileResourceOptions) {
        Utils.createFileIfNotExists(path);
        return new SettingsManagerBuilder(new YamlFileResource(path, yamlFileResourceOptions));
    }

    public static SettingsManagerBuilder withYamlFile(File file, YamlFileResourceOptions yamlFileResourceOptions) {
        return SettingsManagerBuilder.withYamlFile(file.toPath(), yamlFileResourceOptions);
    }

    public static SettingsManagerBuilder withResource(PropertyResource propertyResource) {
        return new SettingsManagerBuilder(propertyResource);
    }

    @SafeVarargs
    public final SettingsManagerBuilder configurationData(Class<? extends SettingsHolder> ... classArray) {
        this.configurationData = ConfigurationDataBuilder.createConfiguration(classArray);
        return this;
    }

    public SettingsManagerBuilder configurationData(ConfigurationData configurationData) {
        this.configurationData = configurationData;
        return this;
    }

    public SettingsManagerBuilder migrationService(@Nullable MigrationService migrationService) {
        this.migrationService = migrationService;
        return this;
    }

    public SettingsManagerBuilder useDefaultMigrationService() {
        this.migrationService = new PlainMigrationService();
        return this;
    }

    public SettingsManager create() {
        Objects.requireNonNull(this.resource, "resource");
        Objects.requireNonNull(this.configurationData, "configurationData");
        return new SettingsManagerImpl(this.resource, this.configurationData, this.migrationService);
    }
}

