/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.configme.beanmapper;

import me.glaremasters.guilds.libs.configme.beanmapper.MappingContext;
import me.glaremasters.guilds.libs.configme.properties.convertresult.ConvertErrorRecorder;
import me.glaremasters.guilds.libs.configme.utils.TypeInformation;

public class MappingContextImpl
implements MappingContext {
    private final String path;
    private final TypeInformation typeInformation;
    private final ConvertErrorRecorder errorRecorder;

    protected MappingContextImpl(String string, TypeInformation typeInformation, ConvertErrorRecorder convertErrorRecorder) {
        this.path = string;
        this.typeInformation = typeInformation;
        this.errorRecorder = convertErrorRecorder;
    }

    public static MappingContextImpl createRoot(TypeInformation typeInformation, ConvertErrorRecorder convertErrorRecorder) {
        return new MappingContextImpl("", typeInformation, convertErrorRecorder);
    }

    @Override
    public MappingContext createChild(String string, TypeInformation typeInformation) {
        if (this.path.isEmpty()) {
            return new MappingContextImpl(string, typeInformation, this.errorRecorder);
        }
        return new MappingContextImpl(this.path + "." + string, typeInformation, this.errorRecorder);
    }

    @Override
    public TypeInformation getTypeInformation() {
        return this.typeInformation;
    }

    @Override
    public String createDescription() {
        return "Path: '" + this.path + "', type: '" + this.typeInformation.getType() + "'";
    }

    @Override
    public void registerError(String string) {
        this.errorRecorder.setHasError("At path '" + this.path + "': " + string);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.createDescription() + "]";
    }
}

