/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.configme.beanmapper.leafvaluehandler;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.annotation.Nullable;
import me.glaremasters.guilds.libs.configme.beanmapper.leafvaluehandler.AbstractLeafValueHandler;

public class BigNumberLeafValueHandler
extends AbstractLeafValueHandler {
    private static final BigDecimal BIG_DECIMAL_SCIENTIFIC_THRESHOLD = new BigDecimal("1E100");

    @Override
    protected Object convert(Class<?> clazz, Object object) {
        if (clazz != BigInteger.class && clazz != BigDecimal.class) {
            return null;
        }
        if (object instanceof String) {
            return this.fromString(clazz, (String)object);
        }
        if (object instanceof Number) {
            return this.fromNumber(clazz, (Number)object);
        }
        return null;
    }

    @Override
    public Object toExportValue(Object object) {
        Class<?> clazz;
        Class<?> clazz2 = clazz = object == null ? null : object.getClass();
        if (clazz == BigInteger.class) {
            return object.toString();
        }
        if (clazz == BigDecimal.class) {
            BigDecimal bigDecimal = (BigDecimal)object;
            return bigDecimal.abs().compareTo(BIG_DECIMAL_SCIENTIFIC_THRESHOLD) >= 0 ? bigDecimal.toString() : bigDecimal.toPlainString();
        }
        return null;
    }

    @Nullable
    protected Object fromString(Class<?> clazz, String string) {
        try {
            return clazz == BigInteger.class ? new BigInteger(string) : new BigDecimal(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    protected Object fromNumber(Class<?> clazz, Number number) {
        if (clazz.isInstance(number)) {
            return number;
        }
        if (clazz == BigInteger.class) {
            if (number instanceof Double || number instanceof Float) {
                return BigDecimal.valueOf(number.doubleValue()).toBigInteger();
            }
            return BigInteger.valueOf(number.longValue());
        }
        if (number instanceof Integer || number instanceof Long) {
            return BigDecimal.valueOf(number.longValue());
        }
        return BigDecimal.valueOf(number.doubleValue()).stripTrailingZeros();
    }
}

