/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.configme.beanmapper.propertydescription;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.Nullable;
import me.glaremasters.guilds.libs.configme.beanmapper.ConfigMeMapperException;
import me.glaremasters.guilds.libs.configme.beanmapper.propertydescription.BeanPropertyDescription;
import me.glaremasters.guilds.libs.configme.utils.TypeInformation;

public class BeanPropertyDescriptionImpl
implements BeanPropertyDescription {
    private final String name;
    private final TypeInformation typeInformation;
    private final Method getter;
    private final Method setter;

    public BeanPropertyDescriptionImpl(String string, TypeInformation typeInformation, Method method, Method method2) {
        this.name = string;
        this.typeInformation = typeInformation;
        this.getter = method;
        this.setter = method2;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public TypeInformation getTypeInformation() {
        return this.typeInformation;
    }

    @Override
    @Nullable
    public Object getValue(Object object) {
        try {
            return this.getter.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            throw new ConfigMeMapperException("Could not get property '" + this.name + "' from instance '" + object + "'", reflectiveOperationException);
        }
    }

    @Override
    public void setValue(Object object, Object object2) {
        try {
            this.setter.invoke(object, object2);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            throw new ConfigMeMapperException("Could not set property '" + this.name + "' to value '" + object2 + "' on instance '" + object + "'", reflectiveOperationException);
        }
    }

    public String toString() {
        return "Bean property '" + this.name + "' with getter '" + this.getter + "'";
    }
}

